/***************************************************************************
                          tabgrip.cpp  -  description
                             -------------------
    begin                : Fri Sep 13 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tabgrip.moc"
#include "resource.h"
#include <tqpainter.h>

TabGrip::TabGrip(TQWidget *parent, const char *name ) : TQWidget(parent,name)
{
	setMaximumSize( 3200, 12 );
	setMinimumSize( 32, 12 );

	isDragging = FALSE;
	couldDrag = FALSE;

	setCursor( TQt::SizeAllCursor );

	show();
}
TabGrip::~TabGrip()
{
}
///////////////////////////////////////
//
//	TabGrip::paintEvent
//
///////////////////////////////////////
void TabGrip::paintEvent( TQPaintEvent* )
{
	TQPainter paint( this );
	TQColorGroup group( colorGroup() );
	paint.setPen( group.light() );
	paint.drawLine( 2, 2, width() - 3, 2 );
	paint.drawLine( 2, 5, width() - 3, 5 );
	paint.drawLine( 2, 8, width() - 3, 8 );
	paint.setPen( group.dark() );
	paint.drawLine( 2, 3, width() - 3, 3 );
	paint.drawLine( 2, 6, width() - 3, 6 );
	paint.drawLine( 2, 9, width() - 3, 9 );
}
///////////////////////////////////////
//
//	TabGrip::mousePressEvent
//
///////////////////////////////////////
void TabGrip::mousePressEvent( TQMouseEvent *event )
{
	event->accept();
	if(event->button() == Qt::LeftButton)
	{
		couldDrag = TRUE;
		offset = mapToGlobal( event->pos() );
		offset.setX( topLevelWidget()->x() - offset.x() );
		offset.setY( topLevelWidget()->y() - offset.y() );
	}
}
///////////////////////////////////////
//
//	TabGrip::mouseMoveEvent
//
///////////////////////////////////////
void TabGrip::mouseMoveEvent( TQMouseEvent *event )
{
	/*
		By default, MouseMoveEvent is never called unless the user has
		a button held down, so this should only be called if we're dragging.
	*/
	event->accept();
	if( couldDrag == TRUE )
	{
		/* Dragging Page */
		isDragging = TRUE;
		couldDrag = FALSE;
		TQApplication::setOverrideCursor( TQt::SizeAllCursor );
	}
}
///////////////////////////////////////
//
//	TabGrip::mouseReleaseEvent
//
///////////////////////////////////////
void TabGrip::mouseReleaseEvent( TQMouseEvent *event )
{
	event->accept();
	if(event->button() == Qt::LeftButton)
	{
		couldDrag = FALSE;
		if( isDragging )
		{
			TQApplication::restoreOverrideCursor();
			isDragging = FALSE;
			emit wasDragged( event->globalPos(), offset );
		}
	}
}
