import org.trinitydesktop.qt.*;

public class GameBoard extends TQWidget {
	private TQLCDNumber hits;
	private TQLCDNumber shotsLeft;
	private CannonField cannonField;

	public GameBoard() {
		TQPushButton quit = new TQPushButton("&Quit", this, "quit");
		quit.setFont(new TQFont("Times", 18, TQFont.Bold, false));

		connect(quit, SIGNAL("clicked()"), tqApp(), SLOT("quit()"));

		LCDRange angle = new LCDRange("ANGLE", this, "angle");
		angle.setRange(5, 70);

		LCDRange force = new LCDRange("FORCE", this, "force");
		force.setRange(10, 50);

		cannonField = new CannonField(this, "cannonField");

		connect(angle, SIGNAL("valueChanged(int)"),
						cannonField, SLOT("setAngle(int)"));
		connect(cannonField, SIGNAL("angleChanged(int)"),
						angle, SLOT("setValue(int)"));

		connect(force, SIGNAL("valueChanged(int)"),
						cannonField, SLOT("setForce(int)"));
		connect(cannonField, SIGNAL("forceChanged(int)"),
						force, SLOT("setValue(int)"));

		connect(cannonField, SIGNAL("hit()"),
						this, SLOT("hit()"));
		connect(cannonField, SIGNAL("missed()"),
						this, SLOT("missed()"));

		TQPushButton shoot = new TQPushButton("&Shoot", this, "shoot");
		shoot.setFont(new TQFont("Times", 18, TQFont.Bold, false));

		connect(shoot, SIGNAL("clicked()"), SLOT("fire()"));
		connect(cannonField, SIGNAL("canShoot(boolean)"),
						shoot, SLOT("setEnabled(boolean)"));

		TQPushButton restart = new TQPushButton("&New Game", this, "newgame");
		restart.setFont(new TQFont("Times", 18, TQFont.Bold, false));

		connect(restart, SIGNAL("clicked()"), this, SLOT("newGame()"));

		hits = new TQLCDNumber(2, this, "hits");
		shotsLeft = new TQLCDNumber(2, this, "shotsleft");
		TQLabel hitsL = new TQLabel("HITS", this, "hitsLabel", 0);
		TQLabel shotsLeftL = new TQLabel("SHOTS LEFT", this, "shotsleftLabel", 0);

		TQGridLayout grid = new TQGridLayout(this, 2, 2, 10, -1, null);
		grid.addWidget(quit, 0, 0);
		grid.addWidget(cannonField, 1, 1);
		grid.setColStretch(1, 10);

		TQVBoxLayout leftBox = new TQVBoxLayout();
		grid.addLayout(leftBox, 1, 0);
		leftBox.addWidget(angle);
		leftBox.addWidget(force);

		TQHBoxLayout topBox = new TQHBoxLayout();
		grid.addLayout(topBox, 0, 1);
		topBox.addWidget(shoot);
		topBox.addWidget(hits);
		topBox.addWidget(hitsL);
		topBox.addWidget(shotsLeft);
		topBox.addWidget(shotsLeftL);
		topBox.addStretch(1);
		topBox.addWidget(restart);

		angle.setValue(60);
		force.setValue(25);
		angle.setFocus();

		newGame();
	}

	protected void fire() {
		if (cannonField.gameOver() || cannonField.isShooting())
			return;
		shotsLeft.display(shotsLeft.intValue() - 1);
		cannonField.shoot();
	}

	protected void hit() {
		hits.display(hits.intValue() + 1);
		if (shotsLeft.intValue() == 0)
			cannonField.setGameOver();
		else
			cannonField.newTarget();
	}

	protected void missed() {
		if (shotsLeft.intValue() == 0)
			cannonField.setGameOver();
	}

	protected void newGame() {
		shotsLeft.display(15);
		hits.display(0);
		cannonField.restartGame();
		cannonField.newTarget();
	}
	
}
