/***************************************************************************
                            QtSupport.h -  description
                             -------------------
    begin                : Fri Oct 20 13:46:55 2000
    copyright            : (C) 2000 Lost Highway Ltd
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Oct 20 13:46:55 2000, using kdoc $.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _QT_SUPPORT_H_
#define _QT_SUPPORT_H_

#include <jni.h>

#ifndef JNIEXPORT
#define JNIEXPORT
#endif

#ifndef JNIIMPORT
#define JNIIMPORT
#endif

#ifndef JNICALL
#define JNICALL
#endif

#include <tqstrlist.h>
#include <tqstringlist.h>
#include <tqwidgetlist.h>
#include <tqdom.h>
#include <tqobjectlist.h>
#include <tqdatetime.h>
#include <tqevent.h>
#include <tqvalidator.h>
#include <tqcanvas.h>
#include <tqlistview.h>
#include <tqiconview.h>
#include <tqurlinfo.h>

class JavaSlot;
class JavaSignal;


/** A class with various static utility methods to run the C++ side
	of the Qt Java library. The functions cooperate with the Java
	methods in 'qtjava.java' and 'Invocation.java'.

	@author Richard Dale */
class QtSupport
{
public:
	QtSupport() {}
	~QtSupport() {}

	/** Save the current JavaVM pointer to make it easy to obtain the current environment later */
	static void registerJVM(JNIEnv * env);
	/** Obtain the current JNIEnv */
	static JNIEnv * GetEnv();

	/** Converts from the enum TQEvent::Type to the Java class name of the corresponding event */
	static const char * eventTypeToEventClassName(TQEvent::Type eventType);
	/** Event filter handling callback function */
	static bool eventFilterDelegate(TQObject * object, const char * objectType, TQObject * filterTarget, TQEvent * event);
	/** Event handling callback function */
	static bool eventDelegate(TQObject * object, const char * eventType, void * event, const char * eventName);
	/** Void method with no parameters. FALSE if method is implemented in Java,
	    and returns TRUE if method is not implemented in Java */
	static bool voidDelegate(void * object, const char * className, const char * methodName);
	/** Boolean method with no parameters. FALSE iff method is implemented in Java
	    and also returns FALSE. Returns TRUE if method is not implemented in Java */
	static bool booleanDelegate(TQObject * object, const char * methodName);

	/** TQValidator callbacks for validate() and fixup() */
	static int validateDelegate(TQValidator * object, TQString & input, int & pos);
	static void fixupDelegate(TQValidator * object, TQString & input);

	/** C++ instances are deleted in a finalize method iff 'allocatedInJavaWorld' is true. */
	static bool allocatedInJavaWorld(JNIEnv * env, jobject obj);
	static void setAllocatedInJavaWorld(JNIEnv * env, jobject obj, bool yn);

	/** Obtain the wrapped C++ instance for a given Java instance */
	static void * getQt(JNIEnv * env, jobject obj);
	/** Set the wrapped C++ instance for a given Java instance */
	static void setQt(JNIEnv * env, jobject obj, void * qt);

	/** Add a 'C++ instance key/Java instance value' pair to the qtKeyToJavaMap */
	static void setObjectForQtKey(JNIEnv * env, jobject obj, void * qt);
	
	/** Obtain the Jave instance for the given C++ instance, instantiating a new
		instance of the given class name if needed */
	static jobject objectForQtKey(JNIEnv * env, void * qt, const char * className, const bool allocatedInJavaWorld = FALSE);

	/** A 'C++ instance has been deleted. Set '_allocatedInJavaWorld' to false in the corresponding java instance */
	static void qtKeyDeleted(void * qt);

	/** Connect a C++ or Java sender to a Java receiver */
	static jboolean connect(JNIEnv * env, jobject sender, jstring signal, jobject receiver, jstring slot);

	/** Disconnect a C++ or Java sender from a Java receiver */
	static jboolean disconnect(JNIEnv * env, jobject sender, jstring signal, jobject receiver, jstring slot);

	/** Invoke a Java slot with arguments 'args'. */
	static void emitJavaSignal(JNIEnv * env, jobject sender, jstring signal, jobjectArray args);

	/** Return a JavaSignal proxy instance for a Java signal. Creates a new one if needed. */
	static JavaSignal * signalForSender(JNIEnv * env, void * qt, jstring signal);
	/** Return a JavaSlot proxy instance for a Java slot. Creates a new one if needed. */
	static JavaSlot * slotForReceiver(JNIEnv * env, jobject receiver, jstring slot);

	/** Casts a 'TQWidget *', 'TQPixmap *' or subclass of TQPaintDevice correctly to a 'TQPaintDevice *'.
	 	Needed because of C++ multiple inheritance complications. */
	static TQPaintDevice * paintDevice(JNIEnv * env, jobject obj);
	/** Casts a 'TQDragObject *', 'TQDropEvent *' or subclass of TQDropEvent correctly to a 'TQMimeSource *'.
	 	Needed because of C++ multiple inheritance complications. */
	static TQMimeSource * mimeSource(JNIEnv * env, jobject obj);

	/** Which byte order are Java strings */
	static bool bigEndianUnicode();

	/** Convert from Java primitive array types to C++ primitive array */
	static bool * toBooleanPtr(JNIEnv * env, jbooleanArray obj);
	static int * toIntPtr(JNIEnv * env, jintArray obj);
	static double * toDoublePtr(JNIEnv * env, jdoubleArray obj);
	static short * toShortPtr(JNIEnv * env, jshortArray obj);

	/** Convert from C++ primitive array types to Java primitive arrays */
	static jbooleanArray fromBooleanPtr(JNIEnv * env, bool * arg);
	static jintArray fromIntPtr(JNIEnv * env, int * arg);
	static jdoubleArray fromDoublePtr(JNIEnv * env, double * arg);
	static jshortArray fromShortPtr(JNIEnv * env, short * arg);

	/** Convert from Qt dates and times to Java Date and Time */
	static jobject fromTQDateTime(JNIEnv * env, TQDateTime* qdate);
	static jobject fromTQDate(JNIEnv * env, TQDate* qdate);
	static jobject fromTQTime(JNIEnv * env, TQTime* qtime);

	/** Convert from Java Date and Time to Qt dates and times */
	static TQDateTime * toTQDateTime(JNIEnv * env, jobject jdate, TQDateTime** qdate);
	static TQDate * toTQDate(JNIEnv * env, jobject jdate, TQDate** qdate);
	static TQTime * toTQTime(JNIEnv * env, jobject jtime, TQTime** qtime);

	/** Convert from TQString to Java String */
	static jstring fromTQString(JNIEnv * env, TQString * qstring);
	/** Convert from TQCString to Java String */
	static jstring fromTQCString(JNIEnv * env, TQCString * qcstring);
	/** Convert from a char * to Java String */
	static jstring fromCharString(JNIEnv * env, char * qcstring);

	/** Convert from Java String to TQString */
	static TQString * toTQString(JNIEnv * env, jstring str, TQString ** qstring);
	/** Convert from Java String to TQCString */
	static TQCString * toTQCString(JNIEnv * env, jstring str, TQCString ** qcstring);
	/** Convert from Java String to a char * */
	static char * toCharString(JNIEnv * env, jstring str, TQCString ** qcstring);

	/** Convert from TQString to Java StringBuffer */
	static void fromTQStringToStringBuffer(JNIEnv * env, TQString * qstring, jobject buffer);
	/** Convert from Java StringBuffer to TQString */
	static TQString * toTQStringFromStringBuffer(JNIEnv * env, jobject buffer, TQString ** qstring);
	/** Convert from TQCString to Java StringBuffer */
	static void fromTQCStringToStringBuffer(JNIEnv * env, TQCString * qcstring, jobject buffer);
	
	/** Convert from TQChar to Java char */
	static jchar fromTQChar(JNIEnv * env, TQChar * qchar);
	/** Convert from Java char to TQChar */
	static TQChar * toTQChar(JNIEnv * env, jchar unichar, TQChar ** qchar);

	/** Convert from TQByteArray to Java byte array */
	static jbyteArray fromTQByteArray(JNIEnv * env, TQByteArray * qbyteArray);
	/** Convert from Java byte array to TQByteArray */
	static TQByteArray * toTQByteArray(JNIEnv * env, jbyteArray bytes, TQByteArray ** qbyteArray);
	/** Convert from Java 'char[]' to 'uchar *' */
	static uchar * toUcharArray(JNIEnv * env, jcharArray bytes, TQByteArray ** qbyteArray);

	/** Convert from Java 'int[]' to TQValueList<int> */
	static TQValueList<int> toTQIntValueList(JNIEnv * env, jintArray ints, TQValueList<int> ** qintArray);
	/** Convert from TQValueList<int> to Java 'int[]' */
	static jintArray fromTQIntValueList(JNIEnv * env, TQValueList<int> * qintArray);
	
	/** Convert from a String[] to char * argv[], adding a dummy argv[0] argument */
	static char ** toArgv(JNIEnv * env, jobjectArray stringList);
	/** Convert from a String[] to char * argv[] */
	static char ** toStringArray(JNIEnv * env, jobjectArray stringList);
	/** Convert from String[] to TQStrList */
	static TQStrList * toTQStrList(JNIEnv * env, jobjectArray stringList, TQStrList ** qstringList);
	/** Convert from String[] to TQStringList */
	static TQStringList * toTQStringList(JNIEnv * env, jobjectArray stringList, TQStringList ** qstringList);

	/** Returns a Java ArrayList for the various types of Qt List */
	static jobject arrayWithTQStrList(JNIEnv * env, TQStrList * strList, jobject arrayList = 0);
	static jobject arrayWithTQStringList(JNIEnv * env, TQStringList * stringList, jobject arrayList = 0);
	static jobject arrayWithTQWidgetList(JNIEnv * env, TQWidgetList * widgetList, jobject arrayList = 0);
	static jobject arrayWithTQDomNodeList(JNIEnv * env, TQDomNodeList * domNodeList, jobject arrayList = 0);
	static jobject arrayWithTQObjectList(JNIEnv * env, TQObjectList * objectList, jobject arrayList = 0);
	static jobject arrayWithTQCanvasItemList(JNIEnv * env, TQCanvasItemList * itemList, jobject arrayList = 0);
	static jobject arrayWithTQListViewItemList(JNIEnv * env, TQListViewItemIterator * iterator, jobject arrayList = 0);
	static jobject arrayWithTQRectList(JNIEnv * env, TQMemArray<TQRect> * rectList, jobject arrayList = 0);
	static jobject arrayWithTQIconDragItemList(JNIEnv * env, TQValueList<TQIconDragItem> * dragItemList, jobject arrayList = 0);
	static jobject arrayWithTQUrlInfoList(JNIEnv * env, TQValueList<TQUrlInfo> * infoList, jobject arrayList = 0);

protected:
	/** Cache String constructor from bytes, and getBytes() method info */
	static jmethodID MID_String_init;
	static jmethodID MID_String_getBytes;

	/** Result of the test for the endianess of the unicode string returned by GetStringChars() */
	static bool _bigEndianUnicode;
};

#endif

