/***************************************************************************
 *   Copyright (C) 2004 by Hans Oischinger                                 *
 *   hans.oischinger@kde-mail.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "komposedesktopwidget.h"
#include "komposelayout.h"
#include "komposetask.h"
#include "komposetaskwidget.h"
#include "komposeviewmanager.h"
#include "komposetaskmanager.h"
#include "komposesettings.h"
#include "komposeglobal.h"

#include <tqdesktopwidget.h>
#include <tqcolor.h>
#include <tqpainter.h>
#include <tqapplication.h>
#include <tqdragobject.h>
#include <tqobjectlist.h>
#include <tqtooltip.h>

#include <tdelocale.h>
#include <twin.h>
#include <ksharedpixmap.h>
#include <krootpixmap.h>
#include <twinmodule.h>
#include <kcursor.h>
#include <kdebug.h>


KomposeDesktopWidget::KomposeDesktopWidget(int desktop, TQWidget *parent, KomposeLayout *l, const char *name)
    : KomposeTaskContainerWidget( desktop, parent, l, name ),
    highlight(false)
{
  // Retrieve geometry
  //   TQDesktopWidget *deskwidget = new TQDesktopWidget();
  //   deskRect = deskwidget->screenGeometry();
  //   delete deskwidget;
  initFonts();

  // Set Desktop background as our background
  setBackgroundMode( TQt::NoBackground );

  KWinModule twinmodule( this, 1 );
  deskName = twinmodule.desktopName(desktop+1);

  TQToolTip::add( this, i18n("Desktop %1 - %2").arg(desktop).arg(deskName) );

  rootpix = new KRootPixmap (this);

  // Background blur -- exactly as done in Kicker
  if(KomposeSettings::instance()->getBlurBackground())
    rootpix->setBlurEffect(0.0, 2.0);
  else
    rootpix->setBlurEffect(0.0, 0.0);

  rootpix->start();
  setAcceptDrops(TRUE);

  createTaskWidgets();

  connect( KomposeTaskManager::instance(), SIGNAL( newTask( KomposeTask* ) ), this, SLOT( createTaskWidget( KomposeTask* ) ) );

  setFocusPolicy(TQWidget::ClickFocus);

}


KomposeDesktopWidget::~KomposeDesktopWidget()
{
  disconnect( KomposeTaskManager::instance(), SIGNAL( newTask( KomposeTask* ) ), this, SLOT( createTaskWidget( KomposeTask* ) ) );
}

void KomposeDesktopWidget::initFonts()
{
  titleFont = KomposeSettings::instance()->getDesktopTitleFont();
}


// int KomposeDesktopWidget::getHeightForWidth( int w ) const
// {
//   kdDebug() << "KomposeDesktopWidget::getHeightForWidth()");
//   return ((double)w / (double)deskRect.width()) * deskRect.height();
// }
//
// int KomposeDesktopWidget::getWidthForHeight( int h ) const
// {
//   kdDebug() << "KomposeDesktopWidget::getWidthForHeight()");
//   return ((double)h / (double)deskRect.height()) * deskRect.width();
// }
//
// double KomposeDesktopWidget::getAspectRatio()
// {
//   kdDebug() << "KomposeDesktopWidget::getAspectRatio()");
//   return (double)deskRect.width() / (double)deskRect.height();
// }

void KomposeDesktopWidget::setHighlight()
{
  highlight = true;
  repaint();
}

void KomposeDesktopWidget::clearHighlight()
{
  highlight = false;
  repaint();
}

void KomposeDesktopWidget::setInactive()
{
  if( hasFocus() )
    clearFocus();
}

void KomposeDesktopWidget::setActive()
{
  // Focus first window (if there is one)
  const TQObjectList *lst = children();

  if ( lst )
  {
    TQObjectListIterator it( *lst );
    TQWidget *widget;
    while ( (widget = (TQWidget*)it.current() ) )
    {
      if (widget->inherits("KomposeTaskWidget"))
      {
	widget->setFocus();
	break;
      }
      ++it;
    }
  }

  emit activated(this);
}

void KomposeDesktopWidget::leaveEvent ( TQEvent * )
{
  unsetCursor();

  // Mark desktop as inactive if cursor moves out of our rect
  // but not if it enters a child widget
  TQRect deskRect;
  deskRect.setTopLeft(mapToGlobal( TQPoint(0,0) ));
  deskRect.setWidth(width());
  deskRect.setHeight(height());
  if ( !deskRect.contains( TQCursor::pos() ) )
    setInactive();
}

void KomposeDesktopWidget::enterEvent ( TQEvent * )
{
  setCursor( KCursor::handCursor() );
  setActive();
}

void KomposeDesktopWidget::focusInEvent ( TQFocusEvent * )
{
  setActive();
}

void KomposeDesktopWidget::focusOutEvent ( TQFocusEvent * )
{
  setInactive();
}

void KomposeDesktopWidget::mouseReleaseEvent ( TQMouseEvent * e )
{
  if ( !rect().contains( e->pos() ) )
    return;
  KomposeViewManager::instance()->setCurrentDesktop(desktop);
}


void KomposeDesktopWidget::mouseDoubleClickEvent ( TQMouseEvent * e )
{
  if ( !rect().contains( e->pos() ) )
    return;
  KomposeViewManager::instance()->setCurrentDesktop(desktop);
}


void KomposeDesktopWidget::paintEvent ( TQPaintEvent * )
{
  // KomposeWidget::paintEvent(e);
  TQPainter p;
  p.begin( this );
//   TQPoint tl = mapToGlobal(TQPoint(0,0));
//   p.drawPixmap(0,0, *KomposeGlobal::instance()->getDesktopBgPixmap(),
//                tl.x(), tl.y(), width(), height());

  p.setFont(titleFont);

  if (highlight)
    p.setPen( KomposeSettings::instance()->getDesktopTitleFontHighlightColor() );
  else
    p.setPen( KomposeSettings::instance()->getDesktopTitleFontColor() );

  // Bounding rect
  p.drawRect(rect());

  // paint the Desktop num & name (centered if empty, bottom right if not)
  if ( layout->getNumofChilds() == 0 )
    p.drawText(TQRect(TQPoint(0,0), size()), TQt::AlignCenter, TQString("Desktop %1 - %2").arg(desktop+1).arg(deskName));
  else
    p.drawText(TQRect(TQPoint(0,0), size()), TQt::AlignRight | TQt::AlignBottom, TQString("Desktop %1 - %2").arg(desktop+1).arg(deskName));

  p.end();
}

void KomposeDesktopWidget::dragEnterEvent( TQDragEnterEvent* e )
{
  kdDebug() << "KomposeDesktopWidget::dragEnterEvent" << endl;
  e->accept( TQTextDrag::canDecode(e) );
}

void KomposeDesktopWidget::dropEvent ( TQDropEvent * e )
{
  TQString text;
  if ( TQTextDrag::decode(e, text) )
  {
    kdDebug() << "KomposeDesktopWidget::dropEvent - Received Task drop" << endl;
    KomposeTaskWidget* dropWidget = dynamic_cast<KomposeTaskWidget*>(e->source());
    dropWidget->getTask()->toDesktop( desktop + 1);
    //if ( dropWidget->parentWidget() != this)
    //  dropWidget->reparent( this, TQPoint(0,0), true );

    e->accept();
  }
}


void KomposeDesktopWidget::childEvent ( TQChildEvent * ce)
{
  KomposeWidget::childEvent( ce );
  emit contentsChanged();
}


void KomposeDesktopWidget::keyReleaseEvent ( TQKeyEvent * e )
{
  if ( e->key() == TQt::Key_Return || e->key() == TQt::Key_Space )
  {
    kdDebug() << "KomposeDesktopWidget::keyReleaseEvent - Switching to Desktop!" << endl;
    KomposeViewManager::instance()->setCurrentDesktop(desktop);
    e->accept();
  }
  else
  {
    kdDebug() << "KomposeDesktopWidget::keyReleaseEvent - ignored..." << endl;
    e->ignore();
  }
  KomposeTaskContainerWidget::keyReleaseEvent(e);
}


#include "komposedesktopwidget.moc"
