/***************************************************************************
begin                : 2004/02/07
copyright            : (C) Mark Kretschmann
email                : markey@web.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AMAROKCONFIGDIALOG_H
#define AMAROKCONFIGDIALOG_H

#include <tqmap.h>
#include <tqvaluelist.h>

#include <tdeconfigdialog.h>

class TQComboBox;
class TQGroupBox;
class TQVBox;

namespace Amarok {
    class PluginConfig;
}

class MediumPluginManager;

class AmarokConfigDialog : public TDEConfigDialog
{
    Q_OBJECT
  

    public:
        AmarokConfigDialog( TQWidget *parent, const char* name, TDEConfigSkeleton *config );
        ~AmarokConfigDialog();

        void addPage( TQWidget *page, const TQString &itemName, const TQString &pixmapName,
                      const TQString &header=TQString(), bool manage=true);

        void showPageByName( const TQCString& page );

        static int s_currentPage;

    protected slots:
        void updateButtons();
        void updateSettings();
        void updateWidgets();
        void updateWidgetsDefault();

    private slots:
        void aboutEngine();

    protected:
        bool hasChanged();
        bool isDefault();

    private:
        void soundSystemChanged();
        TQString externalBrowser() const;

        TQComboBox* m_soundSystem;
        Amarok::PluginConfig *m_engineConfig;
        TQGroupBox            *m_engineConfigFrame;
        class Options1       *m_opt1;
        class Options2       *m_opt2;
        class Options4       *m_opt4;
        class Options7       *m_opt7;
        MediumPluginManager  *m_deviceManager;

        TQValueList<TQWidget*> m_pageList;
        TQMap<TQString, TQString> m_pluginName;
        TQMap<TQString, TQString> m_pluginAmarokName;
};


#endif // AMAROKCONFIGDIALOG_H
