#!/usr/bin/env python

# TQt tutorial 8.

import sys
from PyTQt import tqt


class LCDRange(tqt.TQVBox):
    def __init__(self, parent=None, name=None):
        tqt.TQVBox.__init__(self, parent, name)

        lcd = tqt.TQLCDNumber(2, self, "lcd")
        self.slider = tqt.TQSlider(tqt.TQt.Horizontal, self, "slider")
        self.slider.setRange(0, 99)
        self.slider.setValue(0)
        self.connect(self.slider, tqt.SIGNAL("valueChanged(int)"), lcd, tqt.SLOT("display(int)"))
        self.connect(self.slider, tqt.SIGNAL("valueChanged(int)"), self, tqt.PYSIGNAL("valueChanged(int)"))

        self.setFocusProxy(self.slider)

    def value(self):
        return self.slider.value()

    def setValue(self, value):
        self.slider.setValue(value)

    def setRange(self, minVal, maxVal):
        if minVal < 0 or maxVal > 99 or minVal > maxVal:
            raise ValueError("LCDRange.setRange(): invalid range")

        self.slider.setRange(minVal, maxVal)


class CannonField(tqt.TQWidget):
    def __init__(self, parent=None, name=None):
        tqt.TQWidget.__init__(self, parent, name)

        self.ang = 45
        self.setPalette(tqt.TQPalette(tqt.TQColor(250, 250, 200)))

    def angle(self):
        return self.ang

    def setAngle(self, degrees):
        if degrees < 5:
            degrees = 5
        if degrees > 70:
            degrees = 70
        if self.ang == degrees:
            return
        self.ang = degrees
        self.repaint()
        self.emit(tqt.PYSIGNAL("angleChanged(int)"), (self.ang, ))

    def paintEvent(self, ev):
        p = tqt.TQPainter(self)
        p.drawText(200, 200, "Angle = %d" % (self.ang))

    def sizePolicy(self):
        return tqt.TQSizePolicy(tqt.TQSizePolicy.Expanding, tqt.TQSizePolicy.Expanding)


class MyWidget(tqt.TQWidget):
    def __init__(self, parent=None, name=None):
        tqt.TQWidget.__init__(self, parent, name)

        quit = tqt.TQPushButton("Quit", self, "quit")
        quit.setFont(tqt.TQFont("Times", 18, tqt.TQFont.Bold))
        self.connect(quit, tqt.SIGNAL("clicked()"), tqt.tqApp, tqt.SLOT("quit()"))

        self.angle = LCDRange(self, "angle")
        self.angle.setRange(5, 70)

        self.cannonField = CannonField(self, "cannonField")

        self.connect(self.angle, tqt.PYSIGNAL("valueChanged(int)"), self.cannonField.setAngle)
        self.connect(self.cannonField, tqt.PYSIGNAL("angleChanged(int)"), self.angle.setValue)

        grid = tqt.TQGridLayout(self, 2, 2, 10)

        grid.addWidget(quit, 0, 0)
        grid.addWidget(self.angle, 1, 0, tqt.TQt.AlignTop)
        grid.addWidget(self.cannonField, 1, 1)
        grid.setColStretch(1, 10)

        self.angle.setValue(60)
        self.angle.setFocus()


a = tqt.TQApplication(sys.argv)

w = MyWidget()
w.setGeometry(100, 100, 500, 355)
a.setMainWidget(w)
w.show()
sys.exit(a.exec_loop())
