/***************************************************************************
    begin                : Wed Aug 14 2002
    copyright            : (C) 2002 - 2003 by Pascal Brachet, 2003 Jeroen Wijnhout
    email                : Jeroen.Wijnhout@kdemail.net

from Kate (C) 2001 by Matt Newell

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KILEFILESELECT_H
#define KILEFILESELECT_H

#include <tqwidget.h>
#include <tqtoolbutton.h>
#include <tdefile.h>
#include <tdediroperator.h>
#include <kurlcombobox.h>
#include <kurlcompletion.h>
#include <kurl.h>

#include "kileextensions.h"

/**
  *@author Jeroen Wijnhout
  */

class KFileItem;
class KComboBox;

class KileFileSelect : public TQWidget
{
	Q_OBJECT
  

public: 
	KileFileSelect(KileDocument::Extensions *extensions, TQWidget *parent=0, const char *name=0);
	~KileFileSelect();

	void setView(KFile::FileView);
	KDirOperator * dirOperator(){return dir;}
	KComboBox* comboEncoding() { return m_comboEncoding; }

public slots:
	void setDir(KURL);
	void readConfig();
	void writeConfig();

private slots:
	void cmbPathActivated( const KURL& u );
	void cmbPathReturnPressed( const TQString& u );
	void dirUrlEntered( const KURL& u );

	void clickedToolbar(int);

protected:
	void focusInEvent(TQFocusEvent*);

signals:
	void fileSelected(const KFileItem*);

private:
	KURLComboBox	*cmbPath;
	KDirOperator	* dir;
	KComboBox	*m_comboEncoding;
	TQToolButton	*home, *up, *back, *forward;
	KURLCompletion	*cmpl;
};

#endif
