/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef CSVEXPORTER_H
#define CSVEXPORTER_H

class KLineEdit;
class TDEConfig;

class TQWidget;
class TQCheckBox;
class TQRadioButton;

#include "exporter.h"

namespace Tellico {
  namespace Export {

/**
 * @author Robby Stephenson
 */
class CSVExporter : public Exporter {
Q_OBJECT
  

public:
  CSVExporter();

  virtual bool exec();
  virtual TQString formatString() const;
  virtual TQString fileFilter() const;

  virtual TQWidget* widget(TQWidget* parent, const char* name=0);
  virtual void readOptions(TDEConfig* config);
  virtual void saveOptions(TDEConfig* config);

private:
  TQString& escapeText(TQString& text);

  bool m_includeTitles;
  TQString m_delimiter;

  TQWidget* m_widget;
  TQCheckBox* m_checkIncludeTitles;
  TQRadioButton* m_radioComma;
  TQRadioButton* m_radioSemicolon;
  TQRadioButton* m_radioTab;
  TQRadioButton* m_radioOther;
  KLineEdit* m_editOther;
};

  } // end namespace
} // end namespace
#endif
