//
// C++ Interface: k9titleencopt
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef K9TITLEENCOPT_H
#define K9TITLEENCOPT_H

#include <tqobject.h>


/**
	@author Jean-Michel PETIT <k9copy@free.fr>
*/

class k9DVDTitle;

class k9TitleEncOpt : public TQObject
{
Q_OBJECT
  
public:
    k9TitleEncOpt(k9DVDTitle *parent );
    ~k9TitleEncOpt();
   k9DVDTitle *getTitle() { return (k9DVDTitle*)parent();};
    
public:
   int getMaxSize();
   void setMaxSize(int);
   
   int getNumParts();
   void setNumParts(int);

   int getAudioGain();
   void setAudioGain(int);
   
   const TQString & getWidth();
   void setWidth(TQString);
   
   const TQString & getHeight();
   void setHeight(TQString);
   
   const TQString & getAudioBr();
   void setAudioBr(TQString);

   const TQString & getVideoBr();
   void setVideoBr(TQString);
   
   bool getKeepAspectRatio();
   void setKeepAspectRatio(bool);
   
   bool get2Passes();
   void set2Passes(bool);

   bool getUseCache();
   void setUseCache(bool);
   
   int getCodec();
   void setCodec(int);

   int getAudioCodec();
   void setAudioCodec(int);


private:
   int m_maxSize;
   int m_numParts;
   TQString m_width;
   TQString m_height;
   bool m_keepAspectRatio;
   bool m_2Passes;
   TQString m_audioBr,m_videoBr;
   int m_codec,m_audioCodec;
   int m_audioGain;
   bool m_useCache;
   
public slots:
   void load();
   
};

#endif
