/***************************************************************************
                          kplayeractionlist.h
                          -------------------
    begin                : Thu Apr 13 2006
    copyright            : (C) 2006-2007 by kiriuja
    email                : http://kplayer.sourceforge.net/email.html
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KPLAYERACTIONLIST_H
#define KPLAYERACTIONLIST_H

#include <tqobject.h>
#include <tqptrlist.h>

class TDEAction;

/**Action list.
  *@author kiriuja
  */
class KPlayerActionList : public TQObject
{
  Q_OBJECT

public:
  /** Constructor. */
  KPlayerActionList (const TQString& text, const TQString& status,
    const TQString& whatsthis, TQObject* parent, const char* name);
  /** Destructor. */
  virtual ~KPlayerActionList();

  /** Returns the list of actions. */
  const TQPtrList<TDEAction>& actions (void) const
    { return m_actions; }
  /** Returns the number of actions on the list. */
  int count (void) const
    { return actions().count(); }
  /** Returns whether the list is empty. */
  bool isEmpty (void) const
    { return actions().isEmpty(); }

signals:
  /** Emitted when the action list is going to be updated. */
  void updating (KPlayerActionList* list);
  /** Emitted when the action list has been updated. */
  void updated (KPlayerActionList* list);
  /** Emitted when an item is selected from the list. Provides the item number. */
  void activated (int index);

protected slots:
  /** Emits the activated signal with the selected item number. */
  void actionActivated (void);

protected:
  /** Plugs the action list and emits the updated signal. */
  void plug (void);
  /** Unplugs the action list. */
  void unplug (void);
  /** Updates the action text, status, and whats this. */
  virtual void updateAction (TDEAction* action);
  /** Selects the item with the given index by emitting the activated signal. */
  virtual void actionActivated (TDEAction* action, int index);

  /** Action text template. */
  TQString m_text;
  /** Action status text template. */
  TQString m_status;
  /** Action whats this text template. */
  TQString m_whatsthis;
  /** Action list. */
  TQPtrList<TDEAction> m_actions;
};

/**Simple action list.
  *@author kiriuja
  */
class KPlayerSimpleActionList : public KPlayerActionList
{
  Q_OBJECT

public:
  /** Constructor. */
  KPlayerSimpleActionList (const TQStringList& names, const TQString& text, const TQString& status,
    const TQString& whatsthis, TQObject* parent, const char* name);
  /** Destructor. */
  virtual ~KPlayerSimpleActionList();

  /** Updates the action list. */
  void update (void);

protected:
  /** Updates the action text, status, and whats this. */
  virtual void updateAction (TDEAction* action);

  /** Action names. */
  const TQStringList& m_names;
};

/**Toggle action list.
  *@author kiriuja
  */
class KPlayerToggleActionList : public KPlayerSimpleActionList
{
  Q_OBJECT

public:
  /** Constructor. */
  KPlayerToggleActionList (const TQStringList& names, const TQMap<TQString, bool>& states,
    const TQString& ontext, const TQString& offtext, const TQString& onstatus, const TQString& offstatus,
    const TQString& onwhatsthis, const TQString& offwhatsthis, TQObject* parent, const char* name);
  /** Destructor. */
  virtual ~KPlayerToggleActionList();

protected:
  /** Updates the action text, status, and whats this. */
  virtual void updateAction (TDEAction* action);
  /** Selects the item with the given index by emitting the activated signal. */
  virtual void actionActivated (TDEAction* action, int index);

  /** Action states. */
  const TQMap<TQString, bool>& m_states;
  /** Action on text template. */
  TQString m_on_text;
  /** Action on status text template. */
  TQString m_on_status;
  /** Action on whats this text template. */
  TQString m_on_whatsthis;
};

/**Track action list.
  *@author kiriuja
  */
class KPlayerTrackActionList : public KPlayerActionList
{
  Q_OBJECT

public:
  /** Constructor. */
  KPlayerTrackActionList (const TQString& text, const TQString& status,
    const TQString& whatsthis, TQObject* parent, const char* name);
  /** Destructor. */
  virtual ~KPlayerTrackActionList();

  /** Updates the track action list. */
  void update (const TQMap<int, TQString>& ids, int id);

protected:
  /** Adds actions for the given IDs to the list. */
  void addActions (const TQMap<int, TQString>& ids, int id);

  /** Selects the track with the given index by emitting the activated signal. */
  virtual void actionActivated (TDEAction* action, int index);
};

/**Subtitle track action list.
  *@author kiriuja
  */
class KPlayerSubtitleTrackActionList : public KPlayerTrackActionList
{
  Q_OBJECT

public:
  /** Constructor. */
  KPlayerSubtitleTrackActionList (const TQString& text, const TQString& status,
    const TQString& whatsthis, TQObject* parent, const char* name);
  /** Destructor. */
  virtual ~KPlayerSubtitleTrackActionList();

  /** Updates the track action list. */
  void update (bool show, const TQMap<int, TQString>& sids, int sid, const TQMap<int, TQString>& vsids,
    int vsid, TQStringList files, const TQString& vobsub, const TQString& current);

protected:
  /** Selects the track with the given index by emitting the activated signal. */
  virtual void actionActivated (TDEAction* action, int index);
};

#endif
