/*
 * Copyright Johannes Sixt
 * This file is licensed under the GNU General Public License Version 2.
 * See the file COPYING in the toplevel directory of the source directory.
 */

#ifndef DBGMAINWND_H
#define DBGMAINWND_H

#include <tqtimer.h>
#include <kdockwidget.h>
#include "mainwndbase.h"
#include "regwnd.h"

class TDERecentFilesAction;
class WinStack;
class TQListBox;
class TQCString;
class ExprWnd;
class BreakpointTable;
class ThreadList;
class MemoryWindow;
struct DbgAddr;

class DebuggerMainWnd : public KDockMainWindow, public DebuggerMainWndBase
{
    Q_OBJECT
public:
    DebuggerMainWnd(const char* name);
    ~DebuggerMainWnd();

    bool debugProgram(const TQString& exe, const TQString& lang);

protected:
    // session properties
    virtual void saveProperties(TDEConfig*);
    virtual void readProperties(TDEConfig*);
    // settings
    void saveSettings(TDEConfig*);
    void restoreSettings(TDEConfig*);

    void initToolbar();
    void initKAction();

    // view windows
    WinStack* m_filesWindow;
    TQListBox* m_btWindow;
    ExprWnd* m_localVariables;
    WatchWindow* m_watches;
    RegisterView* m_registers;
    BreakpointTable* m_bpTable;
    TTYWindow* m_ttyWindow;
    ThreadList* m_threads;
    MemoryWindow* m_memoryWindow;

    TQTimer m_backTimer;

    // recent execs in File menu
    TDERecentFilesAction* m_recentExecAction;

protected:
    virtual bool queryClose();
    virtual TTYWindow* ttyWindow();
    virtual TQString createOutputWindow();

    KDockWidget* dockParent(TQWidget* w);
    bool isDockVisible(TQWidget* w);
    bool canChangeDockVisibility(TQWidget* w);
    void dockUpdateHelper(TQString action, TQWidget* w);
    void fixDockConfig(TDEConfig* c, bool upgrade);

    TQString makeSourceFilter();

    // to avoid flicker when the status bar is updated,
    // we store the last string that we put there
    TQString m_lastActiveStatusText;
    bool m_animRunning;

signals:
    void setTabWidth(int tabWidth);

public slots:
    virtual void updateUI();
    virtual void updateLineItems();
    void slotAddWatch();
    void slotAddWatch(const TQString& text);
    void slotNewFileLoaded();
    void slotNewStatusMsg();
    void slotDebuggerStarting();
    void slotToggleBreak(const TQString&, int, const DbgAddr&, bool);
    void slotEnaDisBreak(const TQString&, int, const DbgAddr&);
    void slotTermEmuExited();
    void slotProgramStopped();
    void slotBackTimer();
    void slotRecentExec(const KURL& url);
    void slotLocalsPopup(TQListViewItem*, const TQPoint& pt);
    void slotLocalsToWatch();
    void slotEditValue();

    void slotFileOpen();
    void slotFileExe();
    void slotFileCore();
    void slotFileGlobalSettings();
    void slotFileProgSettings();
    void slotViewStatusbar();
    void slotExecUntil();
    void slotExecAttach();
    void slotExecArgs();
    void intoBackground();
    void slotConfigureKeys();
};

#endif // DBGMAINWND_H
