/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2004  Alexander Dymo <cloudtemple@mskat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "sizeedit.h"
#include "editoritem.h"

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include <tqtooltip.h>

#include <kactivelabel.h>
#include <tdelocale.h>

//"[ %1, %2 ]"
#define SIZEEDIT_MASK "%1x%2"

using namespace KoProperty;

SizeEdit::SizeEdit(Property *property, TQWidget *parent, const char *name)
 : Widget(property, parent, name)
{
	setHasBorders(false);
	m_edit = new KActiveLabel(this);
	m_edit->setFocusPolicy(TQ_NoFocus);
//	m_edit->setIndent(KPROPEDITOR_ITEM_MARGIN);
	m_edit->setPaletteBackgroundColor(palette().active().base());
//	m_edit->setBackgroundMode(TQt::PaletteBase);
//	m_edit->setSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Expanding);
	m_edit->setMinimumHeight(5);
	setEditor(m_edit);
//	setFocusWidget(m_edit);
}

SizeEdit::~SizeEdit()
{}

TQVariant
SizeEdit::value() const
{
	return m_value;
}

void
SizeEdit::setValue(const TQVariant &value, bool emitChange)
{
	m_value = value;
	m_edit->selectAll(false);
	m_edit->setText(TQString(SIZEEDIT_MASK).arg(value.toSize().width()).arg(value.toSize().height()));
	TQToolTip::add(this, TQString("%1 x %2").arg(value.toSize().width()).arg(value.toSize().height()));

	if (emitChange)
		emit valueChanged(this);
}

void
SizeEdit::drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, const TQVariant &value)
{
	TQRect rect(r);
	rect.setBottom(r.bottom()+1);
	Widget::drawViewer(p, cg, rect, 
		TQString(SIZEEDIT_MASK).arg(value.toSize().width()).arg(value.toSize().height()));
//	p->eraseRect(r);
//	p->drawText(r, TQt::AlignLeft | TQt::AlignVCenter | TQt::SingleLine,
//		TQString("[ %1, %2 ]").arg(value.toSize().width()).arg(value.toSize().height()));
}

void
SizeEdit::setReadOnlyInternal(bool readOnly)
{
	Q_UNUSED(readOnly);
}

#include "sizeedit.moc"
