/*
 * Copyright (C) 2004 Girish Ramakrishnan All Rights Reserved.
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

// $Id: qtraylabel.h,v 1.21 2005/06/21 10:04:36 cs19713 Exp $

#ifndef _QTRAYLABEL_H
#define _QTRAYLABEL_H

#include <tqlabel.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqpixmap.h>
#include <tqtimer.h>
#include <tqtextstream.h>
#include <tqsettings.h>
#include <tqevent.h>
#include <tqsize.h>
#include <tdeactionclasses.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include <sys/types.h>
#include <unistd.h>

class TQMouseEvent;
class TQDragEnterEvent;
class TQDropEvent;
class TQPoint;
class TQWidget;
class TDEConfig;
class TDEPopupMenu;
class TDEToggleAction;

class TQTrayLabel : public TQLabel
{
  Q_OBJECT

public:
  TQTrayLabel(Window w, TQWidget *p = NULL, const TQString &text = TQString::null);
  TQTrayLabel(const TQStringList &argv, pid_t pid, TQWidget *parent = NULL);
  virtual ~TQTrayLabel();

  // Accessors
  Window dockedWindow(void) const { return mDockedWindow; }
  int balloonTimeout(void) const { return mBalloonTimeout; }

  TQString appName(void) const { return (mProgName.count() > 0) ? mProgName[0] : TQString::null; }
  void setAppName(const TQString& prog);

  // Pass on all events through this interface
  bool x11EventFilter(XEvent * event);

  // Session Management
  bool saveState(TDEConfig *config);
  bool restoreState(TDEConfig *config);

public slots:
  void dock(void);              // puts us in the system tray
  void undock(void);            // removes us from the system tray
  void map(void);               // maps the window that we are docking
  void withdraw(void);          // withdraws the window that we are docking
  void toggleShow(void);        // toggle window show status
  void close(void);             // close the docked window
  void setTrayIcon(const TQString& icon);  // sets custom icon

  // and some property setters
  void setSkipTaskbar(bool skip);
  void setBalloonTimeout(int msecs) { mBalloonTimeout = msecs; }
  void setDockWhenObscured(bool dock) { mDockWhenObscured->setChecked(dock); }
  void setDockWhenRestored(bool dwr);
  void setSessionManagement(bool sm) { mSessionManaged = sm; }

protected slots:
  void scanClients(void);       // scans existing client connections

signals:
  void clicked(const ButtonState&, const TQPoint&);
  void docked(TQTrayLabel *);   // emitted when we get docked
  void docked(void);           // emitted when we get docked
  void undocked(TQTrayLabel *); // emitted when we get undocked
  void undocked(void);         // emitted when we get undock
                               // window are monitoring dies
  void sysTrayDestroyed(void); // emitted when the system tray disappears

protected:
  // reimplement these event handlers in subclass as needed
  void dropEvent(TQDropEvent *ev);
  void mouseReleaseEvent(TQMouseEvent *event);
  void dragEnterEvent(TQDragEnterEvent *event);

  // the events that follow are events of the docked window (NOT TQTrayLabel)
  void updateIcon(void);   // updates the icon
  void updateTitle(void);  // sets the tooltip
  void balloonText(void);  // balloons text
  void destroyEvent(void);
  void focusLostEvent(void);
  void mapEvent(void);
  void minimizeEvent(void);
  void obscureEvent(void);
  void unmapEvent(void);

  bool canUnsubscribeFromRoot(void);
  void processDead(void);

  void propertyChangeEvent(Atom);
  void setDockedWindow(Window w); // set docked window to anything you want

private slots:
  void realityCheck(void);
  void showOnAllDesktops(void);
  void toggleDockWhenMinimized(void) { mDockWhenMinimized->setChecked(mSavedDWM); }
  void skipTaskbar(void);
  void setCustomIcon(void);
  void updateMenu(void);
  void slotSetBalloonTimeout(void);

private:
  // Helpers
  void handleTitleChange(void);
  void handleIconChange(void);
  void initialize(void);
  void installMenu();

  const char *me(void) const;

  // Member variables
  long mDesktop;           // desktop on which the window is being shown
  TQLabel *mBalloon;       // tooltip text simulator
  TQString mCustomIcon;    // CustomIcon of the docked application
  Window mDockedWindow;    // the window which is being docked
  int mBalloonTimeout, mShowId;
  bool mDocked, mWithdrawn, mUndockWhenDead, mSessionManaged;
  bool mSavedDWM;          // related to dock when minimized logic

  TQString mTitle, mClass; // Title and hint of mDockedWindow
  TQPixmap mAppIcon;       // The current app icon (may not be same as pixmap())
  XSizeHints mSizeHint;    // SizeHint of mDockedWindow

  TQTimer mRealityMonitor; // Helps us sync up with reality
  TQStringList mProgName;  // The program whose window we are docking
  pid_t mPid;              // The PID of program whose window we are docking
  Window mSysTray;         // System tray window id

  // GUI
  TDEAction *mBalloonTimeoutAction;
  TDEPopupMenu *mMainMenu, *mOptionsMenu;
  TDEToggleAction *mDockWhenRestored, *mDockWhenFocusLost, *mDockWhenMinimized,
                  *mDockWhenObscured, *mSkipTaskbar;

};

#endif // _QTRAYLABEL_H
