/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _KUARANTINE_H_
#define _KUARANTINE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeapplication.h>
#include <tdemainwindow.h>



class KPrinter;
class TDEToggleAction;
class KURL;
class TQLineEdit;
class TQComboBox;
class TQCheckBox;
class TQListView;
class TQPushButton;
class TQLabel;
class TDEProcess;
class TDEConfig;
class KURLRequester;
class TQListViewItem;


/**
 * This class serves as the main window for Kuarantine.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Kuarantine :  public TQWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Kuarantine(TQWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~Kuarantine();

    /**
     * Use this method to load whatever file/URL you have
     */
    void load();
    void  setDirName(TQString);
    void createQuarDir();
    TQString getFileName(TQString);
    TQString getVirusName(TQString);
    TQString getWhen(TQString);
    TQString getSelectedVirusName();

protected:
    /**
     * Overridden virtuals for TQt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(TQDragEnterEvent *event);
    virtual void dropEvent(TQDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(TDEConfig *);

    /**
     * This function is called when this app is restored.  The TDEConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(TDEConfig *);


private slots:
/*    void fileNew();
    void fileOpen();
    void fileSave();
    void fileSaveAs();
    void filePrint();
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void newToolbarConfig();
*/
    //void changeStatusbar(const TQString& text);
    //void changeCaption(const TQString& text);
    void slotRMB( TQListViewItem *, const TQPoint &, int );
    //void resizeEvent ( TQResizeEvent * );
private:
    void setupAccel();
    void setupActions();

private:
    //KuarantineView *m_view;

  /*  KPrinter   *m_printer;
    TDEToggleAction *m_toolbarAction;
    TDEToggleAction *m_statusbarAction;*/


signals:
    void itemSelected(TQString abs_filename, int line);

public slots:

    void refresh();
private slots:
    void slotSearch();
    void slotCancel();
    void refreshhistory();
    void slotClearHistory();
    void slotDeleteHistory();
    void updateLastQuarLocations();
    void slotGoogleCurrent();
    void slotTrendMicroCurrent();
    void slotGoogleHistory();
    void slotTrendMicroHistory();

    //void patternTextChanged( const TQString &);
private:
    void getout();

    TQLineEdit *template_edit;
    TQComboBox *files_combo, *pattern_combo/*, *dir_combo*/;
    KURLRequester *dir_combo;
    TQCheckBox *recursive_box;
    TQListView *currentbox;
    TQListView *historybox;
    TQPushButton *search_button, *cancel_button, *refresh_button, *search_button3, *cancel_button3;
    TQLabel *status_label, *matches_label;
    TDEProcess *childproc;
    TQString buf;
    TDEConfig* config;
    TQStringList lastQuarItems;
    TQStringList lastHistoryItems;
    TQStringList lastQuarLocations;
    TQStringList lastSearchPaths;
    TQString quarloc;
    TQPopupMenu* qmenu;
    TQPopupMenu* hmenu;

};

#endif // _Kuarantine_H_
