/*
 *  Copyright (C) 2003 Marek Janukowicz <marek@janukowicz.net>
 */


#ifndef __KDEVPART_RUBYSUPPORT_H__
#define __KDEVPART_RUBYSUPPORT_H__

#include <tqguardedptr.h>

#include "kdevlanguagesupport.h"

class KDialogBase;
class TQPopupMenu;
class Context;
class KDevShellWidget;

class RubySupportPart : public KDevLanguageSupport
{
  Q_OBJECT
  

public:

  RubySupportPart(TQObject *parent, const char *name, const TQStringList &);
  virtual ~RubySupportPart();

  virtual KDevDesignerIntegration *designer(KInterfaceDesigner::DesignerType type);

protected:
    virtual Features features();
    virtual KMimeType::List mimeTypes();

private slots:
    void projectConfigWidget(KDialogBase *dlg);
    void projectOpened();
    void projectClosed();
    void savedFile(const KURL &fileName);
    void addedFilesToProject(const TQStringList &fileList);
    void removedFilesFromProject(const TQStringList &fileList);
    void slotRun();
    void slotRunTestUnderCursor();
    void slotCreateSubclass();
    void contextMenu(TQPopupMenu *popup, const Context *context);
    void slotBrowse();

    void initialParse();

    void slotSwitchToController();
    void slotSwitchToView();
    void slotSwitchToModel();
    void slotSwitchToTest();

private:
    void startApplication(const TQString &program);
    TQString interpreter();
    TQString shell();
    TQString mainProgram();
    TQString runDirectory();
    TQString programArgs();
    TQString characterCoding();

    void maybeParse(const TQString fileName);
    void parse(const TQString &fileName);

    TQMap<KInterfaceDesigner::DesignerType, KDevDesignerIntegration*> m_designers;

    TQString m_contextFileName;
    TQCString m_shell;

    TQGuardedPtr<KDevShellWidget> m_shellWidget;
};


#endif
