/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEFUNCTIONSDIALOG_H
#define QALCULATEFUNCTIONSDIALOG_H

#include <kdialog.h>
#include <tqmap.h>

class MathFunction;
class QalculateEditFunctionDialog;
class TDEListView;
class TQListViewItem;
class TQPushButton;
class KTextBrowser;

/**
@author Niklas Knutsson
*/
class QalculateFunctionsDialog : public KDialog {

	Q_OBJECT

public:

	QalculateFunctionsDialog(TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculateFunctionsDialog();

	QalculateEditFunctionDialog *function_edit_dialog;
	TQString selected_category;
	MathFunction *selected_function;
	void addFunctionTreeItem(MathFunction *f);
	TQMap<TQListViewItem*, MathFunction*> functionItems;
	TQMap<TQListViewItem*, TQString> categoryItems;

	TDEListView *categoryView;
	TDEListView *functionView;
	TQPushButton *newButton;
	TQPushButton *editButton;
	TQPushButton *deleteButton;
	TQPushButton *deactivateButton;
	TQPushButton *insertButton;
	TQPushButton *applyButton;
	TQPushButton *helpButton;
	TQPushButton *buttonClose;
	KTextBrowser *descriptionBrowser;

public slots:

	void updateFunctionTree();
	void functionDoubleClicked(TQListViewItem*);
	void functionSelected();
	void categorySelected();
	void insertFunction();
	void applyFunction();
	void deactivateFunction();
	void deleteFunction();
	void editFunction();
	void newFunction();
	
protected slots:
	
	void slotHelp();	

signals:

	void functionsChanged();
	void insertRequest(MathFunction*);
	void applyRequest(MathFunction*);

};

#endif
