/***************************************************************************
 *
 * tdenetman-connection_setting_ppp_widget.cpp - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2008 Novell, Inc.
 *
 * Author: Will Stephenson <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// tqt headers
#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqcombobox.h>
#include <tqspinbox.h>
#include <tqiconset.h>
#include <kiconloader.h>
#include <tqwidgetstack.h>
#include <kuser.h>

// tdenm headers
#include "tdenetman-connection_setting_ppp_widget.h"
#include "connection_setting_ppp.h"

using namespace ConnectionSettings;

PPPWidgetImpl::PPPWidgetImpl(TDENetworkConnection* conn, TQWidget* parent, const char* name, WFlags fl)
	: WidgetInterface(parent, name, fl)
{
	_parentdialog = dynamic_cast<ConnectionSettingsDialogImpl*>(parent);

	_pppsetting = conn;

	TQVBoxLayout* layout = new TQVBoxLayout(this, 1, 1);
	_mainWid = new ConnectionSettingPppWidget(this);
	layout->addWidget(_mainWid);

	Init();
}

void
PPPWidgetImpl::Init()
{
	if (_pppsetting->pppConfig.valid) {
		_mainWid->mNoAuth->setChecked( !(_pppsetting->pppConfig.requireServerAuthentication) );
		_mainWid->mRefuseEap->setChecked( _pppsetting->pppConfig.flags & TDENetworkPPPFlags::DisableEAP );
		_mainWid->mRefusePap->setChecked( _pppsetting->pppConfig.flags & TDENetworkPPPFlags::DisablePAP );
		_mainWid->mRefuseChap->setChecked( _pppsetting->pppConfig.flags & TDENetworkPPPFlags::DisableCHAP );
		_mainWid->mRefuseMschap->setChecked( _pppsetting->pppConfig.flags & TDENetworkPPPFlags::DisableMSCHAP );
		_mainWid->mRefuseMschapV2->setChecked( _pppsetting->pppConfig.flags & TDENetworkPPPFlags::DisableMSCHAPv2 );
		_mainWid->mNoBsd->setChecked( !(_pppsetting->pppConfig.flags & TDENetworkPPPFlags::AllowBSDCompression) );
		_mainWid->mNoDeflate->setChecked( !(_pppsetting->pppConfig.flags & TDENetworkPPPFlags::AllowDeflateCompression) );
		_mainWid->mNoVjComp->setChecked( !(_pppsetting->pppConfig.flags & TDENetworkPPPFlags::AllowVJCompression) );
		_mainWid->mRequireMppe->setChecked( _pppsetting->pppConfig.flags & TDENetworkPPPFlags::RequireMPPE );
		_mainWid->mRequireMppe128->setChecked( _pppsetting->pppConfig.flags & TDENetworkPPPFlags::RequireMPPE128 );
		_mainWid->mStatefulMppe->setChecked( _pppsetting->pppConfig.flags & TDENetworkPPPFlags::StatefulMPPE );
		_mainWid->mCrtscts->setChecked( _pppsetting->pppConfig.flags & TDENetworkPPPFlags::UseHardwareFlowControl );
	
		_mainWid->mBaudRate->setValue(_pppsetting->pppConfig.baudRate);
		_mainWid->mMru->setValue(_pppsetting->pppConfig.mru);
		_mainWid->mMtu->setValue(_pppsetting->pppConfig.mtu);
		_mainWid->mLcpEchoFailure->setValue(_pppsetting->pppConfig.lcpEchoFailureThreshold);
		_mainWid->mLcpEchoInterval->setValue(_pppsetting->pppConfig.lcpEchoPingInterval);
	}

	connect( _mainWid->mNoAuth, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
	connect( _mainWid->mRefuseEap, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
	connect( _mainWid->mRefusePap, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
	connect( _mainWid->mRefuseChap, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
	connect( _mainWid->mRefuseMschap, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
	connect( _mainWid->mRefuseMschapV2, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
	connect( _mainWid->mNoBsd, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
	connect( _mainWid->mNoDeflate, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
	connect( _mainWid->mRequireMppe, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
	connect( _mainWid->mRequireMppe128, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
	connect( _mainWid->mStatefulMppe, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
	connect( _mainWid->mCrtscts, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
}

void
PPPWidgetImpl::Deactivate()
{
}

void
PPPWidgetImpl::Activate()
{

}

#define SET_FLAG_IF_TRUE_CLEAR_IF_FALSE(x,y,z)		{					\
								if (z) {			\
									x |= y;			\
								}				\
								else {				\
									x &= (~y);		\
								}				\
							}

void
PPPWidgetImpl::dirty()
{
	_pppsetting->pppConfig.requireServerAuthentication = ( !(_mainWid->mNoAuth->isChecked()) );

	SET_FLAG_IF_TRUE_CLEAR_IF_FALSE( _pppsetting->pppConfig.flags, TDENetworkPPPFlags::DisableEAP, _mainWid->mRefuseEap->isChecked() );
	SET_FLAG_IF_TRUE_CLEAR_IF_FALSE( _pppsetting->pppConfig.flags, TDENetworkPPPFlags::DisablePAP, _mainWid->mRefusePap->isChecked() );
	SET_FLAG_IF_TRUE_CLEAR_IF_FALSE( _pppsetting->pppConfig.flags, TDENetworkPPPFlags::DisableCHAP, _mainWid->mRefuseChap->isChecked() );
	SET_FLAG_IF_TRUE_CLEAR_IF_FALSE( _pppsetting->pppConfig.flags, TDENetworkPPPFlags::DisableMSCHAP, _mainWid->mRefuseMschap->isChecked() );
	SET_FLAG_IF_TRUE_CLEAR_IF_FALSE( _pppsetting->pppConfig.flags, TDENetworkPPPFlags::DisableMSCHAPv2, _mainWid->mRefuseMschapV2->isChecked() );
	SET_FLAG_IF_TRUE_CLEAR_IF_FALSE( _pppsetting->pppConfig.flags, TDENetworkPPPFlags::AllowBSDCompression, !(_mainWid->mNoBsd->isChecked()) );
	SET_FLAG_IF_TRUE_CLEAR_IF_FALSE( _pppsetting->pppConfig.flags, TDENetworkPPPFlags::AllowDeflateCompression, !(_mainWid->mNoDeflate->isChecked()) );
	SET_FLAG_IF_TRUE_CLEAR_IF_FALSE( _pppsetting->pppConfig.flags, TDENetworkPPPFlags::AllowVJCompression, !(_mainWid->mNoVjComp->isChecked()) );
	SET_FLAG_IF_TRUE_CLEAR_IF_FALSE( _pppsetting->pppConfig.flags, TDENetworkPPPFlags::RequireMPPE, _mainWid->mRequireMppe->isChecked() );
	SET_FLAG_IF_TRUE_CLEAR_IF_FALSE( _pppsetting->pppConfig.flags, TDENetworkPPPFlags::RequireMPPE128, _mainWid->mRequireMppe128->isChecked() );
	SET_FLAG_IF_TRUE_CLEAR_IF_FALSE( _pppsetting->pppConfig.flags, TDENetworkPPPFlags::StatefulMPPE, _mainWid->mStatefulMppe->isChecked() );
	SET_FLAG_IF_TRUE_CLEAR_IF_FALSE( _pppsetting->pppConfig.flags, TDENetworkPPPFlags::UseHardwareFlowControl, _mainWid->mCrtscts->isChecked() );

	_pppsetting->pppConfig.baudRate = _mainWid->mBaudRate->value();
	_pppsetting->pppConfig.mru = _mainWid->mMru->value();
	_pppsetting->pppConfig.mtu = _mainWid->mMtu->value();
	_pppsetting->pppConfig.lcpEchoFailureThreshold = _mainWid->mLcpEchoFailure->value();
	_pppsetting->pppConfig.lcpEchoPingInterval = _mainWid->mLcpEchoInterval->value();

	_pppsetting->pppConfig.valid = true;

	if (_parentdialog) _parentdialog->slotEnableButtons();	// Update lockouts
}

#include "tdenetman-connection_setting_ppp_widget.moc"
