/***************************************************************************
                          mymoneycategory.h
                             -------------------
    copyright            : (C) 2000 by Michael Edwardes
    email                : mte@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYMONEYCATEGORY_H
#define MYMONEYCATEGORY_H

// ----------------------------------------------------------------------------
// QT Includes

#include <tqstring.h>
#include <tqstringlist.h>

/**
  * @deprecated This class represents an Income or Expense category. Please don't
  *             use it anymore, as it will be removed sooner or later.
  */
class MyMoneyCategory {
  bool m_income; // if false, m_income == expense
  TQString m_name;
  TQStringList m_minorCategories;

  friend TQDataStream &operator<<(TQDataStream &, MyMoneyCategory &);
  friend TQDataStream &operator>>(TQDataStream &, MyMoneyCategory &);

public:
  MyMoneyCategory();
	MyMoneyCategory(const bool income, const TQString name);
	MyMoneyCategory(const bool income, const TQString name, TQStringList minors);
	~MyMoneyCategory();
	
	// Simple get operations
	TQString name(void) { return m_name; }
	TQStringList& minorCategories(void) { return m_minorCategories; }
	
	// Simple set operations
	bool isIncome(void) { return m_income; }
	void setIncome(const bool val) { m_income = val; }
	void setName(const TQString val) { m_name = val; }
	
  bool setMinorCategories(TQStringList values);
	bool addMinorCategory(const TQString val);
	bool removeMinorCategory(const TQString val);
	bool renameMinorCategory(const TQString oldVal, const TQString newVal);
	bool addMinorCategory(TQStringList values);
	bool removeAllMinors(void);
	TQString firstMinor(void);

	void clear(void);
	
  // Copy constructors
  MyMoneyCategory(const MyMoneyCategory&);
  MyMoneyCategory& operator = (const MyMoneyCategory&);
};

#endif
