#!/bin/bash -e

VERSION="$1" # E.g: '42.3'

if [ "${VERSION}" = "tumbleweed" ]; then
  URL="http://download.opensuse.org/tumbleweed"
  NAME="opensuse32/tumbleweed"
else
  URL="http://download.opensuse.org/distribution/leap/${VERSION}"
  NAME="opensuse32/leap"
fi

IMAGE="${NAME}:latest"
INSTALLROOT="/dev/shm/${IMAGE}"

sudo rm -rf "${INSTALLROOT}"
sudo mkdir -p "${INSTALLROOT}"

sudo zypper --root "${INSTALLROOT}" \
  ar "${URL}/repo/oss/" "oss"
sudo zypper --root "${INSTALLROOT}" \
  ar "${URL}/repo/non-oss/" "non-oss"

if [ "${VERSION}" != "tumbleweed" ]; then
  sudo zypper --root "${INSTALLROOT}" \
    ar "http://download.opensuse.org/update/leap/${VERSION}/oss/" "update-oss"
  sudo zypper --root "${INSTALLROOT}" \
    ar "http://download.opensuse.org/update/leap/${VERSION}/non-oss/" "update-non-oss"
fi
sudo zypper --root "${INSTALLROOT}" \
  --gpg-auto-import-keys ref
sudo setarch i686 zypper --root "${INSTALLROOT}"  \
  install --download-only -y \
  bash \
  filesystem \
  glibc \
  glibc-extra \
  libpcre1 \
  libselinux1 \
  openSUSE-release \
  system-user-root \
  util-linux vim \
  zypper
sudo rpm -Uvh --root "${INSTALLROOT}" "${INSTALLROOT}/var/cache/zypp/packages/oss/"*"/"*".rpm"

sudo chroot "${INSTALLROOT}" rpmdb --rebuilddb

FILE="${IMAGE//\//_}.tar"
sudo tar -C "${INSTALLROOT}" -c . >"${FILE}"
sudo rm -rf "${INSTALLROOT}"

docker rmi -f "${IMAGE}"
docker import "${FILE}" "${IMAGE}"

pigz "${FILE}"
mv -fv "${FILE}.gz" "${HOME}/tde/docker"
