#
# spec file for package libr (version R14)
#
# Copyright (c) 2014 Trinity Desktop Environment
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.
#
# Please submit bugfixes or comments via http://www.trinitydesktop.org/
#

# TDE variables
%if "%{?tde_version}" == ""
%define tde_version 14.0.9
%endif

%if 0%{?mdkversion} || 0%{?mgaversion} || 0%{?pclinuxos}
%define libr %{_lib}r
%else
%define libr libr
%endif


Name:		trinity-libr
Version:	0.6.0
Release:	%{?tde_version}_%{?!preversion:1}%{?preversion:0_%{preversion}}%{?dist}
Summary:	ELF binary resource library
Group:		System/Libraries
URL:		http://www.trinitydesktop.org/

%if 0%{?suse_version}
License:	GPL-2.0+
%else
License:	GPLv2+
%endif

#Vendor:		Trinity Project
#Packager:	Francois Andriot <francois.andriot@free.fr>

Prefix:		/usr
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Source0:	%{name}-%{tde_version}%{?preversion:~%{preversion}}.tar.gz

BuildRequires:	libtqt4-devel >= %{tde_epoch}:4.2.0

BuildRequires:	cmake >= 2.8
BuildRequires:	gcc-c++
BuildRequires:	pkgconfig

BuildRequires:	binutils-devel

# GLADE2
%if 0%{?mageia} || 0%{?mandriva} || 0%{?pclinuxos}
BuildRequires:	%{_lib}glade2.0_0-devel
%else
BuildRequires:	libglade2-devel
%endif


%description
Store and retrieve resources from ELF binaries.

##########

%package -n %{libr}
Summary:		Simple inter-process messaging system (TQt-based shared library)
Group:			System/Libraries

%description -n %{libr}
Store and retrieve resources from ELF binaries.

%post -n %{libr}
/sbin/ldconfig || :

%postun -n %{libr}
/sbin/ldconfig || :

%files -n %{libr}
%defattr(-,root,root,-)
%{_libdir}/libr.so.0
%{_libdir}/libr.so.0.0.0


##########

%package -n %{libr}-devel
Summary:		Simple inter-process messaging system (TQt interface)
Group:			Development/Libraries/C and C++
Requires:		%{libr} == %{version}-%{release}
Provides:		libr-devel == %{version}-%{release}

%description -n %{libr}-devel
Store and retrieve resources from ELF binaries.

%post -n %{libr}-devel
/sbin/ldconfig || :

%postun -n %{libr}-devel
/sbin/ldconfig || :

%files -n %{libr}-devel
%defattr(-,root,root,-)
%{_includedir}/libr/
%{_libdir}/libr.a
%{_libdir}/libr.la
%{_libdir}/libr.so
%{_libdir}/pkgconfig/libr.pc
%{_mandir}/man3/IconSVG.3*
%{_mandir}/man3/OneCanvasIconInfo.3*
%{_mandir}/man3/libr_clear.3*
%{_mandir}/man3/libr_close.3*
%{_mandir}/man3/libr_errmsg.3*
%{_mandir}/man3/libr_errno.3*
%{_mandir}/man3/libr_icon_close.3*
%{_mandir}/man3/libr_icon_geticon_byname.3*
%{_mandir}/man3/libr_icon_geticon_bysize.3*
%{_mandir}/man3/libr_icon_getuuid.3*
%{_mandir}/man3/libr_icon_setuuid.3*
%{_mandir}/man3/libr_list.3*
%{_mandir}/man3/libr_malloc.3*
%{_mandir}/man3/libr_open.3*
%{_mandir}/man3/libr_read.3*
%{_mandir}/man3/libr_resources.3*
%{_mandir}/man3/libr_size.3*
%{_mandir}/man3/libr_status.3*
%{_mandir}/man3/libr_write.3*


##########

%if 0%{?pclinuxos} || 0%{?suse_version} && 0%{?opensuse_bs} == 0
%debug_package
%endif

##########

%prep
%setup -q -n %{name}-%{tde_version}%{?preversion:~%{preversion}}


%build
unset QTDIR QTINC QTLIB

if ! rpm -E %%cmake|grep -q "cd build"; then
  %__mkdir_p build
  cd build
fi

%cmake \
  -DCMAKE_BUILD_TYPE="RelWithDebInfo" \
  -DCMAKE_C_FLAGS="${RPM_OPT_FLAGS} -DNDEBUG" \
  -DCMAKE_CXX_FLAGS="${RPM_OPT_FLAGS} -DNDEBUG" \
  -DCMAKE_SKIP_RPATH=ON \
  -DCMAKE_VERBOSE_MAKEFILE=ON \
  -DWITH_GCC_VISIBILITY=OFF \
  \
  -DINCLUDE_INSTALL_DIR=%{_includedir} \
  -DLIB_INSTALL_DIR=%{_libdir} \
  ..

%__make %{?_smp_mflags}


%install
%__rm -rf %{?buildroot}
%__make install DESTDIR=%{?buildroot} -C build


%clean
%__rm -rf %{?buildroot}


%changelog
