/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef DATABASE_H
#define DATABASE_H

#include "tqfeatures.h"

#ifndef TQT_NO_SQL
#include <tqdataview.h>
#include <tqdatabrowser.h>
#include <tqsqlcursor.h>
#include <tqstring.h>

class TQSqlDatabase;
class TQSqlForm;

class DatabaseSupport
{
public:
    DatabaseSupport();
    virtual ~DatabaseSupport() {}

    void initPreview( const TQString &connection, const TQString &table, TQObject *o,
		      const TQMap<TQString, TQString> &databaseControls );

protected:
    TQSqlDatabase* con;
    TQSqlForm* frm;
    TQString tbl;
    TQMap<TQString, TQString> dbControls;
    TQObject *parent;

};

class QDesignerDataBrowser : public TQDataBrowser, public DatabaseSupport
{
    Q_OBJECT
  

public:
    QDesignerDataBrowser( TQWidget *parent, const char *name );

protected:
    bool event( TQEvent* e );
};

class QDesignerDataView : public TQDataView, public DatabaseSupport
{
    Q_OBJECT
  

public:
    QDesignerDataView( TQWidget *parent, const char *name );

protected:
    bool event( TQEvent* e );

};
#endif

#endif
