/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#include <tqt.h>
#include <ntqvariant.h>

#ifdef USE_QT4

#include <Qt/ntqbitmap.h>

// This is taken straight from <private/qvariant_p.h>
#ifdef Q_CC_SUN // Sun CC picks the wrong overload, so introduce awful hack

template <typename T>
inline T *v_cast(const QVariant::Private *nd, T * = 0)
{
    QVariant::Private *d = const_cast<QVariant::Private *>(nd);
    return ((sizeof(T) > sizeof(QVariant::Private::Data))
            ? static_cast<T *>(d->data.shared->ptr)
            : static_cast<T *>(static_cast<void *>(&d->data.c)));
}

#else // every other compiler in this world

template <typename T>
inline const T *v_cast(const QVariant::Private *d, T * = 0)
{
    return ((sizeof(T) > sizeof(QVariant::Private::Data))
            ? static_cast<const T *>(d->data.shared->ptr)
            : static_cast<const T *>(static_cast<const void *>(&d->data.c)));
}

template <typename T>
inline T *v_cast(QVariant::Private *d, T * = 0)
{
    return ((sizeof(T) > sizeof(QVariant::Private::Data))
            ? static_cast<T *>(d->data.shared->ptr)
            : static_cast<T *>(static_cast<void *>(&d->data.c)));
}

#endif

template <typename T>
inline T qVariantToHelper(const QVariant::Private &d, QVariant::Type t,
                          const QVariant::Handler *handler, T * = 0)
{
    if (d.type == t)
        return *v_cast<T>(&d);

    T ret;
    handler->convert(&d, t, &ret, 0);
    return ret;
}

QFont QVariant::toFont() const {
	return qVariantToHelper<QFont>(d, Font, handler);
}

QColor QVariant::toColor() const {
	return qVariantToHelper<QColor>(d, Color, handler);
}

QCursor QVariant::toCursor() const {
	return qVariantToHelper<QCursor>(d, Cursor, handler);
}

QBitmap QVariant::toBitmap() const {
	return qVariantToHelper<QBitmap>(d, Bitmap, handler);
}

Q3PointArray QVariant::toPointArray() const {
	return qVariantToHelper<Q3PointArray>(d, PointArray, handler);
}

QRegion QVariant::toRegion() const {
	return qVariantToHelper<QRegion>(d, Region, handler);
}

QPixmap QVariant::toPixmap() const {
	return qVariantToHelper<QPixmap>(d, Pixmap, handler);
}

QImage QVariant::toImage() const {
	return qVariantToHelper<QImage>(d, Image, handler);
}

QBrush QVariant::toBrush() const {
	return qVariantToHelper<QBrush>(d, Brush, handler);
}

QPalette QVariant::toPalette() const {
	return qVariantToHelper<QPalette>(d, Palette, handler);
}

QColorGroup QVariant::toColorGroup() const {
	return qVariantToHelper<QColorGroup>(d, ColorGroup, handler);
}

QIconSet QVariant::toIconSet() const {
	return qVariantToHelper<QIconSet>(d, IconSet, handler);
}

QFont QVariant::asFont() {
	return toFont();
}

QColor QVariant::asColor() {
	return toColor();
}

#endif // USE_QT4
