/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#include <tqt.h>
#include <ntqmetaobject.h>

#ifdef USE_QT4

/*!
    Returns the number of slots for this class.

    If \a super is TRUE, inherited slots are included.

    \sa slotNames()
*/
int QMetaObject::numSlots( bool super ) const	// number of slots
{
    int i;
    int n=0;
    for (i=0;i<methodCount();i++) {
	if (method(i).methodType() == QMetaMethod::Slot) {
		n++;
	}
    }

    if ( !super || !superClass() )
	return n;
    return n + superClass()->numSlots( super );
}

/*!
    Returns the number of signals for this class.

    If \a super is TRUE, inherited signals are included.

    \sa signalNames()
*/
int QMetaObject::numSignals( bool super ) const	// number of signals
{
    int i;
    int n=0;
    for (i=0;i<methodCount();i++) {
	if (method(i).methodType() == QMetaMethod::Signal) {
		n++;
	}
    }

    if ( !super || !superClass() )
	return n;
    return n + superClass()->numSignals( super );
}

/*!  \internal

  Returns the meta data of the slot with the name \a n or 0 if no
  such slot exists.

  If  \a super is TRUE, inherited slots are included.

  FIXME: Superclass handling is badly broken
 */
const QMetaMethod* QMetaObject::slot( int index, bool super ) const
{
    QMetaMethod mm;
    const QMetaMethod *mr;
    int idx = index - ( super ? methodOffset() : 0 );
//    if ( slotDict && idx >= 0 && idx < (int) slotDict->count() ) {
    if ( idx >= 0 && idx < numSlots(true) ) {
//	return slotData + idx;
        mm = method(idx);
	mr = &mm;
	return mr;
    }
    if ( !super || !superClass() )
	return 0;
    return superClass()->slot( index, super );
}

/*!  \internal

  Returns the meta data of the signal with the name \a n or 0 if no
  such signal exists.

  If  \a super is TRUE, inherited signals are included.

  FIXME: Superclass handling is badly broken
 */
const QMetaMethod* QMetaObject::signal( int index, bool super ) const
{
    QMetaMethod mm;
    const QMetaMethod *mr;
    int idx = index - ( super ? methodOffset() : 0 );
//    if ( signalDict && idx >= 0 && idx < (int) signalDict->count() ) {
    if ( idx >= 0 && idx < numSignals(true) ) {
//	return signalData + idx;
        mm = method(idx);
	mr = &mm;
	return mr;
    }
    if ( !super || !superClass() )
	return 0;
    return superClass()->signal( index, super );
}

/*!
    Returns a list with the names of all this class's signals.

    If \a super is TRUE, inherited signals are included.
*/
TQT_QT_STRING_LIST_TYPE QMetaObject::signalNames( bool super ) const
{
    TQT_QT_STRING_LIST_TYPE l( FALSE );
    int n = methodCount();
    for( int i = 0; i < n; ++i ) {
	if (method(i).methodType() == QMetaMethod::Signal) {
		l.append( normalizedSignature(signal(i, super)->signature()) );
	}
    }
    return l;
}

/*!
    Returns a list with the names of all this class's slots.

    If \a super is TRUE, inherited slots are included.

    \sa numSlots()
*/
TQT_QT_STRING_LIST_TYPE QMetaObject::slotNames( bool super ) const
{
    TQT_QT_STRING_LIST_TYPE l( FALSE );
    int n = methodCount();
    for( int i = 0; i < n; ++i )
	if (method(i).methodType() == QMetaMethod::Slot) {
		l.append( normalizedSignature(slot( i, super)->signature()) );
	}
    return l;
}

/*! \internal
  Returns the index of the slot with name \n or -1 if no such slot exists.

  If  \a super is TRUE, inherited slots are included.

  FIXME: Superclass handling is badly broken
 */
int QMetaObject::findSlot( const char* n, bool super ) const
{
    TQT_QT_STRING_LIST_TYPE l( FALSE );
    int m = methodCount();
    for( int i = 0; i < m; ++i ) {
	if ( normalizedSignature(slot( i, super)->signature()) == QByteArray(n) ) {
		if (method(i).methodType() == QMetaMethod::Slot) {
			return i;
		}
	}
    }
    return -1;
}

/*! \internal
  Returns the index of the signal with name \n or -1 if no such signal exists.

  If  \a super is TRUE, inherited signals are included.

  FIXME: Superclass handling is badly broken
*/
int QMetaObject::findSignal( const char* n, bool super ) const
{
    TQT_QT_STRING_LIST_TYPE l( FALSE );
    int m = methodCount();
    for( int i = 0; i < m; ++i ) {
	if ( normalizedSignature(signal( i, super)->signature()) == QByteArray(n) ) {
		if (method(i).methodType() == QMetaMethod::Signal) {
			return i;
		}
	}
    }
    return -1;
}

#ifndef QT_NO_PROPERTIES

/*!
    Returns the number of properties for this class.

    If \a super is TRUE, inherited properties are included.

    \sa propertyNames()
 */
int QMetaObject::numProperties( bool super ) const	// number of signals
{
    int i;
    int n=0;
    for (i=0;i<propertyCount();i++) {
//	if (property(i).propertyType() == QMetaProperty::Property) {
		n++;
//	}
    }

    if ( !super || !superClass() )
	return n;
    return n + superClass()->numProperties( super );
}

/*!
    Returns the property meta data for the property at index \a index
    or 0 if no such property exists.

    If \a super is TRUE, inherited properties are included.

    \sa propertyNames()

    FIXME: Superclass handling is badly broken
 */
const QMetaProperty* QMetaObject::property( int index, bool super ) const
{
    QMetaProperty mp;
    const QMetaProperty *pr;
    int idx = index - ( super ? propertyOffset() : 0 );
//    if ( d->propData && idx >= 0 && idx < (int)d->numPropData )
    if ( idx >= 0 && idx < numProperties(true) )
	mp = property(idx);
	pr = &mp;
	return pr;
    if ( !super || !superClass() )
	return 0;
    return superClass()->property( index, super );
}

/*!
    Returns a list with the names of all this class's properties.

    If \a super is TRUE, inherited properties are included.

    \sa property()
*/
TQT_QT_STRING_LIST_TYPE QMetaObject::propertyNames( bool super ) const
{
//     TQT_QT_STRING_LIST_TYPE l( FALSE );
//
//     if ( superclass && super ) {
// 	QStrList sl = superclass->propertyNames( super );
// 	for ( QStrListIterator slit( sl ); slit.current(); ++slit )
// 	    l.append( slit.current() );
//     }
//
//     for( int i = 0; i < d->numPropData; ++i ) {
// 	if ( d->propData[i].isValid() )
// 	    l.append( d->propData[i].name() );
//     }
//
//     return l;

    TQT_QT_STRING_LIST_TYPE l( FALSE );
    int n = numProperties( super );
    for( int i = 0; i < n; ++i )
	l.append( property( i, super)->name() );
    return l;
}

/*!
    Returns the index for the property with name \a name or -1 if no
    such property exists.

    If \a super is TRUE, inherited properties are included.

    \sa property(), propertyNames()

    FIXME: Superclass handling is badly broken
*/

int QMetaObject::findProperty( const char *name, bool super ) const
{
    return indexOfProperty( name );
}

#endif // QT_NO_PROPERTIES

bool QMetaProperty::writable() const
{
    return isWritable();
}

#endif // USE_QT4
