/**********************************************************************
**   Copyright (C) 2000 Troll Tech AS.  All rights reserved.
**   Copyright (C) 2000, 2001 Phil Thompson <phil@river-bank.demon.co.uk>
**
**   This file is part of TQt GUI Designer.
**
**   This file may be distributed under the terms of the GNU General
**   Public License version 2 as published by the Free Software
**   Foundation and appearing in the file COPYING included in the
**   packaging of this file. If you did not get the file, send email
**   to info@trolltech.com
**
**   The file is provided AS IS with NO WARRANTY OF ANY KIND,
**   INCLUDING THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR
**   A PARTICULAR PURPOSE.
**
**********************************************************************/

#ifndef UIC_H
#define UIC_H

#include <tqnamespace.h>
#include <tqdom.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqmap.h>
#include <tqtextstream.h>
#include <tqcolor.h>


#define	PYTQT_VERSION	"3.18.1"


class Uic : public TQt
{
public:
    Uic( TQTextStream& out, TQDomDocument doc, const TQString &trm );

    void createFormImpl( const TQDomElement &e );

    TQString createObjectImpl( const TQDomElement &e, const TQString& parentClass, const TQString& parent, const TQString& layout = TQString::null );
    TQString createLayoutImpl( const TQDomElement &e, const TQString& parentClass, const TQString& parent, const TQString& layout = TQString::null );
    TQString createObjectInstance( const TQString& objClass, const TQString& parent, const TQString& objName );
    TQString createSpacerImpl( const TQDomElement &e, const TQString& parentClass, const TQString& parent, const TQString& layout = TQString::null );
    void createExclusiveProperty( const TQDomElement & e, const TQString& exclusiveProp );
    TQString createListBoxItemImpl( const TQDomElement &e, const TQString &parent );
    TQString createIconViewItemImpl( const TQDomElement &e, const TQString &parent );
    TQString createListViewColumnImpl( const TQDomElement &e, const TQString &parent );
    TQString createListViewItemImpl( const TQDomElement &e, const TQString &parent,
				    const TQString &parentItem );
    void createColorGroupImpl( const TQString& cg, const TQDomElement& e );
    TQColorGroup loadColorGroup( const TQDomElement &e );

    TQString getClassName( const TQDomElement& e );
    TQString getObjectName( const TQDomElement& e );
    TQString getLayoutName( const TQDomElement& e );

    TQString setObjectProperty( const TQString& objClass, const TQString& obj, const TQString &prop, const TQDomElement &e, bool stdset );

    TQString registerObject( const TQString& name );
    TQString registeredName( const TQString& name );
    bool isObjectRegistered( const TQString& name );
    TQStringList unique( const TQStringList& );

private:
    void pushIndent()
    {
	++nrindents;
	setIndent();
    }

    void popIndent()
    {
	--nrindents;
	setIndent();
    }

    void setIndent()
    {
	indent = "";

	for (int i = 0; i < nrindents; ++i)
		indent += newindent;
    }

    void initIndent()
    {
	newindent = "    ";
	indent = "";
	nrindents = 0;
    }

    TQString indent, newindent;
    int nrindents;

    TQTextStream& out;
    TQStringList objectNames;
    TQMap<TQString,TQString> objectMapper;
    TQStringList tags;
    TQStringList layouts;
    TQString formName;
    TQString lastItem;
    TQString trmacro;

    struct Buddy
    {
	Buddy( const TQString& k, const TQString& b )
	    : key( k ), buddy( b ) {}
	Buddy(){}; // for valuelist
	TQString key;
	TQString buddy;
	bool operator==( const Buddy& other ) const
	    { return (key == other.key); }
    };
    struct CustomInclude 
    {
	TQString header;
	TQString location;
    };
    TQValueList<Buddy> buddies;

    TQStringList layoutObjects;
    bool isLayout( const TQString& name ) const;

    uint item_used : 1;
    uint cg_used : 1;
    uint pal_used : 1;

    TQString pixmapLoaderFunction;
    TQString nameOfClass;
};

#endif
