/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

/*
  Copyright (C) 2007 Eike Hein <hein@kde.org>
*/


#include "terminal_splitter.h"
#include "terminal_splitter.moc"

#include <tqobjectlist.h>


TerminalSplitter::TerminalSplitter(Qt::Orientation o, TQWidget* parent, const char* name)
 : TQSplitter(o, parent, name)
{
    is_shutting_down = false;
}

TerminalSplitter::~TerminalSplitter()
{
}

void TerminalSplitter::setPrepareShutdown(bool shutdown)
{
    is_shutting_down = shutdown;
}

void TerminalSplitter::focusNext()
{
    focusNextPrevChild(true);
}

void TerminalSplitter::focusPrevious()
{
    focusNextPrevChild(false);
}

void TerminalSplitter::focusLast()
{
    if (is_shutting_down) return;

    if (terminalCount(true) == 1)
    {
        TQWidget* w = TQT_TQWIDGET(child(0, TQCString("TEWidget"), true));
        if (w) w->setFocus();
    }
    else
    {
        focusPrevious();
        focusNext();
    }
}

int TerminalSplitter::count()
{
    return (terminalCount() + splitterCount());
}

int TerminalSplitter::terminalCount(bool recursive)
{
    return queryList(TQCString("TEWidget"), 0, false, recursive)->count();
}

int TerminalSplitter::splitterCount(bool recursive)
{
    return queryList(TQCString("TerminalSplitter"), 0, false, recursive)->count();
}

bool TerminalSplitter::isFirst(TQWidget* w)
{
    /* Return whether the widget w is the first in the splitter. */

    if (idAfter(w) != 0)
        return true;
    else
        return false;
}

void TerminalSplitter::recursiveCleanup()
{
    /* Clean away empty splitters after a terminal was removed. */

    TQObjectList* list = queryList("TerminalSplitter", 0, false, false);
    TQObjectListIt it(*list);
    TQObject *obj;

    while ((obj = it.current()) != 0)
    {
        ++it;
        TerminalSplitter* splitter = static_cast<TerminalSplitter*>(TQT_TQWIDGET(obj));
        splitter->recursiveCleanup();
    }

    if (count() == 0)
        deleteLater();
    else
    {
        // Update minimum sizes.
        if (orientation() == Qt::Horizontal)
        {
            int minimumWidth = (terminalCount() > 1) ?
                terminalCount()*150+handleWidth() : terminalCount()*150;

            setMinimumSize(TQSize(minimumWidth, minimumHeight()));

        }
        else if (orientation() == Qt::Vertical)
        {
            int minimumHeight = (terminalCount() > 1) ?
                terminalCount()*70+handleWidth() : terminalCount()*70;

            setMinimumSize(TQSize(minimumWidth(), minimumHeight));
        }
    }
}
