/***************************************************************************
    copyright            : (C) 2004-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef AMAZONFETCHER_H
#define AMAZONFETCHER_H

#include "fetcher.h"
#include "configwidget.h"
#include "../datavectors.h"

#include <kurl.h>

#include <tqcstring.h> // for TQByteArray
#include <tqguardedptr.h>

class KLineEdit;

class TQCheckBox;
class TQLabel;

namespace TDEIO {
  class Job;
}

namespace Tellico {

  class XSLTHandler;
  namespace GUI {
    class ComboBox;
  }

  namespace Fetch {

/**
 * A fetcher for Amazon.com.
 *
 * @author Robby Stephenson
 */
class AmazonFetcher : public Fetcher {
Q_OBJECT
  

public:
  enum Site {
    Unknown = -1,
    US = 0,
    UK = 1,
    DE = 2,
    JP = 3,
    FR = 4,
    CA = 5
  };

  enum ImageSize {
    SmallImage=0,
    MediumImage=1,
    LargeImage=2,
    NoImage=3
  };

  AmazonFetcher(Site site, TQObject* parent, const char* name = 0);
  virtual ~AmazonFetcher();

  virtual TQString source() const;
  virtual bool isSearching() const { return m_started; }
  virtual void search(FetchKey key, const TQString& value);
  virtual void continueSearch();
  // amazon can search title, person, isbn, or keyword. No Raw for now.
  virtual bool canSearch(FetchKey k) const { return k == Title || k == Person || k == ISBN || k == UPC || k == Keyword; }
  virtual void stop();
  virtual Data::EntryPtr fetchEntry(uint uid);
  virtual Type type() const { return Amazon; }
  virtual bool canFetch(int type) const;
  virtual void readConfigHook(const TDEConfigGroup& config);

  virtual void updateEntry(Data::EntryPtr entry);

  struct SiteData {
    TQString title;
    KURL url;
  };
  static const SiteData& siteData(int site);

  /**
   * Returns a widget for modifying the fetcher's config.
   */
  virtual Fetch::ConfigWidget* configWidget(TQWidget* parent) const ;

  static StringMap customFields();

  class ConfigWidget;
  friend class ConfigWidget;

  static TQString defaultName();

private slots:
  void slotData(TDEIO::Job* job, const TQByteArray& data);
  void slotComplete(TDEIO::Job* job);

private:
  void initXSLTHandler();
  void doSearch();
  void parseTitle(Data::EntryPtr entry, int collType);
  bool parseTitleToken(Data::EntryPtr entry, const TQString& token);

  XSLTHandler* m_xsltHandler;
  Site m_site;
  ImageSize m_imageSize;

  TQString m_access;
  TQString m_amazonKey;
  TQString m_assoc;
  bool m_addLinkField;
  int m_limit;
  int m_countOffset;

  TQByteArray m_data;
  int m_page;
  int m_total;
  int m_numResults;
  TQMap<int, Data::EntryPtr> m_entries; // they get modified after collection is created, so can't be const
  TQGuardedPtr<TDEIO::Job> m_job;

  FetchKey m_key;
  TQString m_value;
  bool m_started;
  TQStringList m_fields;
};

class AmazonFetcher::ConfigWidget : public Fetch::ConfigWidget {
Q_OBJECT
  

public:
  ConfigWidget(TQWidget* parent_, const AmazonFetcher* fetcher = 0);

  virtual void saveConfig(TDEConfigGroup& config);
  virtual TQString preferredName() const;

private slots:
  void slotSiteChanged();

private:
  KLineEdit* m_assocEdit;
  KLineEdit* m_accessEdit;
  KLineEdit* m_secretKeyEdit;
  GUI::ComboBox* m_siteCombo;
  GUI::ComboBox* m_imageCombo;
};

  } // end namespace
} // end namespace
#endif
