/*
 * Port for usage with qt-framework and development for tdesvn
 * (C) 2005-2007 by Rajko Albrecht
 * http://tdesvn.alwins-world.de
 */
/*
 * ====================================================================
 * Copyright (c) 2002-2005 The RapidSvn Group.  All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library (in the file LGPL.txt); if not,
 * write to the Free Software Foundation, Inc., 51 Franklin St,
 * Fifth Floor, Boston, MA  02110-1301  USA
 *
 * This software consists of voluntary contributions made by many
 * individuals.  For exact contribution history, see the revision
 * history and logs, available at http://rapidsvn.tigris.org/.
 * ====================================================================
 */
#if defined( _MSC_VER) && _MSC_VER <= 1200
#pragma warning( disable: 4786 )// debug symbol truncated
#endif


// svncpp
#include "pool.hpp"
#include "url.hpp"

#include <tqglobal.h>
#include <tqvaluelist.h>

// subversion api
#include "svn_ra.h"

namespace svn
{
  static const char *
  VALID_SCHEMAS [] =
  {
    "http","https","file",
    "svn","svn+ssh","svn+http","svn+https","svn+file",
    "ksvn","ksvn+ssh","ksvn+http","ksvn+https","ksvn+file","ksvn",
    0
  };

  static bool mSchemasInitialized = false;
  TQValueList<TQString> mSchemas;

  Url::Url () {}

  Url::~Url () {}

  bool Url::isLocal(const TQString& url)
  {
      bool cs = false;
    if (
        url.startsWith("file://",cs) ||
        url.startsWith("/") ||
        url.startsWith("svn+file://",cs) ||
        url.startsWith("ksvn+file://",cs) )
    {
        return true;
    }
    return false;
  }

  bool Url::isValid (const TQString& url)
  {
    TQString urlTest(url);
    unsigned int index = 0;
    while (VALID_SCHEMAS[index]!=0)
    {
      TQString schema = TQString::FROMUTF8(VALID_SCHEMAS[index]);
      TQString urlComp = urlTest.mid(0, schema.length());

      if (schema == urlComp)
      {
        return true;
      }
      ++index;
    }

    return false;
  }

  TQString
  Url::transformProtokoll(const TQString&prot)
  {
    TQString _prot = prot.lower();
    if (TQString::compare(_prot,"svn+http")==0||
        TQString::compare(_prot,"ksvn+http")==0) {
        return TQString("http");
    } else if (TQString::compare(_prot,"svn+https")==0||
               TQString::compare(_prot,"ksvn+https")==0) {
        return TQString("https");
    }else if (TQString::compare(_prot,"svn+file")==0||
              TQString::compare(_prot,"ksvn+file")==0) {
        return TQString("file");
    } else if (TQString::compare(_prot,"ksvn+ssh")==0) {
        return TQString("svn+ssh");
    } else if (TQString::compare(_prot,"ksvn")==0) {
        return TQString("svn");
    }
    return _prot;
  }


  /**
   * the implementation of the function that pull the supported
   * url schemas out of the ra layer it rather dirty now since
   * we are lacking a higher level of abstraction
   */
  TQValueList<TQString>
  Url::supportedSchemas ()
  {
    if (mSchemasInitialized)
      return mSchemas;

    mSchemasInitialized = true;
    Pool pool;
    void * ra_baton;

    svn_error_t * error =
      svn_ra_init_ra_libs (&ra_baton, pool);
    if (error)
      return mSchemas;

    svn_stringbuf_t *descr;
    error =
      svn_ra_print_ra_libraries (&descr, ra_baton, pool);
    if (error)
      return mSchemas;

    // schemas are in the following form:
    // <schema>:<whitespace><description>\n...
    // find the first :
    TQString descriptions (descr->data);
    int pos=0;
    const int not_found = -1;
    do
    {
      const TQString tokenStart ("handles '");
      const TQString tokenEnd ("' schem");
      pos = descriptions.find (tokenStart, pos);
      if (pos == not_found)
        break;

      pos += tokenStart.length ();

      int posEnd = descriptions.find (tokenEnd, pos);
      if (posEnd == not_found)
        break;

      // found
      TQString schema (descriptions.mid(pos, posEnd-pos) + ":");
      mSchemas.push_back (schema);

      // forward to the next newline
      pos = posEnd + tokenEnd.length ();
    }
    while (pos != not_found);

    return mSchemas;
  }
}
