/*
 * Port for usage with qt-framework and development for tdesvn
 * (C) 2005-2007 by Rajko Albrecht
 * http://tdesvn.alwins-world.de
 */
/*
 * ====================================================================
 * Copyright (c) 2002-2005 The RapidSvn Group.  All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library (in the file LGPL.txt); if not,
 * write to the Free Software Foundation, Inc., 51 Franklin St,
 * Fifth Floor, Boston, MA  02110-1301  USA
 *
 * This software consists of voluntary contributions made by many
 * individuals.  For exact contribution history, see the revision
 * history and logs, available at http://rapidsvn.tigris.org/.
 * ====================================================================
 */

#ifndef _SVNCPP_LOG_ENTRY_H_
#define _SVNCPP_LOG_ENTRY_H_

#include "svnqt/svnqt_defines.hpp"
#include "svnqt/datetime.hpp"

//TQt
#include <tqglobal.h>

#include <tqglobal.h>
#include <tqstring.h>
#include <tqvaluelist.h>
#include <tqmap.h>

// apr
#include "apr_time.h"

// subversion api
#include "svn_types.h"
#include "svn_version.h"

namespace svn
{

  class SVNTQT_EXPORT LogChangePathEntry
  {
  public:
    LogChangePathEntry (const char *path_,
                        char action_,
                        const char *copyFromPath_,
                        const svn_revnum_t copyFromRevision_);

    LogChangePathEntry (const TQString &path_,
                        char action_,
                        const TQString &copyFromPath_,
                        const svn_revnum_t copyFromRevision_);

    LogChangePathEntry (const TQString &path_,
                        char action_,
                        const TQString &copyFromPath_,
                        const svn_revnum_t copyFromRevision_,
                        const TQString &copyToPath_,
                        const svn_revnum_t copyToRevision_);

    LogChangePathEntry();

    TQString path;
    char action;
    TQString copyFromPath;
    //! future use or useful in backends
    TQString copyToPath;

    TQLONG copyFromRevision;
    //! future use or useful in backends
    TQLONG copyToRevision;
  };

  typedef TQValueList<LogChangePathEntry> LogChangePathEntries;

  class SVNTQT_EXPORT LogEntry
  {
  public:
    LogEntry ();

    LogEntry (const svn_revnum_t revision,
              const char * author,
              const char * date,
              const char * message);
#if ((SVN_VER_MAJOR == 1) && (SVN_VER_MINOR >= 5)) || (SVN_VER_MAJOR > 1)
    LogEntry(svn_log_entry_t*);
#endif
    void setDate(const char*date);

    //! if -1 the entry is a fake entry and not real usable!
    TQLONG revision;
    TQLONG date;
    TQString author;
    TQString message;
    LogChangePathEntries changedPaths;
    TQLIST<TQLONG> m_MergedInRevisions;
  };
}

SVNTQT_EXPORT TQDataStream &operator<<(TQDataStream&s,const svn::LogEntry&r);
SVNTQT_EXPORT TQDataStream &operator<<(TQDataStream&s,const svn::LogChangePathEntry&r);

SVNTQT_EXPORT TQDataStream &operator>>(TQDataStream&s,svn::LogEntry&r);
SVNTQT_EXPORT TQDataStream &operator>>(TQDataStream&s,svn::LogChangePathEntry&r);

#endif
