/***************************************************************************
 *   Copyright (C) 2006-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef PROPERTIESDLG_H
#define PROPERTIESDLG_H

#include <tqvariant.h>
#include <kdialogbase.h>
#include <tqvaluelist.h>
#include <tqmap.h>
#include <tqstring.h>

#include "svnqttypes.hpp"
#include "revision.hpp"

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQSpacerItem;
class TQLabel;
class Propertylist;
class TQListViewItem;
class KPushButton;
class FileListViewItem;
class SvnItem;

namespace svn {
    class Client;
}

class PropertiesDlg : public KDialogBase
{
    Q_OBJECT
  

public:
    PropertiesDlg(SvnItem*, svn::Client*,
        const svn::Revision&aRev=svn::Revision(svn_opt_revision_working),
        TQWidget* parent = 0, const char* name = 0, bool modal = true);
    ~PropertiesDlg();

    bool hasChanged()const;
    void changedItems(svn::PropertiesMap&toSet,TQValueList<TQString>&toDelete);

protected:
    Propertylist* m_PropertiesListview;
    KPushButton* m_AddButton;
    KPushButton* m_DeleteButton;
    KPushButton* m_ModifyButton;

    TQHBoxLayout* PropertiesDlgLayout;
    TQVBoxLayout* m_rightLayout;
    TQSpacerItem* m_rightSpacer;

    SvnItem *m_Item;
    bool m_changed;
    bool initDone;
    svn::Client*m_Client;
    svn::Revision m_Rev;

protected slots:
    virtual void languageChange();

    virtual void slotHelp();
    virtual void slotSelectionChanged(TQListViewItem*);
    virtual void slotSelectionExecuted(TQListViewItem*);
    virtual void slotAdd();
    virtual void slotDelete();
    virtual void slotModify();

protected:
    virtual void initItem();

public slots:
    int exec();
    virtual void polish();

signals:
    void clientException(const TQString&);
};

#endif // PROPERTIESDLG_H
