/* 
 *  Copyright (C) 2004 Girish Ramakrishnan All Rights Reserved.
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 */

// $Id: traylabelmgr.h,v 1.3 2005/01/07 12:16:07 cs19713 Exp $

#ifndef _TRAYLABELMGR_H
#define _TRAYLABELMGR_H

#include <tqobject.h>
#include <tqptrlist.h>
#include <tqvaluelist.h>
#include <tqstringlist.h>
#include <tqtimer.h>
#include <tdeapplication.h>
#include "tqtraylabel.h"

class TQTrayLabel;
class TDECmdLineArgs;
class TQSessionManager;

class TrayLabelMgr : public TQObject, public KSessionManaged
{
  Q_OBJECT

public:
  static TrayLabelMgr* instance();

  ~TrayLabelMgr();

  bool saveState(TQSessionManager &sm);

  bool x11EventFilter(XEvent *);
  bool processCommand(const TQStringList &argv);
  int  hiddenLabelsCount(void) const;
  int  dockedLabelsCount(void) const;
  bool isWindowDocked(Window w);

public slots:
  void dockAnother();
  void quitAll();
  void undockAll();

private slots:
  void startup();
  void doRestoreSession();
  void trayLabelDestroyed(TQObject *);
  void sysTrayDestroyed(void);
  void notifySysTrayAbsence();

private:
  TrayLabelMgr();
  bool processCommand(int argc, char** argv);
  bool processCommand(TDECmdLineArgs *args);
  void manageTrayLabel(TQTrayLabel *l);
  void restoreSession();

  TQTrayLabel* dockApplication(char *argv[]);
  TQTrayLabel* selectAndDock(Window w = None, bool checkNormality = true);

  TQPtrList<TQTrayLabel> mTrayLabels;
  TQValueList<TQStringList> mRequestQ;
  TQTimer restoreSessionTimer;
  bool mReady;
  int mHiddenLabelsCount;

  static TrayLabelMgr *gTrayLabelMgr;
};

#endif // _TRAYLABELMGR_H

