/* Domino widget style for KDE 3
   Copyright (C) 2006 Michael Lentner <michaell@gmx.net>

   based on the KDE style "Plastik":
   Copyright (C) 2003 Sandro Giessl <ceebx@users.sourceforge.net>

   based on the KDE style "dotNET":
   Copyright (C) 2001-2002, Chris Lee <clee@kde.org>
				Carsten Pfeiffer <pfeiffer@kde.org>
				Karol Szwed <gallium@kde.org>
   Drawing routines completely reimplemented from KDE3 HighColor, which was
   originally based on some stuff from the KDE2 HighColor.

   based on drawing routines of the style "Keramik":
   Copyright (c) 2002 Malte Starostik <malte@kde.org>
		 (c) 2002,2003 Maksim Orlovich <mo002j@mail.rochester.edu>
   based on the KDE3 HighColor Style
   Copyright (C) 2001-2002 Karol Szwed		<gallium@kde.org>
		 (C) 2001-2002 Fredrik Hglund	<fredrik@kde.org>
   Drawing routines adapted from the KDE2 HCStyle,
   Copyright (C) 2000 Daniel M. Duley		<mosfet@kde.org>
		 (C) 2000 Dirk Mueller			<mueller@kde.org>
		 (C) 2001 Martijn Klingens		<klingens@kde.org>
   Progressbar code based on TDEStyle,
   Copyright (C) 2001-2002 Karol Szwed <gallium@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#ifndef __DOMINO_H
#define __DOMINO_H

#include <tdestyle.h>
#include <tqintcache.h>
#include <tdetoolbarbutton.h>
#include "misc.h"
#include "data.h"
#include <tqpixmapcache.h>


// #include <X11/extensions/Xrender.h>
#include <X11/Xft/Xft.h>
class ButtonContour;
class RubberWidget;
class Rubber;


	enum ContourType
{
	Contour_Sunken = 0,
	Contour_Raised = 1,
	Contour_Simple = 2
};

	enum ContourState
{
	Contour_Default = 0,
	Contour_Pressed = 1,
	Contour_MouseOver = 2,
	Contour_DefaultButton = 3
};

	enum TextEffect
{
	TextEffect_None = 0,
	TextEffect_OnlyButton = 1,
	TextEffect_Everywhere = 2
};

	struct DSurface {
		int numGradients;
		TQColor g1Color1;
		TQColor g1Color2;
		TQColor g2Color1;
		TQColor g2Color2;
		TQColor background;
		int g1Top;
		int g1Bottom;
		int g2Top;
		int g2Bottom;
	};


class DominoStyle : public TDEStyle
{
	Q_OBJECT

	friend class DominoStyleConfig;

public:
	
	DominoStyle();
	virtual ~DominoStyle();
	
	enum PaletteTyp
	{
		Palette_Application,
		Palette_Parent,
		Palette_Widget
	};
	
	void applicationPolish( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void * );
	void polish( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void * );
	void polish( TQPalette &p );
	void unPolish( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void * );
	
	void drawTDEStylePrimitive(TDEStylePrimitive kpe,
				TQPainter* p,
				const TQStyleControlElementData &ceData,
				ControlElementFlags elementFlags,
				const TQRect &r,
				const TQColorGroup &cg,
				SFlags flags = Style_Default,
				const TQStyleOption& = TQStyleOption::Default,
				const TQWidget* widget = 0 ) const;

	void drawPrimitive(PrimitiveElement pe,
				TQPainter *p,
				const TQStyleControlElementData &ceData,
				ControlElementFlags elementFlags,
				const TQRect &r,
				const TQColorGroup &cg,
				SFlags flags = Style_Default,
				const TQStyleOption &opt = TQStyleOption::Default ) const;

	void drawControl(ControlElement element,
				TQPainter *p,
				const TQStyleControlElementData &ceData,
				ControlElementFlags elementFlags,
				const TQRect &r,
				const TQColorGroup &cg,
				SFlags flags = Style_Default,
				const TQStyleOption& = TQStyleOption::Default,
				const TQWidget *widget = 0 ) const;

	void drawControlMask( TQ_ControlElement,
				TQPainter *,
				const TQStyleControlElementData &ceData,
				ControlElementFlags elementFlags,
				const TQRect &,
				const TQStyleOption &,
				const TQWidget *) const;

	void drawComplexControl(TQ_ComplexControl control,
				TQPainter *p,
				const TQStyleControlElementData &ceData,
				ControlElementFlags elementFlags,
				const TQRect &r,
				const TQColorGroup &cg,
				SFlags flags = Style_Default,
				SCFlags controls = SC_All,
				SCFlags active = SC_None,
				const TQStyleOption& = TQStyleOption::Default,
				const TQWidget *widget = 0 ) const;

	int pixelMetric(PixelMetric m,
				const TQStyleControlElementData &ceData,
				ControlElementFlags elementFlags,
				const TQWidget *widget = 0 ) const;

	TQRect subRect(SubRect r,
				const TQStyleControlElementData &ceData,
				ControlElementFlags elementFlags,
				const TQWidget *widget ) const;

	TQRect querySubControlMetrics(ComplexControl control,
				const TQStyleControlElementData &ceData,
				ControlElementFlags elementFlags,
				SubControl subcontrol,
				const TQStyleOption &opt = TQStyleOption::Default,
				const TQWidget *widget = 0 ) const;

	TQSize sizeFromContents(TQStyle::ContentsType t,
				const TQStyleControlElementData &ceData,
				ControlElementFlags elementFlags,
				const TQSize &s,
				const TQStyleOption &o,
				const TQWidget *w = 0) const;

	int styleHint(TQ_StyleHint,
				const TQStyleControlElementData &ceData,
				ControlElementFlags elementFlags,
				const TQStyleOption & = TQStyleOption::Default,
				TQStyleHintReturn * = 0,
				const TQWidget * = 0 ) const;
	
	
	TQPixmap stylePixmap(StylePixmap stylepixmap,
				const TQStyleControlElementData &ceData,
				ControlElementFlags elementFlags,
				const TQStyleOption& opt,
				const TQWidget* widget = 0) const;
	
	void drawItem( TQPainter *p, const TQRect &r,
		       int flags, const TQColorGroup &g, bool enabled,
		       const TQPixmap *pixmap, const TQString &text,
		       int len = -1, const TQColor *penColor = 0) const;
	
	void dominoDrawItem( TQPainter *p, const TQRect &r,
		       int flags, const TQColorGroup &g, bool enabled,
		       const TQPixmap *pixmap, const TQString &text,
		       int len = -1, const TQColor *penColor = 0, bool buttonTextEffect = 0 ) const;
	
	void setDominoButtonPalette(TQWidget* widget, PaletteTyp type);
	
	virtual void drawFocusIndicator(TQPainter *p,
				const TQRect &r,
				int flags,
				const TQColorGroup cg,
				bool /*enabled*/,
				const TQPixmap*  /*pixmap*/,
				const TQString & text,
				int /*len = -1*/,
				const TQColor& highlight = TQColor(0, 0, 0),
				bool drawLine = true,
				bool isButton = false) const;
	
	TQPixmap renderOutlineIcon(const TQPixmap* icon) const;
	
	void renderSurface(TQPainter *p,
			   const TQRect &r,
			   const TQColor &backgroundColor,
			   const TQColor &buttonColor,
			   const TQColor &highlightColor,
			   const uint flags = Draw_Left|Draw_Right|Draw_Top|Draw_Bottom|
					   Round_UpperLeft|Round_UpperRight|Round_BottomLeft|Round_BottomRight|Is_Horizontal) const;
	
	inline TQWidget::BackgroundOrigin setPixmapOrigin(TQWidget::BackgroundOrigin origin);
	
	mutable Rubber* rubber;
	mutable TQRect oldRubberRect;
	mutable bool viewPortPressed;
	mutable bool ignoreNextFocusRect;
	uint _argbRubberBandColor;
	mutable bool compositeManagerRunning;
	const TQWidget* rubberViewPort;
	
protected:
	
	enum RubberType
	{
		ArgbRubber = 1,
		LineRubber = 2,
		DistRubber = 3
	};
	RubberType rubberBandType;
	
	enum TabPosition
	{
	First ,
	Middle,
	Last,
	Single
	};

	struct TextEffectSettings {
		TextEffect mode;
		TQColor color;
		TQColor buttonColor;
		int opacity;
		int buttonOpacity;
		TQPoint pos;
		TQPoint buttonPos;
	};

	struct GroupBoxSettings {
		bool tintBackground;
		int brightness;
		bool customColor;
		TQColor color;
	};

	struct FocusIndicatorSettings {
		TQColor color;
		int opacity;
		TQColor buttonColor;
		int buttonOpacity;
		bool drawUnderline;
		bool indicateFocus;
	};

	
	mutable TextEffectSettings textEffectSettings;
	GroupBoxSettings groupBoxSettings;
	FocusIndicatorSettings focusIndicatorSettings;
	
	ButtonContour* buttonContour;
	
	enum SurfaceFlags {
	Draw_Left =			 0x00000001,
	Draw_Right =		 0x00000002,
	Draw_Top =			 0x00000004,
	Draw_Bottom =		 0x00000008,
	Is_Horizontal =		 0x00000200,
	Is_Highlight =		 0x00000400,
	Is_Default =			 0x00000800,
	Is_Disabled =		 0x00001000,
	Round_UpperLeft =	 0x00002000,
	Round_UpperRight =	 0x00004000,
	Round_BottomLeft =	 0x00008000,
	Round_BottomRight = 0x00010000,
	Rectangular_UpperLeft =	 0x00000010,
	Rectangular_UpperRight =	 0x10000020,
	Rectangular_BottomLeft =	 0x00000040,
	Rectangular_BottomRight = 0x00000080,
	
	Draw_AlphaBlend =	0x00020000,
	Is_ComboBox =		0x00080000,
	Is_Button =			0x00100000,
	Is_CheckItem =		0x00200000,
	Is_RadioButton =		0x00400000,
	Is_TabTop =			0x00000100,
	Is_TabBottom =		0x01000000,
	Is_ActiveTabTop =	0x00040000,
	Is_ActiveTabBottom =	0x00800000,
	Is_ScrollBarBtn =		0x02000000,
	Is_Header =			0x04000000,
	Is_ScrollBarGroove =	0x08000000,
	Is_Slider =			0x20000000,
	Is_Down =			0x40000000
	};
	
	enum DominoStyleFlags {
		Domino_noCache = 0x80000000
	};
	
	enum DominoPrimitiveElement {
		PE_ScrollBarSubLine2 = 0xf000001
	};
	
	void renderContour(TQPainter *p,
			const TQRect &r,
			const TQColor &backgroundColor,
			const TQColor &contourColor,
			const uint flags = Draw_Left|Draw_Right|Draw_Top|Draw_Bottom|
				Round_UpperLeft|Round_UpperRight|Round_BottomLeft|Round_BottomRight) const;
	
	void renderButtonShadow(TQPainter *p, const TQRect &r, const uint flags = Draw_Left|Draw_Right|Draw_Top|Draw_Bottom|
			Round_UpperLeft|Round_UpperRight|Round_BottomLeft|Round_BottomRight|Is_Horizontal) const;
	
	TQPixmap* renderLineEditShadow(TQWidget* widget, TQRect rect, TQColor bg, uint flags, bool reverse);
	
	inline void renderPixel(TQPainter *p,
		const TQPoint &pos,
		const int alpha,
		const TQColor &color,
		const TQColor &background = TQColor(),
		bool fullAlphaBlend = true) const;

	void renderButton(TQPainter *p,
			  const TQRect &r,
			  const TQColorGroup &g,
			  bool sunken = false,
			  bool mouseOver = false,
			  bool horizontal = true,
			  bool enabled = true,
			  bool tdehtmlMode = false) const;

	void renderHeader(TQPainter *p,
			  const TQRect &r,
			  const TQColorGroup &g,
			  bool sunken = false,
			  bool mouseOver = false,
			  bool horizontal = true,
			  bool enabled = true) const;

	void renderGradient(TQPainter *p,
			const TQRect &r,
			const TQColor &c1,
			const TQColor &c2,
			bool horizontal = true) const;

	void renderTab(TQPainter *p,
			const TQRect &r,
			const TQColorGroup &g,
			bool mouseOver = false,
			const bool selected = false,
			const bool bottom = false,
			const TabPosition pos = Middle,
			const bool triangular = false,
			const bool cornerWidget = false,
			const bool konqTab = false) const;
	
	DSurface btnSurface;
	DSurface tabTopSurface;
	DSurface activeTabTopSurface;
	DSurface tabBottomSurface;
	DSurface activeTabBottomSurface;
	DSurface scrollBarSurface;
	DSurface scrollBarGrooveSurface;
	DSurface headerSurface;
	DSurface checkItemSurface;
	
	virtual bool objectEventHandler( const TQStyleControlElementData &ceData,
			ControlElementFlags elementFlags,
			void* source,
			TQEvent *ev );
	
	TQString configMode;
	void removeCachedSbPix(const TQColor &color) {
		TQPixmapCache::remove("sHCap"+TQString::number(color.pixel(), 16)+"1"+configMode);
		TQPixmapCache::remove("sHCap"+TQString::number(color.pixel(), 16)+"0"+configMode);
		TQPixmapCache::remove("sVCap"+TQString::number(color.pixel(), 16)+"1"+configMode);
		TQPixmapCache::remove("sVCap"+TQString::number(color.pixel(), 16)+"0"+configMode);
		TQPixmapCache::remove(TQString::number(color.pixel(), 16)+"sh"+configMode);
		TQPixmapCache::remove(TQString::number(color.pixel(), 16)+"sv"+configMode);
		TQPixmapCache::remove(TQString::number(color.pixel(), 16)+"ah"+configMode);
		TQPixmapCache::remove(TQString::number(color.pixel(), 16)+"av"+configMode);
	};
	
	TQColor getGroupBoxColor(const TQWidget* w) const;
	TQPixmap* createCheckMark(const TQColor color) const;
	TQPixmap* createRadioIndicator(const TQColor color) const;
	TQPixmap disableIcon(const TQPixmap* icon) const;;
	
	TQWidget* hoverWidget;

	TQPixmap* checkMark;
	TQPixmap* radioIndicator;
	TQPixmap* popupFrame;
	TQPixmap* border1;
	mutable bool alphaButtonMode;
	bool TDEApplicationMode;
	TQColor _checkMarkColor;
	
	TQMap<const TQGroupBox*, const TQPixmap*> groupBoxPixmaps;
	uint preMultiplyColor(const uint &c) const;
	TQToolButton* popupButton;
	TQTimer* popupTimer;
	TQPoint popupMousePressPos;

protected slots:
	void tdehtmlWidgetDestroyed(TQObject* w);
	void groupBoxDestroyed(TQObject* w);
	
	//Animation slots.
	void updateProgressPos();
	void updateScrollPos(); // smoothscroll
	
	void progressBarDestroyed(TQObject* bar);
	inline TQColor dGetColor(const TQColor &color, const int value) const;
	inline TQColor lightenColor(const TQColor &color, const int value) const;
	inline TQColor darkenColor(const TQColor &color, const int value) const;
	void updateTabWidgetFrame();
	void spinBoxValueChanged(int);
	void toolPopupPressed();
	void popupToolMenu();
	void toolPopupReleased();
	
private:
	// Disable copy constructor and = operator
	DominoStyle( const DominoStyle & );
	DominoStyle& operator=( const DominoStyle & );

	bool kickerMode;
	bool konquerorMode;
	bool konsoleMode;
	
	mutable bool flatMode;
	bool sideRepaint;
	bool _animateProgressBar;
	bool _drawTriangularExpander;
	bool _customCheckMarkColor;
	bool _smoothScrolling;
	TQColor _toolTipColor;
	int _buttonHeightAdjustment;
	bool _customPopupMenuColor;
	TQColor _popupMenuColor;
	bool _customSelMenuItemColor;
	TQColor _selMenuItemColor;
	bool _drawPopupMenuGradient;
	bool _indentPopupMenuItems;
	bool _centerTabs;
	bool _wheelSwitchesTabs;
	bool _customSliderHandleContourColor;
	bool _drawButtonSunkenShadow;
	bool _toolBtnAsBtn;
	bool _highlightToolBtnIcon;
	
	bool konqTab;
	int minTabLength;
	bool macStyleBar;
	int konqTabBarContrast;
	bool spinWidgetDown;
	
	mutable int sliderlen;
	
	// smoothscrolling
	int scrollDistance;
	bool scrollVertical;
	TQScrollView* scrollWidget;
	TQTimer* scrollTimer;
	
	bool hoveredToolBoxTab;
	
	// track tdehtml widgets.
	TQMap<const TQWidget*,bool> tdehtmlWidgets;
	
	//Animation support.
	TQMap<TQWidget*, int> progAnimWidgets;

	// pixmap cache.
	enum CacheEntryType {
		cSurface,
		cGradientTile,
		cAlphaDot
	};
	
	struct CacheEntry
	{
		CacheEntryType type;
		int width;
		int height;
		TQRgb c1Rgb;
		TQRgb c2Rgb;
		bool horizontal;
	
		TQPixmap* pixmap;
	
		CacheEntry(CacheEntryType t, int w, int h, TQRgb c1, TQRgb c2 = 0,
			bool hor = false, TQPixmap* p = 0 ):
			type(t), width(w), height(h), c1Rgb(c1), c2Rgb(c2), horizontal(hor), pixmap(p)
		{}
	
		~CacheEntry()
		{
			delete pixmap;
		}
	
		int key()
		{
			// create an int key from the properties which is used to refer to entries in the TQIntCache.
			// the result may not be 100% correct as we don't have so much space in one integer -- use
			// == operator after find to make sure we got the right one. :)
			return horizontal ^ (type<<1) ^ (width<<5) ^ (height<<10) ^ (c1Rgb<<19) ^ (c2Rgb<<22);
		}
	
		bool operator == (const CacheEntry& other)
		{
			bool match = (type == other.type) &&
				(width	 == other.width) &&
				(height == other.height) &&
				(c1Rgb == other.c1Rgb) &&
				(c1Rgb == other.c1Rgb) &&
				(horizontal = other.horizontal);
// 				   if(!match) {
// 					   tqDebug("operator ==: CacheEntries don't match!");
// 					   tqDebug("width: %d\t\tother width: %d", width, other.width);
// 					   tqDebug("height: %d\t\tother height: %d", height, other.height);
// 					   tqDebug("fgRgb: %d\t\tother fgRgb: %d", fgRgb, other.fgRgb);
// 					   tqDebug("bgRgb: %d\t\tother bgRgb: %d", bgRgb, other.bgRgb);
// 					   tqDebug("surfaceFlags: %d\t\tother surfaceFlags: %d", surfaceFlags, other.surfaceFlags);
// 				   }
			return match;
		}
	};
	TQIntCache<CacheEntry> *pixmapCache;

	// For KPE_ListViewBranch
	mutable TQBitmap *verticalLine;
	mutable TQBitmap *horizontalLine;
	
	// For progress bar animation
	TQTimer *animationTimer;
	
	void renderTabSeparator(TQPainter *p, const TQRect &r, const TQColor buttonColor, bool tabAbove) const;
	void renderGroupBox(TQObject *obj, TQEvent *ev);
};



class ButtonContour
{
	friend class DominoStyleConfig;
	friend class DominoStyle;
	
	public:
		ButtonContour();
		virtual ~ButtonContour();
		
		static const int num_states = 4;
		static const int num_types = 3;
		ContourType defaultType;
		ContourType type;
		ContourState state;
		bool alpha_mode;
		bool drawButtonSunkenShadow;
		int created[num_types][num_states];
		int shadowCreated[num_states];
		
		TQColor contour[num_states];
		uint c1[num_types][num_states]; // top shadow
		uint c2[num_types][num_states]; // outer ring
		uint c3[num_types][num_states]; // inner ring
		uint c4[num_types][num_states]; // bottom first shadow line
		uint c5[num_types][num_states]; // bottom second shadow line
		uint c6[num_types][num_states]; // first left shadow line
		TQPixmap* btnEdges[num_types][num_states];
		TQPixmap* btnVLines[num_types][num_states];
		TQPixmap* btnHLines[num_types][num_states];
		
		// for sunken type and sunken flat buttons
		TQPixmap* buttonShadowRectangular[num_states];
		TQPixmap* buttonShadowRound [num_states];
		TQPixmap* buttonShadowHlines[num_states];
		TQPixmap* buttonShadowVlines[num_states];
		
		
		bool alphaMode() {
			return alpha_mode;
		}
		uint color1() {
			return c1[type][state];
		}
		uint color2() {
			return c2[type][state];
		}
		uint color3() {
			return c3[type][state];
		}
		uint color4() {
			return c4[type][state];
		}
		uint color5() {
			return c5[type][state];
		}
		uint color6() {
			return c6[type][state];
		}
		TQColor contourColor(int t) {
			return contour[t];
		}
		TQPixmap* buttonEdges() {
			return btnEdges[type][state];
		}
		TQPixmap* buttonVLines() {
			return btnVLines[type][state];
		}
		TQPixmap* buttonHLines() {
			return btnHLines[type][state];
		}
		void setType(ContourType t = Contour_Sunken) {
			type = t;
			createPixmaps(type, state);
		}
		void setState(ContourState s = Contour_Default) {
			state = s;
			if(s == Contour_Pressed && type != Contour_Sunken)
				type = Contour_Simple;
			createPixmaps(type, state);
		}
		void setContour(ContourType t = Contour_Sunken, ContourState s = Contour_Default) {
			type = t;
			state = s;
			createPixmaps(type, state);
		}
		void setColor(ContourState s, TQColor color) {
			contour[s] = color;
			
			uint c2_tmp;
			uint c3_tmp;
			if(defaultType == Contour_Sunken /*|| defaultType == Contour_Simple*/) {
				c2_tmp = tqRgba(contour[s].red(), contour[s].green(), contour[s].blue(), 218);
				c3_tmp = tqRgba(contour[s].red(), contour[s].green(), contour[s].blue(), 35);
			}
			else {
				c2_tmp = tqRgba(contour[s].red(), contour[s].green(), contour[s].blue(), 203);
				
				TQColor whiteColor(tqRgba(TQt::white.red(), TQt::white.green(), TQt::white.blue(), 34));
				TQColor blackColor(tqRgba(contour[s].red(), contour[s].green(), contour[s].blue(), 35));
				
				c3_tmp = blendColors(whiteColor, blackColor).rgb();
			}
			
			for(int t = 0; t < num_types; t++) {
				c2[t][s] = c2_tmp; // outer ring
				c3[t][s] = c3_tmp; // inner ring
			}
		}
		void setDefaultType(ContourType t = Contour_Raised, bool create = true) {
			defaultType = t;
			type = t;
			if(create)
				createPixmaps(type, state);
		}
		void setAlphaMode() {
			alpha_mode = true;
		}
		void reset() {
			type = defaultType;
			state = Contour_Default;
			alpha_mode = false;
		}
		
		TQPixmap* shadowRound() {
			return buttonShadowRound[state];
		}
		TQPixmap* shadowRectangular() {
			return buttonShadowRectangular[state];
		}
		TQPixmap* shadowHLines() {
			return buttonShadowHlines[state];
		}
		TQPixmap* shadowVLines() {
			return buttonShadowVlines[state];
		}
		
		void createPixmaps(ContourType t = Contour_Sunken, ContourState s = Contour_Default) {
			type = t;
			state = s;
			
			
			// for pressed sunken buttons + pressed KMultiTabbarTabs
			if(drawButtonSunkenShadow && !shadowCreated[state]) {
				
				TQColor shadowColor = alphaBlendColors(TQt::black, contour[state], 120);
				buttonShadowRectangular[state] = new TQPixmap(tintImage(qembed_findImage("btnPressedShadowRectangular"), shadowColor));
				buttonShadowRound[state] = new TQPixmap(tintImage(qembed_findImage("btnPressedShadowRound"), shadowColor));
				buttonShadowHlines[state] = new TQPixmap(tintImage(qembed_findImage("btnPressedShadowHLines"), shadowColor));
				buttonShadowVlines[state] = new TQPixmap(tintImage(qembed_findImage("btnPressedShadowVLines"), shadowColor));
				shadowCreated[state] = 1;
			}
			
			
			if(created[type][state])
				return;
			
			TQImage btnVLines_img;
			TQImage btnHLines_img;
			TQImage btnShadow_img;
			
			switch(type) {
				case Contour_Simple: // now pressed raised!
					btnShadow_img = qembed_findImage("btnRSPr"); // the inner white ring
					blend(tintImage(qembed_findImage("btn"), contour[state]), btnShadow_img, btnShadow_img);
					btnHLines_img = qembed_findImage("btnHRSPr");
					blend(tintImage(qembed_findImage("btnH"), contour[state]), btnHLines_img, btnHLines_img);
					btnVLines_img = qembed_findImage("btnVRSPr");
					blend(tintImage(qembed_findImage("btnV"), contour[state]), btnVLines_img, btnVLines_img);
					break;
				case Contour_Sunken:
					btnShadow_img = qembed_findImage("btnSSh");
					blend(tintImage(qembed_findImage("btn"), contour[state]), btnShadow_img, btnShadow_img);
					btnHLines_img = qembed_findImage("btnHSSh");
					blend(tintImage(qembed_findImage("btnH"), contour[state]), btnHLines_img, btnHLines_img);
					btnVLines_img = qembed_findImage("btnVSSh");
					blend(tintImage(qembed_findImage("btnV"), contour[state]), btnVLines_img, btnVLines_img);
					break;
				case Contour_Raised:
					btnShadow_img = qembed_findImage("btn17RaisedShadow3"); // the inner white ring + outer shadow
					blend(tintImage(qembed_findImage("btn"), contour[state]), btnShadow_img, btnShadow_img);
					btnHLines_img = qembed_findImage("btnHRSh");
					blend(tintImage(qembed_findImage("btnH"), contour[state]), btnHLines_img, btnHLines_img);
					btnVLines_img = qembed_findImage("btnVRSh");
					blend(tintImage(qembed_findImage("btnV"), contour[state]), btnVLines_img, btnVLines_img);
				default:
					break;
			}
			
			btnEdges[type][state] = new TQPixmap(btnShadow_img);
			btnVLines[type][state] = new TQPixmap(btnVLines_img);
			btnHLines[type][state] = new TQPixmap(btnHLines_img);
			created[type][state] = 1;
		}
};

class RubberWidget : public TQWidget
{
	public:
		RubberWidget(Window window);
		~RubberWidget();
};

class Rubber
{
	friend class DominoStyle;
	
	public:
		Rubber(uint col);
		~Rubber();
		
		Visual* visual;
		Colormap colormap;
		XSetWindowAttributes wsa;
		Window window;
		
		RubberWidget* parent;
		RubberWidget* rubber;
		TQRegion mask;
		uint color;
		
		void destroy() {
			if(parent) {
				delete rubber;
				delete parent;
				window = 0;
				parent = 0;
				rubber = 0;
			}
		}
		void create(TQRect& r, TQRegion& mask);
		void updateMask(TQRegion& mask);
};


// DominoXXX classes to access protected (or private...) members
class DominoTQGroupBox : public TQGroupBox
{
	friend class DominoStyle;
	public:
		DominoTQGroupBox( TQWidget* parent=0, const char* name=0 )
	: TQGroupBox( parent, name ) {}
};

class DominoTQWidget : public TQWidget
{
	friend class DominoStyleConfig;
	friend class DominoStyle;
	public:
		DominoTQWidget( TQWidget* parent=0, const char* name=0 )
	: TQWidget( parent, name ) {}
	
};

class DominoTQFrame : public TQFrame
{
	friend class DominoStyle;
	public:
		DominoTQFrame( TQFrame* parent=0, const char* name=0 )
	: TQFrame( parent, name ) {}
};

// TQWhatsThis
class DominoTQWhatsThat : public TQWidget
{
	friend class DominoStyle;
	public:
		DominoTQWhatsThat(): TQWidget() {}
	private:
		TQString text;
};

class DominoKToolBarButton : public TDEToolBarButton
{
	friend class DominoStyle;
	public:
		DominoKToolBarButton(): TDEToolBarButton() {}
};

class DominoTQListBoxItem : public TQListBoxItem
{
	friend class DominoStyle;
	public:
		DominoTQListBoxItem(): TQListBoxItem() {}
};

class DominoTQTabWidget : public TQTabWidget
{
	friend class DominoStyleConfig;
	friend class DominoStyle;
	public:
		DominoTQTabWidget( TQWidget* parent=0, const char* name=0 )
	: TQTabWidget( parent, name ) {}
};

class DominoTQSpinBox : public TQSpinBox
{
	friend class DominoStyle;
	public:
		DominoTQSpinBox( TQFrame* parent=0, const char* name=0 )
	: TQSpinBox( parent, name ) {}
};

class DominoTQPixmap : public TQPixmap
{
	friend class DominoStyle;
	public:
		DominoTQPixmap( int w, int h,  int depth = -1) : TQPixmap(w, h, depth) {}
};

class DominoTQButton : public TQButton
{
	friend class DominoStyle;
	public:
		DominoTQButton(): TQButton() {}
};

#endif // __DOMINO_H
