#ifndef COLORDIALOG_H
#define COLORDIALOG_H

#include <tqdialog.h>
#include <tqrect.h>
#include <tqimage.h>

class TQPushButton;
class TQComboBox;
class TQGroupBox;
class TQPainter;
class ColorDialog;
class TQImage;
class TQPixmap;

enum Colors { Back = 0, Button, Base, Text, High, HighText, ButText, Alternate, NUMCOLORS };

class DemoWindow : public TQWidget
{
   Q_OBJECT
      
public:
   DemoWindow( ColorDialog* parent = 0, const char* name = 0);
   ~DemoWindow();

private slots:
   void smartRepaint();
   
protected:
   void mousePressEvent ( TQMouseEvent * e );
   void paintEvent ( TQPaintEvent * );
   
private:
   TQPainter *p;
   TQPainter *pp;
   TQPixmap *pm;
   ColorDialog* colorDialog_;
   TQRect baseRect;
   TQRect buttonRect;
   TQRect buttonTextRect;
   TQRect highlightRect;
   TQRect textRect;
   TQRect highTextRect;
   TQRect alternateRect;
   TQImage baseImage;
   TQImage dest;
   
private:
   TQImage & tintButton(TQImage &src, TQColor & c);
   
signals:
   void selected(Colors c);
   
};

class ColorPicker;

class ColorDialog : public TQDialog
{
   friend class DemoWindow;
   friend class AppSetter;
    Q_OBJECT

public:
   ColorDialog( TQWidget* parent = 0, const char* name = 0);
   ~ColorDialog();
   TQPushButton *buttonOk;
   TQPushButton *buttonCancel;
   void show();

protected:
   ColorPicker *picker[NUMCOLORS];
   void mouseReleaseEvent(TQMouseEvent* me);
   DemoWindow *demo;
   
private:
   TQPushButton *buttonCP;
   bool gettingColorFromScreen;
   TQComboBox *other;
   
private slots:
   void grabColor();
   void getFromOther( const TQString & string );

signals:
    void colorChanged(TQColor color);

};

#endif // COLORPICKER_H
