
#include "dirdialog.h"
#include "config.h"

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqdir.h>
#include <tqcheckbox.h>

#include <tdelocale.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <kpushbutton.h>
// #include <kurlrequester.h>
#include <tdelistbox.h>
#include <tdefiledialog.h>

DirDialog::DirDialog( Config* config, Mode mode, TQWidget *parent, const char *name, bool modal, WFlags f )
    : KDialog( parent, name, modal, f )
{
    // create an icon loader object for loading icons
    TDEIconLoader* iconLoader = new TDEIconLoader();

    setCaption( i18n("Add folder") );
    resize( 400, 235 );
    setIcon( iconLoader->loadIcon("folder_open",TDEIcon::Small) );

    TQGridLayout* grid = new TQGridLayout( this, 4, 1, 11, 6 );

    TQHBoxLayout* directoryBox = new TQHBoxLayout();
    grid->addLayout( directoryBox, 0, 0 );

    TQLabel* labelDirectory = new TQLabel( i18n("Directory:"), this, "labelDirectory" );
    directoryBox->addWidget( labelDirectory );

//     uDirectory = new KURLRequester( this, "uDirectory" );
//     uDirectory->setMode( KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly );
//     uDirectory->setURL( TQDir::homeDirPath() );
//     directoryBox->addWidget( uDirectory );

    lDirectory = new KLineEdit( this, "lDirectory" );
    directoryBox->addWidget( lDirectory );

    pDirectory = new KPushButton( iconLoader->loadIcon("folder_open",TDEIcon::Small), "", this, "pDirectory" );
    directoryBox->addWidget( pDirectory );
    connect( pDirectory, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(selectDirectoryClicked())
             );

    TQHBoxLayout* fileTypesBox = new TQHBoxLayout();
    grid->addLayout( fileTypesBox, 1, 0 );

    fileTypes = new TDEListBox( this, "fileTypes" );
    if( mode == Convert ) fileTypes->insertStringList( config->fileTypes() );
    else if( mode == ReplayGain ) fileTypes->insertStringList( config->replayGainFileTypes() );
    fileTypes->setSelectionMode( TQListBox::Multi );
    for( int i = 0; i < fileTypes->count(); i++ ) fileTypes->setSelected( i, true );
    fileTypesBox->addWidget( fileTypes );

    TQVBoxLayout* fileTypesButtonsBox = new TQVBoxLayout();
    fileTypesBox->addLayout( fileTypesButtonsBox );

    pSelectAll = new KPushButton( iconLoader->loadIcon("font-x-generic",TDEIcon::Small), i18n("Select all"), this, "pSelectAll" );
    fileTypesButtonsBox->addWidget( pSelectAll );
    connect( pSelectAll, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(selectAllClicked())
             );

    pSelectNone = new KPushButton( iconLoader->loadIcon("application-x-zerosize",TDEIcon::Small), i18n("Select none"), this, "pSelectNone" );
    fileTypesButtonsBox->addWidget( pSelectNone );
    connect( pSelectNone, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(selectNoneClicked())
             );

    cRecursive = new TQCheckBox( i18n("Recursive"), this, "cRecursive" );
    cRecursive->setChecked( true );
    recursive = true;
    fileTypesButtonsBox->addWidget( cRecursive );
    connect( cRecursive, TQT_SIGNAL(toggled(bool)),
             this, TQT_SLOT(recursiveToggled(bool))
           );

    fileTypesButtonsBox->addStretch();

    TQHBoxLayout* buttonBox = new TQHBoxLayout();
    grid->addLayout( buttonBox, 2, 0 );

    pOk = new KPushButton( iconLoader->loadIcon("folder_open",TDEIcon::Small), i18n("Open"), this, "pOk" );
    buttonBox->addWidget( pOk );
    connect( pOk, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(okClicked())
             );

    buttonBox->addStretch();

    pCancel = new KPushButton( iconLoader->loadIcon("cancel",TDEIcon::Small),i18n("Cancel"), this, "pCancel" );
    pOk->setFocus();
    buttonBox->addWidget( pCancel );
    connect( pCancel, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(reject())
             );

    // delete the icon loader object
    delete iconLoader;

    TQString directory = KFileDialog::getExistingDirectory( ":file_open", this, i18n("Choose a directory") );
    if( !directory.isEmpty() )
    {
        lDirectory->setText( directory );
    }
    else
    {
        lDirectory->setText( TQDir::homeDirPath() );
    }
}

DirDialog::~DirDialog()
{}

void DirDialog::okClicked()
{
    selectedFileTypes.clear();
    for( int i = 0; i < fileTypes->count(); i++ ) {
        if( fileTypes->isSelected(i) ) selectedFileTypes += TQStringList::split(", ",fileTypes->text(i));
    }
    directory = lDirectory->text();

    emit accept();
}

void DirDialog::selectDirectoryClicked()
{
    TQString directory = KFileDialog::getExistingDirectory( lDirectory->text(), this, i18n("Choose a directory") );
    if( !directory.isEmpty() )
    {
        lDirectory->setText( directory );
    }
}

void DirDialog::selectAllClicked()
{
    for( int i = 0; i < fileTypes->count(); i++ ) fileTypes->setSelected( i, true );
}

void DirDialog::selectNoneClicked()
{
    for( int i = 0; i < fileTypes->count(); i++ ) fileTypes->setSelected( i, false );
}

void DirDialog::recursiveToggled( bool checked )
{
    recursive = checked;
}

