/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_TABBEDCONFIGURATIONPAGE_H_
#define _RG_TABBEDCONFIGURATIONPAGE_H_

#include "ConfigurationPage.h"
#include <tqstring.h>


class TQWidget;
class TQTabWidget;
class TDEConfig;


namespace Rosegarden
{

class RosegardenGUIDoc;


/**
 * This class borrowed from KMail
 * (c) 2000 The KMail Development Team
 */
class TabbedConfigurationPage : public ConfigurationPage
{
    Q_OBJECT
  

public:
    TabbedConfigurationPage(RosegardenGUIDoc *doc,
                            TQWidget *parent=0, const char *name=0);

    TabbedConfigurationPage(TDEConfig *cfg,
                            TQWidget *parent=0, const char *name=0);

    TabbedConfigurationPage(RosegardenGUIDoc *doc,
                            TDEConfig *cfg,
                            TQWidget *parent=0, const char *name=0);

    static TQString iconName() { return "misc"; }
    
protected:
    void init();
    void addTab(TQWidget *tab, const TQString &title);

    //--------------- Data members ---------------------------------

    TQTabWidget *m_tabWidget;

};


}

#endif
