/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEINSERTFUNCTIONDIALOG_H
#define QALCULATEINSERTFUNCTIONDIALOG_H

#include <kdialogbase.h>
#include <tqvaluevector.h>

class MathFunction;

class QalculateInsertFunctionDialog : public KDialogBase {
	Q_OBJECT

public:

	QalculateInsertFunctionDialog(MathFunction *f, TQWidget *parent = 0, const TQString &selected_text = TQString::null, const char *name = 0);
	virtual ~QalculateInsertFunctionDialog();

	TQString functionExpression();

	MathFunction *mathFunction;

	TQValueVector<TQWidget*> label;
	TQValueVector<TQWidget*> entry;
	TQValueVector<TQWidget*> type_label;

protected slots:

	void slotOk();
	void slotApply();

	void selectDate(int);
	void selectFile(int);
	void insertMatrix(int);
	void insertVector(int);

};

#endif
