/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEEDITFUNCTIONDIALOG_H
#define QALCULATEEDITFUNCTIONDIALOG_H

#include <kdialogbase.h>
#include <tqmap.h>

class TQLabel;
class KComboBox;
class KLineEdit;
class TQCheckBox;
class TQPushButton;
class MathStructure;
class QalculateEditNamesDialog;
class QalculateEditSubFunctionsDialog;
class QalculateEditArgumentDialog;
class MathFunction;
class TDEListView;
class TQTextEdit;
class Argument;
class TQTabWidget;
class UserFunction;

/**
@author Niklas Knutsson
*/
class QalculateEditFunctionDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculateEditFunctionDialog(TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculateEditFunctionDialog();

	MathFunction *editFunction(TQString category = TQString::null, MathFunction *f = NULL);

	QalculateEditNamesDialog *names_edit_dialog;
	QalculateEditSubFunctionsDialog *subfunctions_edit_dialog;
	QalculateEditArgumentDialog *argument_edit_dialog;
	MathFunction *edited_function;
	KComboBox *categoryCombo;
	KLineEdit *conditionEdit, *nameEdit, *titleEdit;
	TQLabel *namesLabel;
	TQCheckBox *hideButton;
	TDEListView *argumentsView;
	TQTextEdit *descriptionEdit, *expressionEdit;
	TQPushButton *namesButton, *subFunctionsButton, *newArgumentButton, *editArgumentButton, *deleteArgumentButton;
	TQTabWidget *tabs;
	TQMap<TQListViewItem*, Argument*> argumentsItems;
	TQMap<TQListViewItem*, bool> argumentsItemsEdited;

public slots:

	void argumentSelectionChanged();
	void argumentRenamed(TQListViewItem*, const TQString&, int);
	void editNames();
	void newArgument();
	void editArgument();
	void deleteArgument();
	void editSubFunctions();
	void nameChanged(const TQString&);

protected slots:
	
	void slotHelp();
	void slotOk();

};

class QalculateEditSubFunctionsDialog : public KDialog {

	Q_OBJECT

public:

	QalculateEditSubFunctionsDialog(TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculateEditSubFunctionsDialog();

	void saveSubFunctions(UserFunction *f);
	void setSubFunctions(UserFunction *f = NULL, bool edited = false);
	bool isEmpty();

	TDEListView* subFunctionsView;
	TQPushButton* newButton;
	TQPushButton* deleteButton;
	TQPushButton* buttonClose;

public slots:

	void itemClicked(TQListViewItem*, const TQPoint&, int);
	void newSubFunction();
	void deleteSubFunction();
	void selectionChanged();

};

class QalculateEditArgumentDialog : public KDialogBase {

	Q_OBJECT

public:

	QalculateEditArgumentDialog(TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculateEditArgumentDialog();

	Argument *editArgument(Argument *arg = NULL);

	KComboBox *typeCombo;
	KLineEdit *nameEdit, *conditionEdit, *maxEdit, *minEdit;
	TQCheckBox *conditionButton, *matrixButton, *zeroButton, *complexButton, *maxButton, *minButton, *maxIncludeEqualsButton, *minIncludeEqualsButton, *testButton;

public slots:

	void maxEnabled(bool);
	void minEnabled(bool);
	void typeChanged(int);

};


#endif
