/***************************************************************************
 *   Copyright (C) 2005 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef EDITOR_H
#define EDITOR_H

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqvaluevector.h>
#include "common/common/qflags.h"
#include <kstdaction.h>
class TDEPopupMenu;

#include "common/global/purl.h"

class Editor : public TQWidget
{
Q_OBJECT
  
public:
  Editor(const TQString &title, const TQString &tag, TQWidget *parent, const char *name);
  Editor(TQWidget *parent, const char *name);
  virtual TQSizePolicy sizePolicy() const;
  virtual PURL::FileType fileType() const = 0;
  virtual bool isModified() const = 0;
  void setModified(bool modified);
  virtual PURL::Url url() const = 0;
  TQString name() const { return _title; }
  TQString tag() const { return _tag; }
  void setReadOnly(bool readOnly);
  virtual bool isReadOnly() const = 0;
  bool checkSaved();
  bool reload();
  virtual void setFocus() = 0;
  virtual bool open(const PURL::Url &url) = 0;
  virtual bool save(const PURL::Url &url) = 0;
  virtual void addGui() = 0;
  virtual void removeGui() = 0;
  virtual TQValueList<uint> bookmarkLines() const = 0;
  virtual void setBookmarkLines(const TQValueList<uint> &lines) = 0;

public slots:
  bool slotLoad();
  bool save();
  bool saveAs();
  void toggleReadOnly() { setReadOnly(!isReadOnly()); }
  virtual void statusChanged() = 0;

signals:
  void modified();
  void guiChanged();
  void statusTextChanged(const TQString &text);
  void dropEventPass(TQDropEvent *e);

protected:
  TQString filename() const;
  virtual void setModifiedInternal(bool modified) = 0;
  virtual void setReadOnlyInternal(bool readOnly) = 0;

private:
  TQString _title, _tag;
};

#endif
