/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef LIST_VIEW_H
#define LIST_VIEW_H

#include <tqtooltip.h>
#include <tqvaluevector.h>
#define private public
#define protected public
#include <tdelistview.h>
#undef private
#undef protected

//-----------------------------------------------------------------------------
class EditListViewItem;
class ListViewToolTip;

class ListView : public TDEListView
{
Q_OBJECT
  
public:
  ListView(TQWidget *parent = 0, const char *name = 0);
  virtual ~ListView();
  virtual void clear();
  void stopRenaming(bool force);
  virtual TQString tooltip(const TQListViewItem &item, int column) const;

public slots:
  void cancelRenaming() { stopRenaming(false); }
  void finishRenaming() { stopRenaming(true); }

protected:
  virtual bool eventFilter(TQObject *o, TQEvent *e);

private:
  ListViewToolTip *_tooltip;
  TQValueList<EditListViewItem *> _editItems;

  friend class EditListViewItem;
};

//-----------------------------------------------------------------------------
class ListViewToolTip : public TQToolTip
{
public:
  ListViewToolTip(ListView *parent)
    : TQToolTip(parent->viewport()), _listView(parent) {}

protected:
  virtual void maybeTip(const TQPoint &p);

private:
  ListView *_listView;
};

//-----------------------------------------------------------------------------
class EditListViewItem : public TDEListViewItem
{
public:
  EditListViewItem(ListView *list);
  EditListViewItem(TDEListViewItem *item);
  virtual ~EditListViewItem();
  void startRename();
  bool isRenaming() const { return _renaming; }

protected:
  virtual TQWidget *editWidgetFactory(int col) const = 0;
  virtual bool alwaysAcceptEdit(int col) const = 0;
  virtual int width(const TQFontMetrics &fm, const TQListView *lv, int c) const;
  virtual void editDone(int col, const TQWidget *editWidget);
  virtual void paintCell(TQPainter *p, const TQColorGroup &cg, int column, int width, int align);

private:
  bool _renaming;
  TQValueVector<TQWidget *> _editWidgets;

  virtual void activate() { startRename(); }
  virtual void startRename(int) { startRename(); }
  virtual void okRename(int) { renameDone(true); }
  virtual void cancelRename(int) { renameDone(false); }
  void renameDone(bool force);
  void removeEditBox();

  friend class ListView;
};

#endif
