#ifndef _HTTPFILETRANSFER_H_
#define _HTTPFILETRANSFER_H_
//==================================================================================
//
//   File : httpfiletransfer.h
//   Creation date : Tue Apr 22 2003 02:00:12 GMT by Szymon Stefanek
//
//   This config is part of the KVirc irc client distribution
//   Copyright (C) 2003 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//==================================================================================

#include "kvi_filetransfer.h"
#include "kvi_http.h"
#include "kvi_time.h"

#include "kvi_kvs_variant.h"

#include <tqstringlist.h>
#include <tqtimer.h>

class TQPainter;
class KviTalPopupMenu;

class KviHttpFileTransfer : public KviFileTransfer
{
	enum GeneralStatus { Initializing, Connecting, Downloading, Success, Failure };
	Q_OBJECT
  
public:
	KviHttpFileTransfer();
	~KviHttpFileTransfer();
private:
	KviHttpRequest * m_pHttpRequest;
	GeneralStatus    m_eGeneralStatus;
	TQString          m_szStatusString;

	TQStringList      m_lHeaders;
	TQStringList      m_lRequest;

	kvi_time_t       m_tStartTime;
	kvi_time_t       m_tTransferStartTime;
	kvi_time_t       m_tTransferEndTime;
	
	KviKvsVariant    m_vMagicIdentifier;
	bool             m_bNotifyCompletion;
	bool             m_bAutoClean;
	bool             m_bNoOutput;
	
	TQTimer         * m_pAutoCleanTimer;
	
	TQString          m_szCompletionCallback;
public:
	KviHttpRequest * request(){ return m_pHttpRequest; };
	static unsigned int runningTransfers();
	static void init();
	static void done();

	virtual bool startDownload();
	
	void setCompletionCallback(const TQString &szCallback){ m_szCompletionCallback = szCallback; };
	void setMagicIdentifier(const KviKvsVariant &vIdentifier){ m_vMagicIdentifier = vIdentifier; };
	void setNotifyCompletion(bool bNotify){ m_bNotifyCompletion = bNotify; };
	void setAutoClean(bool bAutoClean){ m_bAutoClean = bAutoClean; };
	void setNoOutput(bool bNoOutput){ m_bNoOutput = bNoOutput; };

	virtual void displayPaint(TQPainter * p,int column,int width,int height);
	virtual int displayHeight(int iLineSpacing);
	virtual void fillContextPopup(KviTalPopupMenu * m,int column);
	virtual bool active();
	virtual void die();
	virtual TQString tipText();
	virtual TQString localFileName();
protected slots:
	void statusMessage(const TQString &txt);
	void transferTerminated(bool bSuccess);
	void headersReceived(KviPointerHashTable<const char *,KviStr> *h);
	void requestSent(const TQStringList &sl);

	void resolvingHost(const TQString &hostname);
	void contactingHost(const TQString &ipandport);
	void receivedResponse(const TQString &response);
	void connectionEstabilished();

	void abort();
	
	void autoClean();
};


#endif //!_HTTPFILETRANSFER_H_
