/***************************************************************************
 *   Copyright (C) by                                                      *
 *     - 2005: Christian Leh <moodwrod@web.de>                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MAGICLABEL_H
#define MAGICLABEL_H

#include <tqstring.h>

#include <kprocess.h>

class MagicLabel : TQObject
{
  Q_OBJECT
  

  private:
    TQString prefix;
    TQString preUSER;
    TQString preCMD;

    TQString mValue;

    void transform();
    void getUserInfo();
    void getCommandOutput();

  private slots:
    void processExited(TDEProcess* proc);
    void receivedStdout(TDEProcess *proc, char *buffer, int buflen);

  public:
    MagicLabel(TQString s, bool translate);

    inline TQString& value() { return mValue; };
};

#endif
