/***************************************************************************
 * testobject.cpp
 * This file is part of the KDE project
 * copyright (C)2004-2005 by Sebastian Sauer (mail@dipe.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "testobject.h"

#include <iostream> // for std::out

TestObject::TestObject()
    : TQObject(0, "TestObject")
{
}

TestObject::TestObject(TQObject* parent, Kross::Api::ScriptContainer::Ptr scriptcontainer)
    : TQObject(parent, "TestObject")
{
    connect(this, TQT_SIGNAL(testSignal()), this, TQT_SLOT(testSignalSlot()));
    connect(this, TQT_SIGNAL(stdoutSignal(const TQString&)), this, TQT_SLOT(stdoutSlot(const TQString&)));
    connect(this, TQT_SIGNAL(stderrSignal(const TQString&)), this, TQT_SLOT(stderrSlot(const TQString&)));

    scriptcontainer->addTQObject(this);

//scriptcontainer->addSignal("stdout", this, TQT_SIGNAL(stdoutSignal(const TQString&)));
//scriptcontainer->addSlot("stderr", this, TQT_SLOT(stderrSlot(const TQString&)));

    //scriptcontainer->addSignal("myTestSignal", this, TQT_SIGNAL(testSignal()));
    //scriptcontainer->addSlot("myTestSlot", this, TQT_SLOT(testSlot()));
}

TestObject::~TestObject()
{
}

uint TestObject::func1(uint i)
{
    Kross::krossdebug(TQString("CALLED => TestObject::func1 i=%1").arg(i) );
    return i;
}

void TestObject::func2(TQString s, int i)
{
    Kross::krossdebug(TQString("CALLED => TestObject::func2 s=%1 i=%2").arg(s).arg(i));
}

TQString TestObject::func3(TQString s, int i)
{
    Kross::krossdebug(TQString("CALLED => TestObject::func3 s=%1 i=%2").arg(s).arg(i));
    return s;
}

const TQString& TestObject::func4(const TQString& s, int i) const
{
    Kross::krossdebug(TQString("CALLED => TestObject::func4 s=%1 i=%2").arg(s).arg(i));
    return s;
}

void TestObject::testSlot()
{
    Kross::krossdebug("TestObject::testSlot called");
    emit testSignal();
    emit testSignalString("This is the emitted TestObject::testSignalString(const TQString&)");
}

void TestObject::testSlot2()
{
    Kross::krossdebug("TestObject::testSlot2 called");
}

void TestObject::stdoutSlot(const TQString& s)
{
    Kross::krossdebug(TQString("stdout: %1").arg(s));
    //std::cout << "<stdout> " << s.latin1() << std::endl;
}

void TestObject::stderrSlot(const TQString& s)
{
    Kross::krossdebug(TQString("stderr: %1").arg(s));
    //std::cout << "<stderr> " << s.latin1() << std::endl;
}

//#include "testobject.moc"
