/* 
 * (c) Richard J. Moore 1997-2002
 * (c) Matthias Ettrich 2000
 * (c) Aaron J. Seigo 2002
 * (c) Nadeem Hasan 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef KSNAPSHOT_H
#define KSNAPSHOT_H

#include <tqlabel.h>
#include <tqpixmap.h>
#include <tqtimer.h>

#include <dcopclient.h>
#include <tdeglobalsettings.h>
#include <kdialogbase.h>
#include <kurl.h>

class RegionGrabber;
class KSnapshotWidget;

class KSnapshotThumb : public TQLabel
{
    Q_OBJECT
  

public:
    KSnapshotThumb(TQWidget *parent, const char *name = 0)
        : TQLabel(parent, name)
        {
            setAlignment(AlignHCenter | AlignVCenter);
        }
    virtual ~KSnapshotThumb() {}

signals:
    void startDrag();

protected:
    void mousePressEvent(TQMouseEvent * e)
        {
            mClickPt = e->pos();
        }

    void mouseMoveEvent(TQMouseEvent * e)
        {
            if (mClickPt != TQPoint(0, 0) &&
                (e->pos() - mClickPt).manhattanLength() > TDEGlobalSettings::dndEventDelay())
            {
                mClickPt = TQPoint(0, 0);
                emit startDrag();
            }
        }

    void mouseReleaseEvent(TQMouseEvent * /*e*/)
        {
            mClickPt = TQPoint(0, 0);
        }

    TQPoint mClickPt;
};

class KSnapshot : public KDialogBase
{
    typedef KDialogBase super;
    Q_OBJECT
  

public:
    KSnapshot(TQWidget *parent= 0, const char *name= 0);
    ~KSnapshot();

    enum CaptureMode { FullScreen=0, WindowUnderCursor=1, Region=2 };

    bool save( const TQString &filename );
    bool save( const KURL& url );

    TQString url() const { return filename.url(); }

signals:
    void screenGrabbed();

protected slots:
    void slotGrab();
    void slotCopy();
    void slotPrint();
    void slotMovePointer( int x, int y );

    void setTime(int newTime);
    void setURL(const TQString &newURL);
    void setGrabMode( int m );
    void exit();

    void slotOk();


protected:
    void reject() { close(); }
    bool eventFilter( TQObject*, TQEvent* );
    
private slots:
    void grabTimerDone();
    void slotDragSnapshot();
    void slotRegionGrabbed( const TQPixmap & );

private:
    void updatePreview();
    void performGrab();
    void autoincFilename();

    TQPixmap snapshot;
    TQTimer grabTimer;
    TQWidget* grabber;
    KURL filename;
    KSnapshotWidget *mainWidget;
    RegionGrabber *rgnGrab;
    bool modified;
    bool haveXShape;
};

#endif // KSNAPSHOT_H

