/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa        <hschaa@suse.de>, <helmut.schaa@gmx.de>
 * Author: Timothy Pearson <kb9vqf@pearsoncomputing.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// qt headers
#include <tqwidget.h>
#include <tqcombobox.h>
#include <tqtabwidget.h>
#include <tqpushbutton.h>
#include <tqwidgetstack.h>
#include <tqapplication.h>
#include <tqlabel.h>

// kde headers
#include <kiconloader.h>
#include <kdebug.h>
#include <kpushbutton.h>

// TQt DBus headers
#include <tqdbuserror.h>
#include <tqdbusobjectpath.h>

// NM headers
#include <NetworkManager.h>

// knm headers
#include "knetworkmanager-connection_setting_widget_interface.h"
#include "knetworkmanager-connection_setting.h"
#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_ipv4.h"
#include "knetworkmanager-connection_setting_wired.h"
#include "knetworkmanager-connection_setting_cdma.h"
#include "knetworkmanager-connection_setting_gsm.h"
#include "knetworkmanager-connection_setting_wireless.h"
#include "knetworkmanager-connection_setting_wireless_security.h"
#include "knetworkmanager-devicestore.h"
#include "knetworkmanager-connection.h"
#include "knetworkmanager-wired_connection.h"
#include "knetworkmanager-wireless_connection.h"
#include "knetworkmanager-vpn_connection.h"
#include "knetworkmanager-connection_store.h"
#include "knetworkmanager-connection_settings_dialog.h"
#include "knetworkmanager-connection_setting_cdma_widget.h"
#include "knetworkmanager-connection_setting_gsm_widget.h"
#include "knetworkmanager-connection_setting_ppp_widget.h"
#include "knetworkmanager-connection_setting_serial_widget.h"
#include "knetworkmanager-connection_setting_wireless_widget.h"
#include "knetworkmanager-connection_setting_wireless_security_widget.h"
#include "knetworkmanager-connection_setting_ipv4_widget.h"
#include "knetworkmanager-connection_setting_info_widget.h"
#include "knetworkmanager-connection_setting_vpn_widget.h"
#include "knetworkmanager-device.h"
#include "knetworkmanager-nm_proxy.h"
#include "knetworkmanager-storage.h"
#include "knetworkmanager-wireless_network.h"
#include "knetworkmanager-wireless_manager.h"

#if !defined(NM_CHECK_VERSION)
#define NM_CHECK_VERSION(x,y,z) 0
#endif

char use_new_wireless_essid = 0;
TQByteArray new_wireless_essid;

ConnectionSettingsDialogImpl::ConnectionSettingsDialogImpl(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting, TQWidget* parent, const char* name, bool modal, WFlags fl)
	: ConnectionSettingsDialog(parent, name, modal, fl)
	, _conn(conn)
	, _setting(setting)
	, _new_conn(new_conn)
{
	updateDialogForDeviceType();
	
	// get notified if device combo changes
	connect(btnConnect, TQT_SIGNAL(clicked()), this, TQT_SLOT( slotConnect()) );
	connect(pbNext, TQT_SIGNAL(clicked()), this, TQT_SLOT( slotNext()) );
	connect(pbBack, TQT_SIGNAL(clicked()), this, TQT_SLOT( slotBack()) );
	connect(pbCancel, TQT_SIGNAL(clicked()), this, TQT_SLOT( slotCancel()) );
	connect(pbSave, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotSave()) );

	// nice images for the buttons
	btnConnect->setIconSet(SmallIcon ("connect_creating", TQIconSet::Automatic));
	pbNext->setIconSet(SmallIcon ("1rightarrow", TQIconSet::Automatic));
	pbBack->setIconSet(SmallIcon ("1leftarrow", TQIconSet::Automatic));
	pbCancel->setIconSet(SmallIcon("cancel", TQIconSet::Automatic));
	pbSave->setIconSet(SmallIcon("ok", TQIconSet::Automatic));

	// enable or disable buttons accroding to the current state
	slotEnableButtons();
}

ConnectionSettingsDialogImpl::~ConnectionSettingsDialogImpl()
{
	kdDebug() << "ConnectionSettingsDialogImpl::~ConnectionSettingsDialogImpl" << endl;
}

TQValueList<WidgetInterface*>
ConnectionSettingsDialogImpl::createWidgetsForWireless(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting)
{
	TQValueList<WidgetInterface*> ret;

	// widgetlist for wireless connection
	ret.append(new ConnectionSettings::WirelessWidgetImpl(conn, new_conn));
	ret.append(new ConnectionSettings::WirelessSecurityWidgetImpl(conn, new_conn));
	ret.append(new ConnectionSettings::IPv4WidgetImpl(conn));
	ret.append(new ConnectionSettings::InfoWidgetImpl(conn));

	if (ret.isEmpty())
	{
		// we have a problem here, NetworkManager asked for a setting we do not have
		kdError() << k_funcinfo << "Unexpected setting requested" << endl;
	}

	return ret;
}

TQValueList<WidgetInterface*>
ConnectionSettingsDialogImpl::createWidgetsForWirelessKnownESSID(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting, const TQByteArray& essid)
{
	TQValueList<WidgetInterface*> ret;

	// Set ESSID
// 	_wireless_setting = dynamic_cast<Wireless*> (conn->getSetting(NM_SETTING_WIRELESS_SETTING_NAME));
// 	_info_setting = dynamic_cast<Info*> (conn->getSetting(NM_SETTING_CONNECTION_SETTING_NAME));
// 	_wireless_setting->setEssid(essid);
// 	if (!_hasName)
// 	{
// 		// the connection has no name yet -> just take the essid for it
// 		_info_setting->setName(essid);
// 	}

	// widgetlist for wireless connection
	ret.append(new ConnectionSettings::WirelessSecurityWidgetImpl(conn, new_conn));
	ret.append(new ConnectionSettings::IPv4WidgetImpl(conn));
	ret.append(new ConnectionSettings::InfoWidgetImpl(conn));

	if (ret.isEmpty())
	{
		// we have a problem here, NetworkManager asked for a setting we do not have
		kdError() << k_funcinfo << "Unexpected setting requested" << endl;
	}

	return ret;
}

TQValueList<WidgetInterface*>
ConnectionSettingsDialogImpl::createWidgetsForWired(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting)
{
	TQValueList<WidgetInterface*> ret;

	// widgetlist for wired connection
	ret.append(new ConnectionSettings::IPv4WidgetImpl(conn));
	ret.append(new ConnectionSettings::InfoWidgetImpl(conn));

	return ret;
}

TQValueList<WidgetInterface*>
ConnectionSettingsDialogImpl::createWidgetsForVPN(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting)
{
	TQValueList<WidgetInterface*> ret;

	// widgetlist for wired connection
	ret.append(new ConnectionSettings::VPNWidgetImpl(conn, new_conn));
	ret.append(new ConnectionSettings::InfoWidgetImpl(conn));

	return ret;
}

TQValueList<WidgetInterface*>
ConnectionSettingsDialogImpl::createWidgetsForCDMA(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting)
{
	TQValueList<WidgetInterface*> ret;

	// widgetlist for wired connection
	ret.append(new ConnectionSettings::CDMAWidgetImpl(conn));
	ret.append(new ConnectionSettings::SerialWidgetImpl(conn));
	ret.append(new ConnectionSettings::PPPWidgetImpl(conn));
	ret.append(new ConnectionSettings::IPv4WidgetImpl(conn));
	ret.append(new ConnectionSettings::InfoWidgetImpl(conn));

	return ret;
}

TQValueList<WidgetInterface*>
ConnectionSettingsDialogImpl::createWidgetsForGSM(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting)
{
	TQValueList<WidgetInterface*> ret;

	// widgetlist for wired connection
	ret.append(new ConnectionSettings::GSMWidgetImpl(conn));
	ret.append(new ConnectionSettings::PPPWidgetImpl(conn));
	ret.append(new ConnectionSettings::SerialWidgetImpl(conn));
	ret.append(new ConnectionSettings::IPv4WidgetImpl(conn));
	ret.append(new ConnectionSettings::InfoWidgetImpl(conn));

	return ret;
}

void
ConnectionSettingsDialogImpl::createWidgetsForConnection(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting)
{
	/*
	  Currently two modes:
	    * dev == NULL -> Connection should be edited without the wish to start a connection
	    * dev != NULL -> A connection should be edited for connection on this device
	*/

	if (!conn)
	{
		// TODO: create an empty widget and show an error
		kdWarning() << k_funcinfo << "Not handled yet" << endl;
	}
	else
	{
		TQValueList<WidgetInterface*> widgets;
		// TODO: move to a factory class
		if (conn->getType() == NM_SETTING_WIRELESS_SETTING_NAME) {
			if (use_new_wireless_essid == 0) {
				widgets = createWidgetsForWireless(conn, new_conn, setting);
			}
			else {
				createWidgetsForWirelessKnownESSID(conn, new_conn, setting, new_wireless_essid);
				new_wireless_essid = NULL;
			}
		}
		else if (conn->getType() == NM_SETTING_WIRED_SETTING_NAME)
			widgets = createWidgetsForWired(conn, new_conn, setting);
		else if (conn->getType() == NM_SETTING_CDMA_SETTING_NAME)
			widgets = createWidgetsForCDMA(conn, new_conn, setting);
		else if (conn->getType() == NM_SETTING_GSM_SETTING_NAME)
			widgets = createWidgetsForGSM(conn, new_conn, setting);
		else if (conn->getType() == NM_SETTING_VPN_SETTING_NAME)
			widgets = createWidgetsForVPN(conn, new_conn, setting);
		else
		{
			kdWarning() << k_funcinfo << "Not handled yet" << endl;
		}

		int id;
		for (TQValueList<WidgetInterface*>::Iterator it = widgets.begin(); it != widgets.end(); ++it)
		{
			id = wstackSettings->addWidget(*it);
			_widgetIds.append(id);
		}

		if (widgets.begin() != widgets.end())
			activateWidget(*widgets.begin());
	}
}

void
ConnectionSettingsDialogImpl::updateDialogForDeviceType()
{
	// clear our tabview first
	TQWidget *page = NULL;
	while ( (page = wstackSettings->visibleWidget()) != NULL)
	{
		wstackSettings->removeWidget(page);
		delete page;
	}

	if (_conn)
	{
		connect(_conn, TQT_SIGNAL(validityChanged()), this, TQT_SLOT(slotEnableButtons()));
		createWidgetsForConnection(_conn, _new_conn, _setting);
	}
	else
	{
		// this should never happen
		TQLabel* lbl = new TQLabel(wstackSettings, "Unknown Device Type");
		wstackSettings->addWidget(lbl);

		wstackSettings->raiseWidget(lbl);
	}
}

int
ConnectionSettingsDialogImpl::getDeviceTypeFromConnection(Connection* conn)
{
	if (conn->getType() == NM_SETTING_WIRELESS_SETTING_NAME)
#if NM_CHECK_VERSION(0,8,992)
		return NM_DEVICE_TYPE_WIFI;
#else
		return DEVICE_TYPE_802_11_WIRELESS;
#endif
	else if (conn->getType() == NM_SETTING_WIRED_SETTING_NAME)
#if NM_CHECK_VERSION(0,8,992)
		return NM_DEVICE_TYPE_ETHERNET;
#else
		return DEVICE_TYPE_802_3_ETHERNET;
#endif
	else if (conn->getType() == NM_SETTING_GSM_SETTING_NAME)
#if NM_CHECK_VERSION(0,8,992)
		return NM_DEVICE_TYPE_MODEM;
#else
		return DEVICE_TYPE_GSM;
#endif
	else if (conn->getType() == NM_SETTING_CDMA_SETTING_NAME)
#if NM_CHECK_VERSION(0,8,992)
		return NM_DEVICE_TYPE_MODEM;
#else
		return DEVICE_TYPE_CDMA;
#endif

#if NM_CHECK_VERSION(0,8,992)
	return NM_DEVICE_TYPE_UNKNOWN;
#else
	return DEVICE_TYPE_UNKNOWN;
#endif
}

void
ConnectionSettingsDialogImpl::slotConnect()
{
	DeviceStore*     dstore   = DeviceStore::getInstance();
	Device*          dev      = dstore->getDevices(getDeviceTypeFromConnection(_conn)).first();
	ConnectionStore* cstore   = ConnectionStore::getInstance();
	NMProxy*         nm       = NMProxy::getInstance();
	TQT_DBusError       err;

	// add the connection to the store
	cstore->addConnection(_conn);

	// activate device
	if (dev && _conn && nm)
	{
		int id;
		if (_conn->awaitingSecrets())
		{
			_conn->Connection::slotSecretsProvided(NULL);
		}
		else
		{

			// VPN connection needs a special specific object
			if (_conn->getType() == NM_SETTING_VPN_SETTING_NAME)
			{
				TQT_DBusObjectPath act_conn = nm->getDefaultActiveConnection();
				TQT_DBusObjectPath device   = nm->getDeviceForActiveConnection(act_conn);
#if NM_CHECK_VERSION(0,8,992)
				nm->ActivateConnectionAsync(id, "org.freedesktop.NetworkManagerUserSettings", _conn->getObjectPath(), device, act_conn, err);
#else
				nm->ActivateConnectionAsync(id,NM_DBUS_SERVICE_USER_SETTINGS, _conn->getObjectPath(), device, act_conn, err);
#endif
			}
			else
			{
				// we need to call ActivateDevice async
#if NM_CHECK_VERSION(0,8,992)
				nm->ActivateConnectionAsync(id, "org.freedesktop.NetworkManagerUserSettings", _conn->getObjectPath(), TQT_DBusObjectPath(QCString(dev->getObjectPath())), _conn->getObjectPath(), err);
#else
				nm->ActivateConnectionAsync(id, NM_DBUS_SERVICE_USER_SETTINGS, _conn->getObjectPath(), TQT_DBusObjectPath(TQCString(dev->getObjectPath())), _conn->getObjectPath(), err);
#endif
			}
		}
	}

	emit connectionSaved();
	this->close(true);
}

void
ConnectionSettingsDialogImpl::slotSave()
{
	// Make sure settings are committed
	TQValueList<int>::Iterator current = _widgetIds.find(wstackSettings->id(wstackSettings->visibleWidget()));
	if (current != _widgetIds.fromLast())
	{
		WidgetInterface* widget = NULL;

		// let the widget know about it being the active one
		widget = dynamic_cast<WidgetInterface*>(wstackSettings->widget(*current));
		if (widget)
			deactivateWidget(widget);
	}

	// Now save
	ConnectionStore* cstore   = ConnectionStore::getInstance();
	NMProxy*         nm       = NMProxy::getInstance();
	TQT_DBusError       err;

	// add the connection to the store
	cstore->addConnection(_conn);

	// if the connection waits for new secrets
	// signal an error to NM, the user only wants to save
	// the connection
	if (_conn->awaitingSecrets())
		_conn->slotSecretsError();

	emit connectionSaved();
	this->close(true);
}

void
ConnectionSettingsDialogImpl::slotCancel()
{
	_conn->slotSecretsError();
	close();
}

void
ConnectionSettingsDialogImpl::slotNext()
{
	TQValueList<int>::Iterator current = _widgetIds.find(wstackSettings->id(wstackSettings->visibleWidget()));
	if (current != _widgetIds.fromLast())
	{
		WidgetInterface* widget = NULL;

		// let the widget know about it being the active one
		widget = dynamic_cast<WidgetInterface*>(wstackSettings->widget(*current));
		if (widget)
			deactivateWidget(widget);

		// next widget
		current++;
	
		// let the widget know about it being the active one
		widget = dynamic_cast<WidgetInterface*>(wstackSettings->widget(*current));
		if (widget)
			activateWidget(widget);
	}
	slotEnableButtons();
}

void
ConnectionSettingsDialogImpl::slotBack()
{
	TQValueList<int>::Iterator current = _widgetIds.find(wstackSettings->id(wstackSettings->visibleWidget()));
	if (current != _widgetIds.begin())
	{
		WidgetInterface* widget = NULL;

		// let the widget know about it being the active one
		widget = dynamic_cast<WidgetInterface*>(wstackSettings->widget(*current));
		if (widget)
			deactivateWidget(widget);

		// one back
		current--;

		// let the widget know about it being the active one
		widget = dynamic_cast<WidgetInterface*>(wstackSettings->widget(*current));
		if (widget)
			activateWidget(widget);
	}
	slotEnableButtons();
}

void
ConnectionSettingsDialogImpl::activateWidget(WidgetInterface* widget)
{
	// allow the widget to press next
	connect(widget, TQT_SIGNAL(next()), this, TQT_SLOT(slotNext()));

	// allow the widget to do some initialization
	widget->Activate();

	// show the widget
	wstackSettings->raiseWidget(widget);

}

void
ConnectionSettingsDialogImpl::deactivateWidget(WidgetInterface* widget)
{
	// allow the widget to press next
	disconnect(widget, TQT_SIGNAL(next()), this, TQT_SLOT(slotNext()));

	// allow the widget to do some initialization
	widget->Deactivate();
}

void
ConnectionSettingsDialogImpl::slotEnableButtons()
{
	// enable the buttons according to the current state
	
	TQValueList<int>::Iterator current = _widgetIds.find(wstackSettings->id(wstackSettings->visibleWidget()));
	bool enabled;

	/*
	  Next: enabled if another widget is available
	*/
	enabled = true;
	if (current == _widgetIds.fromLast())
		enabled = false;
	pbNext->setEnabled(enabled);

	/*
		Back: enabled if the current widget has a predecessor
	*/
	enabled = true;
	if (current == _widgetIds.begin())
		enabled = false;
	pbBack->setEnabled(enabled);

	/*
		Connect: only show connect if the connection is valid
	*/
	if (_conn)
	{
		btnConnect->setEnabled(_conn->isValid());
		pbSave->setEnabled(_conn->isValid());

	}
}

#include "knetworkmanager-connection_settings_dialog.moc"
