/***************************************************************************
 *
 * knetworkmanager-connection_setting_ppp_widget.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2008 Novell, Inc.
 *
 * Author: Will Stephenson <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <nm-setting-ppp.h>

// qt headers
#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqcombobox.h>
#include <tqspinbox.h>
#include <tqiconset.h>
#include <kiconloader.h>
#include <tqwidgetstack.h>
#include <kuser.h>

// knm headers
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_setting_ppp.h"
#include "knetworkmanager-connection_setting_ppp_widget.h"
#include "knetworkmanager-device.h"

#include "connection_setting_ppp.h"

using namespace ConnectionSettings;

PPPWidgetImpl::PPPWidgetImpl(Connection* conn, TQWidget* parent, const char* name, WFlags fl)
	: WidgetInterface(parent, name, fl)
{
	_pppsetting = dynamic_cast<ConnectionSettings::PPP*> (conn->getSetting(NM_SETTING_PPP_SETTING_NAME));

	TQVBoxLayout* layout = new TQVBoxLayout(this, 1, 1);
	_mainWid = new ConnectionSettingPppWidget(this);
	layout->addWidget(_mainWid);

	Init();
}

void
PPPWidgetImpl::Init()
{
    _mainWid->mNoAuth->setChecked( _pppsetting->getNoAuth() );
    _mainWid->mRefuseEap->setChecked( _pppsetting->getRefuseEAP( ) );
    _mainWid->mRefusePap->setChecked( _pppsetting->getRefusePAP( ) );
    _mainWid->mRefuseChap->setChecked( _pppsetting->getRefuseChap() );
    _mainWid->mRefuseMschap->setChecked( _pppsetting->getRefuseMSChap() );
    _mainWid->mRefuseMschapV2->setChecked( _pppsetting->getRefuseMSChapV2() );
    _mainWid->mNoBsd->setChecked( _pppsetting->getNoBSDComp() );
    _mainWid->mNoDeflate->setChecked( _pppsetting->getNoDeflate() );
    _mainWid->mNoVjComp->setChecked( _pppsetting->getNoVJComp() );
    _mainWid->mRequireMppe->setChecked( _pppsetting->getRequireMPPE( ));
    _mainWid->mRequireMppe128->setChecked( _pppsetting->getRequireMPPE128( ));
    _mainWid->mStatefulMppe->setChecked( _pppsetting->getMPPEStateful() );
    _mainWid->mRequireMppc->setChecked( _pppsetting->getRequireMPPC() );
    _mainWid->mCrtscts->setChecked( _pppsetting->getCRTSCTS() );

    _mainWid->mBaudRate->setValue(_pppsetting->getBaud());
    _mainWid->mMru->setValue(_pppsetting->getMRU());
    _mainWid->mMtu->setValue(_pppsetting->getMTU());
    _mainWid->mLcpEchoFailure->setValue(_pppsetting->getLCPEchoFailure());
    _mainWid->mLcpEchoInterval->setValue(_pppsetting->getLCPEchoInterval());
    connect( _mainWid->mNoAuth, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
    connect( _mainWid->mRefuseEap, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
    connect( _mainWid->mRefusePap, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
    connect( _mainWid->mRefuseChap, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
    connect( _mainWid->mRefuseMschap, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
    connect( _mainWid->mRefuseMschapV2, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
    connect( _mainWid->mNoBsd, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
    connect( _mainWid->mNoDeflate, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
    connect( _mainWid->mRequireMppe, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
    connect( _mainWid->mRequireMppe128, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
    connect( _mainWid->mStatefulMppe, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
    connect( _mainWid->mRequireMppc, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
    connect( _mainWid->mCrtscts, TQT_SIGNAL(toggled(bool)), TQT_SLOT(dirty()));
}

void
PPPWidgetImpl::Deactivate()
{
}

void
PPPWidgetImpl::Activate()
{

}

void
PPPWidgetImpl::dirty()
{
    _pppsetting->setNoAuth( _mainWid->mNoAuth->isChecked() );
    _pppsetting->setRefuseEAP( _mainWid->mRefuseEap->isChecked() );
    _pppsetting->setRefuseChap( _mainWid->mRefuseChap->isChecked() );
    _pppsetting->setRefuseMSChap( _mainWid->mRefuseMschap->isChecked() );
    _pppsetting->setNoBSDComp( _mainWid->mNoBsd->isChecked() );
    _pppsetting->setNoDeflate( _mainWid->mNoDeflate->isChecked() );
    _pppsetting->setRequireMPPE( _mainWid->mRequireMppe->isChecked() );
    _pppsetting->setRequireMPPE( _mainWid->mRequireMppe128->isChecked() );
    _pppsetting->setMPPEStateful( _mainWid->mStatefulMppe->isChecked() );

    _pppsetting->setBaud(_mainWid->mBaudRate->value());
    _pppsetting->setMRU(_mainWid->mMru->value());
    _pppsetting->setMTU(_mainWid->mMtu->value());
    _pppsetting->setLCPEchoFailure(_mainWid->mLcpEchoFailure->value());
    _pppsetting->setLCPEchoInterval(_mainWid->mLcpEchoInterval->value());
}

#include "knetworkmanager-connection_setting_ppp_widget.moc"
