/***************************************************************************
  begin                : Fri Nov 1 2002
  copyright            : (C) 2002 by Christian Hubinger
  email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFRULEEDITORPROTOCOL_H
#define KMFRULEEDITORPROTOCOL_H
#include "kmyfirewallruleeditorprotocol.h"

#include <tqwidget.h>
#include <tqptrlist.h>

/**
  *@author Christian Hubinger
  */
class TQString;

namespace KMF {
class KMFMultiPortWidget;
class KMFPortWidget;
class IPTRule;


class KMFRuleEditorProtocol : public KMyFirewallRuleEditorProtocol {
	Q_OBJECT
  
public:
	KMFRuleEditorProtocol( TQWidget *parent = 0, const char *name = 0, WFlags fl = 0 );
	~KMFRuleEditorProtocol();

	void loadRule( IPTRule* rule );
private slots:
	void toggleMultiPort( bool );
	void toggleUdpRule( bool );
	void toggleIcmpRule( bool );
	void toggleTcpRule( bool );
	void slotHelp();
	void reject();
private:
	KMFMultiPortWidget *mpwid;
	KMFPortWidget *pw_dest_port, *pw_src_port;
	IPTRule *m_rule;
	bool multiportEnabled() const ;
	void accept();
	int getItemNum( const TQString& );

signals:
/*	void sigAddRuleOpt( TQString *, TQPtrList<TQString> * );
	void sigAddTargetOpt( TQString *, TQPtrList<TQString> * );*/
	void sigHideMe();

private:   // data
	bool use_multiport;


};
}
#endif
