/***************************************************************************
                          kbconfigdlg.h  -  description
                             -------------------
    begin                : Sun Jul 8 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBCONFIGDLG_H
#define KBCONFIGDLG_H

#include <kdialogbase.h>
#include "kbconfig.h"

class TQWidget;
class TQCheckBox;
class TQPushButton;
class TQComboBox;
class TQStringList;
class KKeyChooser;


/**Configuration dialog for KKBSwitch
  *@author Leonid Zeitlin
  */

class KBConfigDlg : public KDialogBase  {
   Q_OBJECT
public: 
	KBConfigDlg(KBConfig *kbconf, TQWidget *parent=0, const char *name=0);
	~KBConfigDlg();
private: // Private attributes
  /**  */
  TDEListBox *lbGroups;
  /**  */
  TQCheckBox *chkToggleMode;
  //TQCheckBox *chkPerwindowGroup;
  TQCheckBox *chkAutostart;
  TQPushButton *btnChangeIcon;
  TQPushButton *btnSetDefaultIcon;
  TQPushButton *btnSetDefaultGroup;
  TQComboBox *cbxIconType;
  TQComboBox *cbxGroupScope;
  KKeyChooser *keyChooser;
  TQCheckBox *chkUseShortcuts;
  TQStringList m_iconpaths;
  int m_default_groupno;
  KBConfig *m_kbconf;
  /** Display the current KBSwitch configuration in the dialog */
  void showConfig();
  void saveConfig();
  void redrawIcons(KBConfig::IconStyle icon_style);
  void setupGeneralPage();
  void setupShortcutsPage();
  void checkIconDefault(int index);
private slots: // Private slots
  /** Fire up "Pick Icon" dialog */
  void slotPickIcon();
  void slotSetDefaultGroup();
  /** No descriptions */
  void slotLayoutSelected();
  /** No descriptions */
  void slotListBoxExecuted(TQListBoxItem *item);
  void slotIconTypeSelected(int index);
  void slotUseShortcutsToggled(bool on);
  void slotSetDefaultIcon();
protected: // Protected methods
  /** No descriptions */
  virtual void slotApply();
  /** No descriptions */
  virtual void slotOk();
  virtual void slotCancel();
};

#endif
