/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef BATTERYSRC_H
#define BATTERYSRC_H
#include "labelsource.h"
#include "threadedtrigger.h"
#include <tqfile.h>
#include <tqstring.h>
#include <list>

#include <tdehardwaredevices.h>

/**
 * BatterySrc fetches the state of charge of the battery from HAL
 * @author Ken Werner
 */
class BatterySrc : public LabelSource {
	Q_OBJECT
	 //macro which activates signals and slots (moc)
public:
	/**
	 * Creates a new Source
	 */
	BatterySrc(TQWidget* inParent, TQString inUDI);
	virtual ~BatterySrc();

	/**
	 * Creates instances of that Source (and returns pointers to them)
	 */
	static std::list<Source*> createInstances(TQWidget* inParent);

	/**
	 * Fetches and returns the value of this source
	 * This method is called from a thread so don't call it directly
	 */
	virtual TQString fetchValue();

private:
	/**
	 * triggers the fetchValue method
	 */
	ThreadedTrigger mTrigger;

	/**
	 * The hal udi of that battery source
	 */
	TQString mUDI;

	/**
	 * The internal hardware library object
	 */
	TDEHardwareDevices* mHardwareDevices;
};
#endif //BATTERYSRC_H
