/***************************************************************************
    begin                : Fri Aug 1 2003
    edit		 : Fri April 6 2007
    copyright            : (C) 2002 - 2003 by Pascal Brachet, 2003 Jeroen Wijnhout, 2006 - 2007 Thomas Braun
    email                : Jeroen.Wijnhout@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SYMBOLVIEW_H
#define SYMBOLVIEW_H

#include <tqiconview.h>

#include <kiconview.h>
#include <tqscrollview.h>
#include <tqstring.h>
#include <tqlabel.h>

static const TQString MFUSGroup = "MostFrequentlyUsedSymbols";
static const TQString MFUSprefix = "MFUS";

class SymbolView : public TDEIconView
{	
	Q_OBJECT
  
	
public:
	SymbolView(TQWidget *parent=0,int type = -1, const char *name=0);
	~SymbolView();
	enum { MFUS = 0, Relation, Operator, Arrow, MiscMath, MiscText, Delimiters, Greek, Special, Cyrillic, User };
	void writeConfig();
	
private:
	void fillWidget(const TQString &prefix);
	void hideEvent( TQHideEvent * );
	void contentsMousePressEvent(TQMouseEvent *e);
	void extract(const TQString& key, int& count, TQString &cmd, TQStringList &args, TQStringList &pkgs);
	void extract(const TQString& key, int& count);
	void initPage(int page);

signals:
	void insertText(const TQString& text,const TQStringList &pkgs);
	void addToList(const TQIconViewItem *item);

private slots:
	void showToolTip( TQIconViewItem *item );
	void slotAddToList(const TQIconViewItem *item);
	void removeToolTip();

private:
	TQLabel *m_toolTip;
};

#endif
