/****************************************************************************************
    begin                : sam jui 13 09:50:06 CEST 2002
    copyright            : (C) 2003 by Jeroen Wijnhout (Jeroen.Wijnhout@kdemail.net)
                           (C) 2007 by Michel Ludwig (michel.ludwig@kdemail.net)
                           (C) 2007 Holger Danielsson (holger.danielsson@versanet.de)
 ****************************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// 2007-03-12 dani
//  - use KileDocument::Extensions

#include "kile.h"

#include <tqtooltip.h>
#include <tqguardedptr.h>

#include <tdeaction.h>
#include <khelpmenu.h>
#include <tdemenubar.h>
#include <kstatusbar.h>
#include "kiledebug.h"
#include <kiconloader.h>
#include <tdemessagebox.h>
#include <tdeconfig.h>
#include <tdelocale.h>
#include <krun.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kstandarddirs.h>
#include <tdemultitabbar.h>
#include <ktabwidget.h>
#include <ktip.h>
#include <tdetexteditor/configinterface.h>
#include <dcopclient.h>

#include "kileapplication.h"
#include "kiledocumentinfo.h"
#include "kileactions.h"
#include "kilestdactions.h"
#include "usermenudialog.h"
#include "kileconfigdialog.h"
#include "kileproject.h"
#include "kileprojectview.h"
#include "kileprojectdlgs.h"
#include "kilelistselector.h"
#include "kilelyxserver.h"
#include "kilegrepdialog.h"
#include "kiletool_enums.h"
#include "kiletool.h"
#include "kiletoolmanager.h"
#include "kilestdtools.h"
#include "kilelogwidget.h"
#include "kileoutputwidget.h"
#include "kilekonsolewidget.h"
#include "quickdocumentdialog.h"
#include "tabbingdialog.h"
#include "kilestructurewidget.h"
#include "convert.h"
#include "includegraphicsdialog.h"
#include "kiledocmanager.h"
#include "kileviewmanager.h"
#include "kileeventfilter.h"
#include "kileconfig.h"
#include "kileerrorhandler.h"
#include "configcheckerdlg.h"
#include "kilesidebar.h"
#include "symbolview.h"
#include "floatdialog.h"
#include "mathenvdialog.h"
#include "tabulardialog.h"
#include "postscriptdialog.h"
#include "latexcmd.h"
#include "kileuntitled.h"
#include "kilestatsdlg.h"
#include "scriptsmanagementwidget.h"
#include "kilejscript.h"
#include "previewwidget.h"

Kile::Kile( bool allowRestore, TQWidget *parent, const char *name ) :
	DCOPObject( "Kile" ),
	KParts::MainWindow( parent, name),
	KileInfo(this),
	m_paPrint(0L)
{
    m_focusWidget = this;

	m_config = TDEGlobal::config();
	readUserSettings();
	readRecentFileSettings();

	m_jScriptManager = new KileJScript::Manager(this, m_config, actionCollection(), TQT_TQOBJECT(parent), "KileJScript::Manager");

    setStandardToolBarMenuEnabled(true);

	m_masterName = KileConfig::master();
	m_singlemode = (m_masterName.isEmpty());

	m_AutosaveTimer = new TQTimer();
	connect(m_AutosaveTimer,TQT_SIGNAL(timeout()),this,TQT_SLOT(autoSaveAll()));

	m_latexCommands = new KileDocument::LatexCommands(m_config,this);  // at first (dani)
	m_edit = new KileDocument::EditorExtension(this);
	m_help = new KileHelp::Help(m_edit);
	m_partManager = new KParts::PartManager( this );
	m_eventFilter = new KileEventFilter(m_edit);
	m_errorHandler = new KileErrorHandler(TQT_TQOBJECT(this), this);
	m_quickPreview = new KileTool::QuickPreview(this);
	m_extensions = new KileDocument::Extensions();

	connect( m_partManager, TQT_SIGNAL( activePartChanged( KParts::Part * ) ), TQT_TQOBJECT(this), TQT_SLOT(activePartGUI ( KParts::Part * ) ) );
	connect(this,TQT_SIGNAL(configChanged()), m_eventFilter, TQT_SLOT(readConfig()));

	readGUISettings();

 TDEGlobal::dirs()->addResourceType( "app_symbols",TDEStandardDirs::kde_default("data") + "kile/mathsymbols/"); // needed for Symbolview


	setXMLFile( "kileui.rc" );

	// do initializations first
	m_currentState = m_wantState = "Editor";
	m_bWatchFile = m_logPresent = false;

	viewManager()->setClient(TQT_TQOBJECT(this), this);

	setupStatusBar();

	m_topWidgetStack = new TQWidgetStack( this );
	m_topWidgetStack->setFocusPolicy(TQ_NoFocus);

	m_horizontalSplitter = new TQSplitter(Qt::Horizontal,m_topWidgetStack, "horizontalSplitter" );

	setupSideBar();

	m_verticalSplitter=new TQSplitter(Qt::Vertical, m_horizontalSplitter, "verticalSplitter");
	viewManager()->createTabs(m_verticalSplitter);

	connect(viewManager(), TQT_SIGNAL(activateView(TQWidget*, bool)), TQT_TQOBJECT(this), TQT_SLOT(activateView(TQWidget*, bool)));
	connect(viewManager(), TQT_SIGNAL(prepareForPart(const TQString& )), TQT_TQOBJECT(this), TQT_SLOT(prepareForPart(const TQString& )));
	connect(viewManager(), TQT_SIGNAL(startQuickPreview(int)), TQT_TQOBJECT(this), TQT_SLOT(slotQuickPreview(int)) );

	setupBottomBar();
	setupGraphicTools();
	setupPreviewTools();
	setupActions();
	setupTools();

	TQValueList<int> sizes;
	sizes << m_verSplitTop << m_verSplitBottom;
	m_verticalSplitter->setSizes( sizes );
	sizes.clear();
	sizes << m_horSplitLeft << m_horSplitRight;
	m_horizontalSplitter->setSizes( sizes );
	if ( ! KileConfig::bottomBar() )
	{
		m_actionMessageView->activate();
		m_bottomBar->setSize(KileConfig::bottomBarSize());
	}

	m_topWidgetStack->addWidget(m_horizontalSplitter , 0);
	setCentralWidget(m_topWidgetStack);
	newCaption();

	m_partManager->setActivePart( 0L );

	m_lyxserver = new KileLyxServer(KileConfig::runLyxServer());
	connect(m_lyxserver, TQT_SIGNAL(insert(const KileAction::TagData &)), TQT_TQOBJECT(this), TQT_SLOT(insertTag(const KileAction::TagData &)));

	applyMainWindowSettings(m_config, "KileMainWindow" );

	m_manager  = new KileTool::Manager(this, m_config, m_logWidget, m_outputWidget, m_partManager, m_topWidgetStack, m_paStop, 10000); //FIXME make timeout configurable
	connect(m_manager, TQT_SIGNAL(requestGUIState(const TQString &)), TQT_TQOBJECT(this), TQT_SLOT(prepareForPart(const TQString &)));
	connect(m_manager, TQT_SIGNAL(requestSaveAll(bool, bool)), docManager(), TQT_SLOT(fileSaveAll(bool, bool)));
	connect(m_manager, TQT_SIGNAL(jumpToFirstError()), m_errorHandler, TQT_SLOT(jumpToFirstError()));
	connect(m_manager, TQT_SIGNAL(toolStarted()), m_errorHandler, TQT_SLOT(reset()));
	connect(m_manager, TQT_SIGNAL(previewDone()), TQT_TQOBJECT(this), TQT_SLOT(focusPreview()));

	m_toolFactory = new KileTool::Factory(m_manager, m_config);
	m_manager->setFactory(m_toolFactory);
	m_help->setUserhelp(m_manager,menuBar());     // kile user help (dani)

	connect(docManager(), TQT_SIGNAL(updateModeStatus()), TQT_TQOBJECT(this), TQT_SLOT(updateModeStatus()));
	connect(docManager(), TQT_SIGNAL(updateStructure(bool, KileDocument::Info*)), viewManager(), TQT_SLOT(updateStructure(bool, KileDocument::Info*)));
	connect(docManager(), TQT_SIGNAL(closingDocument(KileDocument::Info* )), m_kwStructure, TQT_SLOT(closeDocumentInfo(KileDocument::Info *)));
	connect(docManager(), TQT_SIGNAL(documentInfoCreated(KileDocument::Info* )), m_kwStructure, TQT_SLOT(addDocumentInfo(KileDocument::Info* )));
	connect(docManager(), TQT_SIGNAL(updateReferences(KileDocument::Info *)), m_kwStructure, TQT_SLOT(updateReferences(KileDocument::Info *)));

	readConfig();

	KileApplication::closeSplash();

	resize(KileConfig::mainwindowWidth(), KileConfig::mainwindowHeight());
	show();

	if ( m_listUserTools.count() > 0 )
	{
		KMessageBox::information(0, i18n("You have defined some tools in the User menu. From now on these tools will be available from the Build->Other menu and can be configured in the configuration dialog (go to the Settings menu and choose Configure Kile). This has some advantages; your own tools can now be used in a QuickBuild command if you wish."), i18n("User Tools Detected"));
		m_listUserTools.clear();
	}

	KTipDialog::showTip(this, "kile/tips");

	restoreFilesAndProjects(allowRestore);
	initMenu();
	updateModeStatus();

actionCollection()->readShortcutSettings("Shortcuts", m_config);
}

Kile::~Kile()
{
	KILE_DEBUG() << "cleaning up..." << endl;
	delete m_extensions;
	delete m_latexCommands;
	delete m_quickPreview;
	delete m_edit;
	delete m_help;
	delete m_AutosaveTimer;
	delete m_lyxserver; //TQObject without parent, have to delete it ourselves
	delete m_outputInfo;
	delete m_outputFilter;
	delete m_eventFilter;
}

void Kile::showEvent(TQShowEvent *)
{
	m_focusWidget->setFocus();
}

void Kile::hideEvent(TQHideEvent *)
{
	m_focusWidget = focusWidget();
}

void Kile::setupStatusBar()
{
    statusBar()->removeItem(ID_LINE_COLUMN);
    statusBar()->removeItem(ID_HINTTEXT);

	statusBar()->insertItem(i18n("Line: 1 Col: 1"), ID_LINE_COLUMN, 0, true);
	statusBar()->setItemAlignment( ID_LINE_COLUMN, AlignLeft|AlignVCenter );
	statusBar()->insertItem(i18n("Normal Mode"), ID_HINTTEXT,10);
	statusBar()->setItemAlignment( ID_HINTTEXT, AlignLeft|AlignVCenter );
}

void Kile::setupSideBar()
{
	m_sideBar = new KileSideBar(KileConfig::sideBarSize(), m_horizontalSplitter);

	m_fileSelector= new KileFileSelect(m_extensions,m_sideBar,"File Selector");
	m_sideBar->addTab(m_fileSelector, SmallIcon("document-open"), i18n("Open File"));
	connect(m_fileSelector,TQT_SIGNAL(fileSelected(const KFileItem*)), docManager(), TQT_SLOT(fileSelected(const KFileItem*)));
	connect(m_fileSelector->comboEncoding(), TQT_SIGNAL(activated(int)),this,TQT_SLOT(changeInputEncoding()));
	m_fileSelector->comboEncoding()->lineEdit()->setText(KileConfig::defaultEncoding());
	m_fileSelector->readConfig();

	setupProjectView();
	setupStructureView();
	setupSymbolViews();
	setupScriptsManagementView();
	setupAbbreviationView();

	m_sideBar->showTab(KileConfig::selectedLeftView());
	m_sideBar->setVisible(KileConfig::sideBar());
	m_sideBar->setSize(KileConfig::sideBarSize());
}

void Kile::setupProjectView()
{
	KileProjectView *projectview = new KileProjectView(m_sideBar, this);
// 	viewManager()->setProjectView(projectview);
	m_sideBar->addTab(projectview, SmallIcon("relation"), i18n("Files and Projects"));
	connect(projectview, TQT_SIGNAL(fileSelected(const KileProjectItem *)), docManager(), TQT_SLOT(fileSelected(const KileProjectItem *)));
	connect(projectview, TQT_SIGNAL(fileSelected(const KURL &)), docManager(), TQT_SLOT(fileSelected(const KURL &)));
	connect(projectview, TQT_SIGNAL(closeURL(const KURL&)), docManager(), TQT_SLOT(fileClose(const KURL&)));
	connect(projectview, TQT_SIGNAL(closeProject(const KURL&)), docManager(), TQT_SLOT(projectClose(const KURL&)));
	connect(projectview, TQT_SIGNAL(projectOptions(const KURL&)), docManager(), TQT_SLOT(projectOptions(const KURL&)));
	connect(projectview, TQT_SIGNAL(projectArchive(const KURL&)), TQT_TQOBJECT(this), TQT_SLOT(runArchiveTool(const KURL&)));
	connect(projectview, TQT_SIGNAL(removeFromProject(const KileProjectItem *)), docManager(), TQT_SLOT(removeFromProject(const KileProjectItem *)));
	connect(projectview, TQT_SIGNAL(addFiles(const KURL &)), docManager(), TQT_SLOT(projectAddFiles(const KURL &)));
	connect(projectview, TQT_SIGNAL(openAllFiles(const KURL &)), docManager(), TQT_SLOT(projectOpenAllFiles(const KURL &)));
	connect(projectview, TQT_SIGNAL(toggleArchive(KileProjectItem *)), docManager(), TQT_SLOT(toggleArchive(KileProjectItem *)));
	connect(projectview, TQT_SIGNAL(addToProject(const KURL &)), docManager(), TQT_SLOT(addToProject(const KURL &)));
	connect(projectview, TQT_SIGNAL(saveURL(const KURL &)), docManager(), TQT_SLOT(saveURL(const KURL &)));
	connect(projectview, TQT_SIGNAL(buildProjectTree(const KURL &)), docManager(), TQT_SLOT(buildProjectTree(const KURL &)));
	connect(docManager(), TQT_SIGNAL(projectTreeChanged(const KileProject *)), projectview, TQT_SLOT(refreshProjectTree(const KileProject *)));
	connect(docManager(), TQT_SIGNAL(removeFromProjectView(const KURL &)),projectview,TQT_SLOT(remove(const KURL &)));
	connect(docManager(), TQT_SIGNAL(removeFromProjectView(const KileProject *)),projectview,TQT_SLOT(remove(const KileProject *)));
	connect(docManager(), TQT_SIGNAL(addToProjectView(const KURL &)),projectview,TQT_SLOT(add(const KURL &)));
	connect(docManager(), TQT_SIGNAL(addToProjectView(const KileProject *)),projectview,TQT_SLOT(add(const KileProject *)));
	connect(docManager(),TQT_SIGNAL(removeItemFromProjectView(const KileProjectItem *, bool)),projectview,TQT_SLOT(removeItem(const KileProjectItem *, bool)));
	connect(docManager(),TQT_SIGNAL(addToProjectView(KileProjectItem *)),projectview,TQT_SLOT(add(KileProjectItem *)));
}

void Kile::setupStructureView()
{
	m_kwStructure = new KileWidget::Structure(this, m_sideBar);
	m_sideBar->addTab(m_kwStructure, SmallIcon("view_tree"), i18n("Structure"));
	m_kwStructure->setFocusPolicy(TQ_ClickFocus);
	connect(TQT_TQOBJECT(this), TQT_SIGNAL(configChanged()), m_kwStructure, TQT_SIGNAL(configChanged()));
	connect(m_kwStructure, TQT_SIGNAL(setCursor(const KURL &,int,int)), TQT_TQOBJECT(this), TQT_SLOT(setCursor(const KURL &,int,int)));
	connect(m_kwStructure, TQT_SIGNAL(fileOpen(const KURL&, const TQString & )), docManager(), TQT_SLOT(fileOpen(const KURL&, const TQString& )));
	connect(m_kwStructure, TQT_SIGNAL(fileNew(const KURL&)), docManager(), TQT_SLOT(fileNew(const KURL&)));
	connect(m_kwStructure, TQT_SIGNAL(sendText(const TQString &)), TQT_TQOBJECT(this), TQT_SLOT(insertText(const TQString &)));
	connect(m_kwStructure, TQT_SIGNAL(sectioningPopup(KileListViewItem *,int)), m_edit, TQT_SLOT(sectioningCommand(KileListViewItem *,int)));
}

void Kile::setupScriptsManagementView()
{
	m_scriptsManagementWidget = new KileWidget::ScriptsManagement(this, m_sideBar);
	connect((TQObject*)editorKeySequenceManager(), TQT_SIGNAL(watchedKeySequencesChanged()), m_scriptsManagementWidget, TQT_SLOT(updateListView()));
	m_sideBar->addTab(m_scriptsManagementWidget, SmallIcon("jspage"), i18n("Scripts"));
}

void Kile::enableSymbolViewMFUS()
{
	m_toolBox->setItemEnabled(m_toolBox->indexOf(m_symbolViewMFUS),true);
	m_toolBox->setItemToolTip(m_toolBox->indexOf(m_symbolViewMFUS),
			i18n("Move the mouse over an icon to see the corresponding LaTeX command.\n \
			Click on an icon to insert the command, additionally pressing SHIFT inserts it in math mode,\
			pressing CTRL in curly brackets."));

	connect(m_symbolViewRelation,TQT_SIGNAL(addToList(const TQIconViewItem *)),m_symbolViewMFUS,TQT_SLOT(slotAddToList(const TQIconViewItem *)));
	connect(m_symbolViewOperators,TQT_SIGNAL(addToList(const TQIconViewItem *)),m_symbolViewMFUS,TQT_SLOT(slotAddToList(const TQIconViewItem *)));
	connect(m_symbolViewArrows,TQT_SIGNAL(addToList(const TQIconViewItem *)),m_symbolViewMFUS,TQT_SLOT(slotAddToList(const TQIconViewItem *)));
	connect(m_symbolViewMiscMath,TQT_SIGNAL(addToList(const TQIconViewItem *)),m_symbolViewMFUS,TQT_SLOT(slotAddToList(const TQIconViewItem *)));
	connect(m_symbolViewMiscText,TQT_SIGNAL(addToList(const TQIconViewItem *)),m_symbolViewMFUS,TQT_SLOT(slotAddToList(const TQIconViewItem *)));
	connect(m_symbolViewDelimiters,TQT_SIGNAL(addToList(const TQIconViewItem *)),m_symbolViewMFUS,TQT_SLOT(slotAddToList(const TQIconViewItem *)));
	connect(m_symbolViewGreek,TQT_SIGNAL(addToList(const TQIconViewItem *)),m_symbolViewMFUS,TQT_SLOT(slotAddToList(const TQIconViewItem *)));
	connect(m_symbolViewSpecial,TQT_SIGNAL(addToList(const TQIconViewItem *)),m_symbolViewMFUS,TQT_SLOT(slotAddToList(const TQIconViewItem *)));
	connect(m_symbolViewCyrillic,TQT_SIGNAL(addToList(const TQIconViewItem *)),m_symbolViewMFUS,TQT_SLOT(slotAddToList(const TQIconViewItem *)));
	connect(m_symbolViewUser,TQT_SIGNAL(addToList(const TQIconViewItem *)),m_symbolViewMFUS,TQT_SLOT(slotAddToList(const TQIconViewItem *)));
}

void Kile::disableSymbolViewMFUS()
{
	m_toolBox->setItemEnabled(m_toolBox->indexOf(m_symbolViewMFUS),false);
	m_toolBox->setItemToolTip(m_toolBox->indexOf(m_symbolViewMFUS),TQString());
	disconnect(m_symbolViewMFUS,TQT_SIGNAL(addtoList(const TQIconViewItem *)));
}



void Kile::setupSymbolViews()
{
	m_toolBox = new TQToolBox(m_sideBar);
	m_sideBar->addTab(m_toolBox,SmallIcon("math0"),i18n("Symbols"));

	m_symbolViewMFUS = new SymbolView(m_toolBox,SymbolView::MFUS);
	m_toolBox->addItem(m_symbolViewMFUS,i18n("Most Frequently Used"));
	m_toolBox->setItemEnabled(m_toolBox->indexOf(m_symbolViewMFUS),false);
	connect(m_symbolViewMFUS, TQT_SIGNAL(insertText(const TQString& ,const TQStringList&)),
		TQT_TQOBJECT(this), TQT_SLOT(insertText(const TQString& ,const TQStringList&)));
	
	m_symbolViewRelation = new SymbolView(m_toolBox,SymbolView::Relation);
	m_toolBox->addItem(m_symbolViewRelation,SmallIcon("math1"),i18n("Relation"));
	connect(m_symbolViewRelation, TQT_SIGNAL(insertText(const TQString& ,const TQStringList&)),
		 TQT_TQOBJECT(this), TQT_SLOT(insertText(const TQString& ,const TQStringList&)));
		
	m_symbolViewOperators = new SymbolView(m_toolBox,SymbolView::Operator);
	m_toolBox->addItem(m_symbolViewOperators,SmallIcon("math2"),i18n("Operators"));
	connect(m_symbolViewOperators, TQT_SIGNAL(insertText(const TQString& ,const TQStringList&)),
		TQT_TQOBJECT(this), TQT_SLOT(insertText(const TQString& ,const TQStringList&)));

	m_symbolViewArrows = new SymbolView(m_toolBox,SymbolView::Arrow);
	m_toolBox->addItem(m_symbolViewArrows,SmallIcon("math3"),i18n("Arrows"));
	connect(m_symbolViewArrows, TQT_SIGNAL(insertText(const TQString& ,const TQStringList&)),
		TQT_TQOBJECT(this), TQT_SLOT(insertText(const TQString& ,const TQStringList&)));

	m_symbolViewMiscMath = new SymbolView(m_toolBox,SymbolView::MiscMath);
	m_toolBox->addItem(m_symbolViewMiscMath,SmallIcon("math4"),i18n("Miscellaneous Math"));
	connect(m_symbolViewMiscMath, TQT_SIGNAL(insertText(const TQString& ,const TQStringList&)),
		TQT_TQOBJECT(this), TQT_SLOT(insertText(const TQString& ,const TQStringList&)));

	m_symbolViewMiscText = new SymbolView(m_toolBox,SymbolView::MiscText);
	m_toolBox->addItem(m_symbolViewMiscText,SmallIcon("math5"),i18n("Miscellaneous Text"));
	connect(m_symbolViewMiscText, TQT_SIGNAL(insertText(const TQString& ,const TQStringList&)),
		TQT_TQOBJECT(this), TQT_SLOT(insertText(const TQString& ,const TQStringList&)));

	m_symbolViewDelimiters= new SymbolView(m_toolBox,SymbolView::Delimiters);
	m_toolBox->addItem(m_symbolViewDelimiters,SmallIcon("math6"),i18n("Delimiters"));
	connect(m_symbolViewDelimiters, TQT_SIGNAL(insertText(const TQString& ,const TQStringList&)),
		TQT_TQOBJECT(this), TQT_SLOT(insertText(const TQString& ,const TQStringList&)));

	m_symbolViewGreek = new SymbolView(m_toolBox,SymbolView::Greek);
	m_toolBox->addItem(m_symbolViewGreek,SmallIcon("math7"),i18n("Greek"));
	connect(m_symbolViewGreek, TQT_SIGNAL(insertText(const TQString&, const TQStringList&)),
		TQT_TQOBJECT(this), TQT_SLOT(insertText(const TQString&, const TQStringList&)));

	m_symbolViewSpecial = new SymbolView(m_toolBox,SymbolView::Special);
	m_toolBox->addItem(m_symbolViewSpecial,SmallIcon("math8"),i18n("Special Characters"));
	connect(m_symbolViewSpecial, TQT_SIGNAL(insertText(const TQString& ,const TQStringList&)),
		TQT_TQOBJECT(this), TQT_SLOT(insertText(const TQString&, const TQStringList&)));

	m_symbolViewCyrillic = new SymbolView(m_toolBox,SymbolView::Cyrillic);
	m_toolBox->addItem(m_symbolViewCyrillic,SmallIcon("math10"),i18n("Cyrillic Characters"));
	connect(m_symbolViewCyrillic, TQT_SIGNAL(insertText(const TQString& ,const TQStringList&)),
		TQT_TQOBJECT(this), TQT_SLOT(insertText(const TQString&, const TQStringList&)));

	m_symbolViewUser = new SymbolView(m_toolBox,SymbolView::User);
	m_toolBox->addItem(m_symbolViewUser,SmallIcon("math9"),i18n("User Defined"));
	connect(m_symbolViewUser, TQT_SIGNAL(insertText(const TQString&, const TQStringList&)),
		TQT_TQOBJECT(this), TQT_SLOT(insertText(const TQString&, const TQStringList& )));

	for (int i=0; i< m_toolBox->count(); i++)
		m_toolBox->setItemToolTip(i, i18n("Move the mouse over the icons to see the corresponding LaTeX commands.\nClick on the images to insert the command, additionally pressing SHIFT inserts it in math mode, pressing CTRL in curly brackets."));
}

void Kile::setupAbbreviationView()
{
	m_kileAbbrevView = new KileAbbrevView( m_sideBar );
	m_edit->complete()->setAbbreviationListview(m_kileAbbrevView);
	m_sideBar->addTab(m_kileAbbrevView, SmallIcon("complete3"), i18n("Abbreviation"));

	connect(m_kileAbbrevView, TQT_SIGNAL(sendText(const TQString& )), TQT_TQOBJECT(this), TQT_SLOT(insertText(const TQString& )));
}

void Kile::setupBottomBar()
{
	m_bottomBar = new KileBottomBar(KileConfig::bottomBarSize(), m_verticalSplitter);
	m_bottomBar->setFocusPolicy(TQ_ClickFocus);

	m_logWidget = new KileWidget::LogMsg( this, m_bottomBar );
	connect(m_logWidget, TQT_SIGNAL(showingErrorMessage(TQWidget* )), m_bottomBar, TQT_SLOT(showPage(TQWidget* )));
	connect(m_logWidget, TQT_SIGNAL(fileOpen(const KURL&, const TQString & )), docManager(), TQT_SLOT(fileOpen(const KURL&, const TQString& )));
	connect(m_logWidget, TQT_SIGNAL(setLine(const TQString& )), TQT_TQOBJECT(this), TQT_SLOT(setLine(const TQString& )));
	connect(m_docManager,TQT_SIGNAL(printMsg(int, const TQString &, const TQString &)),m_logWidget,TQT_SLOT(printMsg(int, const TQString &, const TQString &)));

	m_logWidget->setFocusPolicy(TQ_ClickFocus);
	m_logWidget->setMinimumHeight(40);
	m_logWidget->setReadOnly(true);
	m_bottomBar->addTab(m_logWidget, SmallIcon("viewlog"), i18n("Log and Messages"));

	m_outputWidget = new KileWidget::Output(m_bottomBar);
	m_outputWidget->setFocusPolicy(TQ_ClickFocus);
	m_outputWidget->setMinimumHeight(40);
	m_outputWidget->setReadOnly(true);
	m_bottomBar->addTab(m_outputWidget, SmallIcon("output_win"), i18n("Output"));

	m_outputInfo=new LatexOutputInfoArray();
	m_outputFilter=new LatexOutputFilter(m_outputInfo,m_extensions);
	connect(m_outputFilter, TQT_SIGNAL(problem(int, const TQString& )), m_logWidget, TQT_SLOT(printProblem(int, const TQString& )));

	m_texKonsole=new KileWidget::Konsole(this, m_bottomBar,"konsole");
	m_bottomBar->addTab(m_texKonsole, SmallIcon("konsole"),i18n("Konsole"));
	connect(viewManager()->tabs(), TQT_SIGNAL( currentChanged( TQWidget * ) ), m_texKonsole, TQT_SLOT(sync()));

	m_previewView = new TQScrollView (m_bottomBar);
	m_previewWidget = new KileWidget::PreviewWidget (this, m_previewView);
	m_previewView->viewport()->setPaletteBackgroundColor (TQColor (0xff, 0xff, 0xff));
	m_previewView->addChild(m_previewWidget, 0, 0); 
	m_bottomBar->addTab (m_previewView, SmallIcon ("edu_mathematics"), i18n ("Preview"));

	m_bottomBar->setVisible(true);
	m_bottomBar->setSize(KileConfig::bottomBarSize());
}

void Kile::setupGraphicTools()
{
	KileConfig::setImagemagick(!(TDEStandardDirs::findExe("identify").isNull()));
}

void Kile::setupPreviewTools()
{
	// search for tools
	bool dvipng = !(TDEStandardDirs::findExe("dvipng").isNull());
	bool convert = !(TDEStandardDirs::findExe("convert").isNull());

	KileConfig::setDvipng(dvipng);
	KileConfig::setConvert(convert);

	// disable some previews, if tools are missing
	if ( ! dvipng )
	{
		KileConfig::setMathgroupPreviewInWidget(false);  // no mathgroup preview in bottom bar
		if ( ! convert )
		{
			KileConfig::setEnvPreviewInWidget(false);     // no preview in bottom bar at all
			KileConfig::setSelPreviewInWidget(false);
		}
	}
}

void Kile::setupActions()
{
	m_paPrint = KStdAction::print(0,0, actionCollection(), "file_print");
	(void) KStdAction::openNew(docManager(), TQT_SLOT(fileNew()), actionCollection(), "file_new" );
	(void) KStdAction::open(docManager(), TQT_SLOT(fileOpen()), actionCollection(),"file_open" );
	m_actRecentFiles = KStdAction::openRecent(docManager(), TQT_SLOT(fileOpen(const KURL&)), actionCollection(), "file_open_recent");
	connect(docManager(), TQT_SIGNAL(addToRecentFiles(const KURL& )), m_actRecentFiles, TQT_SLOT(addURL(const KURL& )));
	m_actRecentFiles->loadEntries(m_config, "Recent Files");

	(void) new TDEAction(i18n("Save All"),"save_all", 0, docManager(), TQT_SLOT(fileSaveAll()), actionCollection(),"file_save_all");
	(void) new TDEAction(i18n("Save Copy As..."),"save_copy_as", 0, docManager(), TQT_SLOT(fileSaveCopyAs()), actionCollection(),"file_save_copy_as");
	(void) new TDEAction(i18n("Create Template From Document..."), 0, docManager(), TQT_SLOT(createTemplate()), actionCollection(),"template_create");
	(void) new TDEAction(i18n("&Remove Template..."),0, docManager(), TQT_SLOT(removeTemplate()), actionCollection(), "template_remove");
	(void) KStdAction::close(docManager(), TQT_SLOT(fileClose()), actionCollection(),"file_close" );
	(void) new TDEAction(i18n("Close All"), 0, docManager(), TQT_SLOT(fileCloseAll()), actionCollection(),"file_close_all" );
	(void) new TDEAction(i18n("Close All Ot&hers"), 0, docManager(), TQT_SLOT(fileCloseAllOthers()), actionCollection(),"file_close_all_others" );
	(void) new TDEAction(i18n("S&tatistics"), 0, TQT_TQOBJECT(this), TQT_SLOT(showDocInfo()), actionCollection(), "Statistics" );
	(void) new TDEAction(i18n("&ASCII"), 0, TQT_TQOBJECT(this), TQT_SLOT(convertToASCII()), actionCollection(), "file_export_ascii" );
	(void) new TDEAction(i18n("Latin-&1 (iso 8859-1)"), 0, TQT_TQOBJECT(this), TQT_SLOT(convertToEnc()), actionCollection(), "file_export_latin1" );
	(void) new TDEAction(i18n("Latin-&2 (iso 8859-2)"), 0, TQT_TQOBJECT(this), TQT_SLOT(convertToEnc()), actionCollection(), "file_export_latin2" );
	(void) new TDEAction(i18n("Latin-&3 (iso 8859-3)"), 0, TQT_TQOBJECT(this), TQT_SLOT(convertToEnc()), actionCollection(), "file_export_latin3" );
	(void) new TDEAction(i18n("Latin-&4 (iso 8859-4)"), 0, TQT_TQOBJECT(this), TQT_SLOT(convertToEnc()), actionCollection(), "file_export_latin4" );
	(void) new TDEAction(i18n("Latin-&5 (iso 8859-5)"), 0, TQT_TQOBJECT(this), TQT_SLOT(convertToEnc()), actionCollection(), "file_export_latin5" );
	(void) new TDEAction(i18n("Latin-&9 (iso 8859-9)"), 0, TQT_TQOBJECT(this), TQT_SLOT(convertToEnc()), actionCollection(), "file_export_latin9" );
	(void) new TDEAction(i18n("&Central European (cp-1250)"), 0, TQT_TQOBJECT(this), TQT_SLOT(convertToEnc()), actionCollection(), "file_export_cp1250" );
	(void) new TDEAction(i18n("&Western European (cp-1252)"), 0, TQT_TQOBJECT(this), TQT_SLOT(convertToEnc()), actionCollection(), "file_export_cp1252" );
	(void) KStdAction::quit(TQT_TQOBJECT(this), TQT_SLOT(close()), actionCollection(),"file_quit" );

	(void) KStdAction::gotoLine(m_edit, TQT_SLOT(gotoLine()), actionCollection(),"edit_goto_line" );
	(void) new TDEAction(i18n("Next section"), "nextsection", ALT+Key_Down, m_edit, TQT_SLOT(gotoNextSectioning()), actionCollection(),"edit_next_section" );
	(void) new TDEAction(i18n("Prev section"), "prevsection", ALT+Key_Up, m_edit, TQT_SLOT(gotoPrevSectioning()), actionCollection(),"edit_prev_section" );
	(void) new TDEAction(i18n("Next paragraph"), "nextparagraph", ALT+SHIFT+Key_Down, m_edit, TQT_SLOT(gotoNextParagraph()), actionCollection(),"edit_next_paragraph" );
	(void) new TDEAction(i18n("Prev paragraph"), "prevparagraph", ALT+SHIFT+Key_Up, m_edit, TQT_SLOT(gotoPrevParagraph()), actionCollection(),"edit_prev_paragraph" );

	(void) new TDEAction(i18n("Find &in Files..."), "filegrep", ALT+SHIFT+Key_F, TQT_TQOBJECT(this), TQT_SLOT(findInFiles()), actionCollection(),"FindInFiles" );

	(void) new TDEAction(i18n("Refresh Str&ucture"), "refreshstructure", Key_F12, TQT_TQOBJECT(this), TQT_SLOT(refreshStructure()), actionCollection(),"RefreshStructure" );

	//project actions
	(void) new TDEAction(i18n("&New Project..."), "window-new", 0, docManager(), TQT_SLOT(projectNew()), actionCollection(), "project_new");
	(void) new TDEAction(i18n("&Open Project..."), "project_open", 0, docManager(), TQT_SLOT(projectOpen()), actionCollection(), "project_open");
	m_actRecentProjects =  new TDERecentFilesAction(i18n("Open &Recent Project"),  0, docManager(), TQT_SLOT(projectOpen(const KURL &)), actionCollection(), "project_openrecent");
	connect(docManager(), TQT_SIGNAL(removeFromRecentProjects(const KURL& )), m_actRecentProjects, TQT_SLOT(removeURL(const KURL& )));
	connect(docManager(), TQT_SIGNAL(addToRecentProjects(const KURL& )), m_actRecentProjects, TQT_SLOT(addURL(const KURL& )));
	m_actRecentProjects->loadEntries(m_config, "Projects");

	(void) new TDEAction(i18n("A&dd Files to Project..."),"project_add", 0, docManager(), TQT_SLOT(projectAddFiles()), actionCollection(), "project_add");
	(void) new TDEAction(i18n("Refresh Project &Tree"), "rebuild", 0, docManager(), TQT_SLOT(buildProjectTree()), actionCollection(), "project_buildtree");
 	(void) new TDEAction(i18n("&Archive"), "package", 0, TQT_TQOBJECT(this), TQT_SLOT(runArchiveTool()), actionCollection(), "project_archive");
	(void) new TDEAction(i18n("Project &Options"), "configure_project", 0, docManager(), TQT_SLOT(projectOptions()), actionCollection(), "project_options");
	(void) new TDEAction(i18n("&Close Project"), "window-close", 0, docManager(), TQT_SLOT(projectClose()), actionCollection(), "project_close");

	// new project actions (dani)
	(void) new TDEAction(i18n("&Show Projects..."), 0, docManager(), TQT_SLOT(projectShow()), actionCollection(), "project_show");
	(void) new TDEAction(i18n("Re&move Files From Project..."),"project_remove", 0, docManager(), TQT_SLOT(projectRemoveFiles()), actionCollection(), "project_remove");
	(void) new TDEAction(i18n("Show Project &Files..."),"project_show", 0, docManager(), TQT_SLOT(projectShowFiles()), actionCollection(), "project_showfiles");
	// tbraun
	(void) new TDEAction(i18n("Open All &Project Files"), 0, docManager(), TQT_SLOT(projectOpenAllFiles()), actionCollection(), "project_openallfiles");
	(void) new TDEAction(i18n("Find in &Project..."), "projectgrep", 0, TQT_TQOBJECT(this), TQT_SLOT(findInProjects()), actionCollection(),"project_findfiles" );

	//build actions
	(void) new TDEAction(i18n("Clean"),"trashcan_full",0 , TQT_TQOBJECT(this), TQT_SLOT(cleanAll()), actionCollection(),"CleanAll" );
	(void) new TDEAction(i18n("View Log File"),"viewlog", ALT+Key_0, m_errorHandler, TQT_SLOT(ViewLog()), actionCollection(),"ViewLog" );
	(void) new TDEAction(i18n("Previous LaTeX Error"),"errorprev", 0, m_errorHandler, TQT_SLOT(PreviousError()), actionCollection(),"PreviousError" );
	(void) new TDEAction(i18n("Next LaTeX Error"),"errornext", 0, m_errorHandler, TQT_SLOT(NextError()), actionCollection(),"NextError" );
	(void) new TDEAction(i18n("Previous LaTeX Warning"),"warnprev", 0, m_errorHandler, TQT_SLOT(PreviousWarning()), actionCollection(),"PreviousWarning" );
	(void) new TDEAction(i18n("Next LaTeX Warning"),"warnnext", 0, m_errorHandler, TQT_SLOT(NextWarning()), actionCollection(),"NextWarning" );
	(void) new TDEAction(i18n("Previous LaTeX BadBox"),"bboxprev", 0, m_errorHandler, TQT_SLOT(PreviousBadBox()), actionCollection(),"PreviousBadBox" );
	(void) new TDEAction(i18n("Next LaTeX BadBox"),"bboxnext", 0, m_errorHandler, TQT_SLOT(NextBadBox()), actionCollection(),"NextBadBox" );
	m_paStop = new TDEAction(i18n("&Stop"),"process-stop",Key_Escape,0,0,actionCollection(),"Stop");
	m_paStop->setEnabled(false);

	(void) new TDEAction(i18n("Editor View"),"edit",CTRL+Key_E , TQT_TQOBJECT(this), TQT_SLOT(showEditorWidget()), actionCollection(),"EditorView" );
	(void) new TDEAction(i18n("Next Document"),"forward",ALT+Key_Right, viewManager(), TQT_SLOT(gotoNextView()), actionCollection(), "gotoNextDocument" );
	(void) new TDEAction(i18n("Previous Document"),"back",ALT+Key_Left, viewManager(), TQT_SLOT(gotoPrevView()), actionCollection(), "gotoPrevDocument" );
	(void) new TDEAction(i18n("Focus Log/Messages View"), CTRL+ALT+Key_M, TQT_TQOBJECT(this), TQT_SLOT(focusLog()), actionCollection(), "focus_log");
	(void) new TDEAction(i18n("Focus Output View"), CTRL+ALT+Key_O, TQT_TQOBJECT(this), TQT_SLOT(focusOutput()), actionCollection(), "focus_output");
	(void) new TDEAction(i18n("Focus Konsole View"), CTRL+ALT+Key_K, TQT_TQOBJECT(this), TQT_SLOT(focusKonsole()), actionCollection(), "focus_konsole");
	(void) new TDEAction(i18n("Focus Editor View"), CTRL+ALT+Key_E, TQT_TQOBJECT(this), TQT_SLOT(focusEditor()), actionCollection(), "focus_editor");

 // CodeCompletion (dani)
	(void) new TDEAction(i18n("(La)TeX Command"),"complete1",CTRL+Key_Space, m_edit, TQT_SLOT(completeWord()), actionCollection(), "edit_complete_word");
	(void) new TDEAction(i18n("Environment"),"complete2",ALT+Key_Space, m_edit, TQT_SLOT(completeEnvironment()), actionCollection(), "edit_complete_env");
	(void) new TDEAction(i18n("Abbreviation"),"complete3",CTRL+ALT+Key_Space, m_edit, TQT_SLOT(completeAbbreviation()), actionCollection(), "edit_complete_abbrev");

	(void) new TDEAction(i18n("Next Bullet"),"nextbullet",CTRL+ALT+Key_Right, m_edit, TQT_SLOT(nextBullet()), actionCollection(), "edit_next_bullet");
	(void) new TDEAction(i18n("Prev Bullet"),"prevbullet",CTRL+ALT+Key_Left, m_edit, TQT_SLOT(prevBullet()), actionCollection(), "edit_prev_bullet");

 // advanced editor (dani)
	(void) new TDEAction(i18n("Environment (inside)"),"selenv_i",TDEShortcut("CTRL+Alt+S,E"), m_edit, TQT_SLOT(selectEnvInside()), actionCollection(), "edit_select_inside_env");
	(void) new TDEAction(i18n("Environment (outside)"),"selenv_o",TDEShortcut("CTRL+Alt+S,F"), m_edit, TQT_SLOT(selectEnvOutside()), actionCollection(), "edit_select_outside_env");
	(void) new TDEAction(i18n("TeX Group (inside)"),"selgroup_i",TDEShortcut("CTRL+Alt+S,T"), m_edit, TQT_SLOT(selectTexgroupInside()), actionCollection(), "edit_select_inside_group");
	(void) new TDEAction(i18n("TeX Group (outside)"), "selgroup_o",TDEShortcut("CTRL+Alt+S,U"),m_edit, TQT_SLOT(selectTexgroupOutside()), actionCollection(), "edit_select_outside_group");
	(void) new TDEAction(i18n("Math Group"), "selmath",TDEShortcut("CTRL+Alt+S,M"),m_edit, TQT_SLOT(selectMathgroup()), actionCollection(), "edit_select_mathgroup");
	(void) new TDEAction(i18n("Paragraph"),"selpar",TDEShortcut("CTRL+Alt+S,P"),m_edit, TQT_SLOT(selectParagraph()), actionCollection(), "edit_select_paragraph");
	(void) new TDEAction(i18n("Line"),"selline",TDEShortcut("CTRL+Alt+S,L"),m_edit, TQT_SLOT(selectLine()), actionCollection(), "edit_select_line");
	(void) new TDEAction(i18n("TeX Word"),"selword",TDEShortcut("CTRL+Alt+S,W"),m_edit, TQT_SLOT(selectWord()), actionCollection(), "edit_select_word");

	(void) new TDEAction(i18n("Environment (inside)"),"delenv_i",TDEShortcut("CTRL+Alt+T,E"), m_edit, TQT_SLOT(deleteEnvInside()), actionCollection(), "edit_delete_inside_env");
	(void) new TDEAction(i18n("Environment (outside)"),"delenv_o",TDEShortcut("CTRL+Alt+T,F"),m_edit, TQT_SLOT(deleteEnvOutside()), actionCollection(), "edit_delete_outside_env");
	(void) new TDEAction(i18n("TeX Group (inside)"),"delgroup_i",TDEShortcut("CTRL+Alt+T,T"), m_edit, TQT_SLOT(deleteTexgroupInside()), actionCollection(),"edit_delete_inside_group");
	(void) new TDEAction(i18n("TeX Group (outside)"),"delgroup_o",TDEShortcut("CTRL+Alt+T,U"),m_edit, TQT_SLOT(deleteTexgroupInside()), actionCollection(), "edit_delete_outside_group");
	(void) new TDEAction(i18n("Math Group"),"delmath",TDEShortcut("CTRL+Alt+T,M"),m_edit, TQT_SLOT(deleteMathgroup()), actionCollection(), "edit_delete_mathgroup");
	(void) new TDEAction(i18n("Paragraph"),"delpar",TDEShortcut("CTRL+Alt+T,P"),m_edit, TQT_SLOT(deleteParagraph()), actionCollection(), "edit_delete_paragraph");
	(void) new TDEAction(i18n("To End of Line"),"deleol",TDEShortcut("CTRL+Alt+T,I"),m_edit, TQT_SLOT(deleteEndOfLine()), actionCollection(), "edit_delete_eol");
	(void) new TDEAction(i18n("TeX Word"),"delword",TDEShortcut("CTRL+Alt+T,W"),m_edit, TQT_SLOT(deleteWord()), actionCollection(), "edit_delete_word");

	(void) new TDEAction(i18n("Goto Begin"),"gotobeginenv",TDEShortcut("CTRL+Alt+E,B"), m_edit, TQT_SLOT(gotoBeginEnv()), actionCollection(), "edit_begin_env");
	(void) new TDEAction(i18n("Goto End"),"gotoendenv",TDEShortcut("CTRL+Alt+E,E"), m_edit, TQT_SLOT(gotoEndEnv()), actionCollection(), "edit_end_env");
	(void) new TDEAction(i18n("Match"),"matchenv",TDEShortcut("CTRL+Alt+E,M"), m_edit, TQT_SLOT(matchEnv()), actionCollection(), "edit_match_env");
	(void) new TDEAction(i18n("Close"),"closeenv",TDEShortcut("CTRL+Alt+E,C"), m_edit, TQT_SLOT(closeEnv()), actionCollection(), "edit_close_env");
	(void) new TDEAction(i18n("Close All"),"closeallenv",TDEShortcut("CTRL+Alt+E,A"), m_edit, TQT_SLOT(closeAllEnv()), actionCollection(), "edit_closeall_env");

	(void) new TDEAction(i18n("Goto Begin"),"gotobegingroup",TDEShortcut("CTRL+Alt+G,B"), m_edit, TQT_SLOT(gotoBeginTexgroup()), actionCollection(), "edit_begin_group");
	(void) new TDEAction(i18n("Goto End"),"gotoendgroup",TDEShortcut("CTRL+Alt+G,E"), m_edit, TQT_SLOT(gotoEndTexgroup()), actionCollection(), "edit_end_group");
	(void) new TDEAction(i18n("Match"),"matchgroup",TDEShortcut("CTRL+Alt+G,M"), m_edit, TQT_SLOT(matchTexgroup()), actionCollection(), "edit_match_group");
	(void) new TDEAction(i18n("Close"),"closegroup",TDEShortcut("CTRL+Alt+G,C"), m_edit, TQT_SLOT(closeTexgroup()), actionCollection(), "edit_close_group");

	(void) new TDEAction(i18n("Selection"),"preview_sel",TDEShortcut("CTRL+Alt+P,S"), TQT_TQOBJECT(this), TQT_SLOT(quickPreviewSelection()), actionCollection(),"quickpreview_selection" );
	(void) new TDEAction(i18n("Environment"),"preview_env",TDEShortcut("CTRL+Alt+P,E"), TQT_TQOBJECT(this), TQT_SLOT(quickPreviewEnvironment()), actionCollection(),"quickpreview_environment" );
	(void) new TDEAction(i18n("Subdocument"),"preview_subdoc",TDEShortcut("CTRL+Alt+P,D"), TQT_TQOBJECT(this), TQT_SLOT(quickPreviewSubdocument()), actionCollection(),"quickpreview_subdocument" );
	(void) new TDEAction (i18n ("Mathgroup"), "edu_mathematics", TDEShortcut("CTRL+Alt+P,M"), TQT_TQOBJECT(this), TQT_SLOT(quickPreviewMathgroup()), actionCollection(), "quickpreview_math");

	KileStdActions::setupStdTags(this,this);
	KileStdActions::setupMathTags(this);
	KileStdActions::setupBibTags(this);

	(void) new TDEAction(i18n("Quick Start"),"quickwizard",0 , TQT_TQOBJECT(this), TQT_SLOT(quickDocument()), actionCollection(),"wizard_document" );
	connect(docManager(), TQT_SIGNAL(startWizard()), TQT_TQOBJECT(this), TQT_SLOT(quickDocument()));
	(void) new TDEAction(i18n("Tabular"),"wizard_tabular",0 , TQT_TQOBJECT(this), TQT_SLOT(quickTabular()), actionCollection(),"wizard_tabular" );
	(void) new TDEAction(i18n("Array"),"wizard_array",0 , TQT_TQOBJECT(this), TQT_SLOT(quickArray()), actionCollection(),"wizard_array" );
	(void) new TDEAction(i18n("Tabbing"),"wizard_tabbing",0 , TQT_TQOBJECT(this), TQT_SLOT(quickTabbing()), actionCollection(),"wizard_tabbing" );
	(void) new TDEAction(i18n("Floats"),"wizard_float",0, TQT_TQOBJECT(this), TQT_SLOT(quickFloat()), actionCollection(),"wizard_float" );
	(void) new TDEAction(i18n("Math"),"wizard_math",0, TQT_TQOBJECT(this), TQT_SLOT(quickMathenv()), actionCollection(),"wizard_mathenv" );
	(void) new TDEAction(i18n("Postscript Tools"),"wizard_pstools",0 , TQT_TQOBJECT(this), TQT_SLOT(quickPostscript()), actionCollection(),"wizard_postscript" );

	(void) new TDEAction(i18n("Clean"),0 , TQT_TQOBJECT(this), TQT_SLOT(cleanBib()), actionCollection(),"CleanBib" );

	ModeAction=new TDEToggleAction(i18n("Define Current Document as '&Master Document'"),"master",0 , TQT_TQOBJECT(this), TQT_SLOT(toggleMode()), actionCollection(),"Mode" );

	TDEToggleAction *tact = new TDEToggleAction(i18n("Show S&ide Bar"), 0, 0, 0, actionCollection(),"StructureView" );
	tact->setChecked(KileConfig::sideBar());
	connect(tact, TQT_SIGNAL(toggled(bool)), m_sideBar, TQT_SLOT(setVisible(bool)));
	connect(m_sideBar, TQT_SIGNAL(visibilityChanged(bool )), tact, TQT_SLOT(setChecked(bool)));
    connect(m_sideBar, TQT_SIGNAL(visibilityChanged(bool )), TQT_TQOBJECT(this), TQT_SLOT(sideOrBottomBarChanged(bool)));

	m_actionMessageView = new TDEToggleAction(i18n("Show Mess&ages Bar"), 0, 0, 0, actionCollection(),"MessageView" );
	m_actionMessageView->setChecked(true);
	connect(m_actionMessageView, TQT_SIGNAL(toggled(bool)), m_bottomBar, TQT_SLOT(setVisible(bool)));
	connect(m_bottomBar, TQT_SIGNAL(visibilityChanged(bool )), m_actionMessageView, TQT_SLOT(setChecked(bool)));
    connect(m_bottomBar, TQT_SIGNAL(visibilityChanged(bool )), TQT_TQOBJECT(this), TQT_SLOT(sideOrBottomBarChanged(bool)));

	if (m_singlemode) {ModeAction->setChecked(false);}
	else {ModeAction->setChecked(true);}

	WatchFileAction=new TDEToggleAction(i18n("Watch File Mode"),"watchfile",0 , TQT_TQOBJECT(this), TQT_SLOT(toggleWatchFile()), actionCollection(), "WatchFile");
	if (m_bWatchFile) {WatchFileAction->setChecked(true);}
	else {WatchFileAction->setChecked(false);}

	setHelpMenuEnabled(false);
	const TDEAboutData *aboutData = TDEGlobal::instance()->aboutData();
	KHelpMenu *help_menu = new KHelpMenu( this, aboutData);

	KStdAction::tipOfDay(TQT_TQOBJECT(this), TQT_SLOT(showTip()), actionCollection(), "help_tipofday");

	(void) new TDEAction(i18n("TeX Guide"),TDEShortcut("CTRL+Alt+H,G"), m_help, TQT_SLOT(helpTexGuide()), actionCollection(), "help_tex_guide");
	(void) new TDEAction(i18n("LaTeX"),TDEShortcut("CTRL+Alt+H,L"), m_help, TQT_SLOT(helpLatexIndex()), actionCollection(), "help_latex_index");
	(void) new TDEAction(i18n("LaTeX Command"),TDEShortcut("CTRL+Alt+H,C"), m_help, TQT_SLOT(helpLatexCommand()), actionCollection(), "help_latex_command");
	(void) new TDEAction(i18n("LaTeX Subject"),TDEShortcut("CTRL+Alt+H,S"), m_help, TQT_SLOT(helpLatexSubject()), actionCollection(), "help_latex_subject");
	(void) new TDEAction(i18n("LaTeX Env"),TDEShortcut("CTRL+Alt+H,E"), m_help, TQT_SLOT(helpLatexEnvironment()), actionCollection(), "help_latex_env");
	(void) new TDEAction(i18n("Context Help"),TDEShortcut("CTRL+Alt+H,K"), m_help, TQT_SLOT(helpKeyword()), actionCollection(), "help_context");
	(void) new TDEAction(i18n("Documentation Browser"),TDEShortcut("CTRL+Alt+H,B"), m_help, TQT_SLOT(helpDocBrowser()), actionCollection(), "help_docbrowser");

	(void) new TDEAction(i18n("LaTeX Reference"),"help",0 , TQT_TQOBJECT(this), TQT_SLOT(helpLaTex()), actionCollection(),"help_latex_reference" );
	(void) KStdAction::helpContents(help_menu, TQT_SLOT(appHelpActivated()), actionCollection(), "help_handbook");
	(void) KStdAction::reportBug (help_menu, TQT_SLOT(reportBug()), actionCollection(), "report_bug");
	(void) KStdAction::aboutApp(help_menu, TQT_SLOT(aboutApplication()), actionCollection(),"help_aboutKile" );
	(void) KStdAction::aboutKDE(help_menu, TQT_SLOT(aboutKDE()), actionCollection(),"help_aboutKDE" );
	TDEAction *kileconfig = KStdAction::preferences(TQT_TQOBJECT(this), TQT_SLOT(generalOptions()), actionCollection(),"settings_configure" );
	kileconfig->setIcon("configure_kile");

	(void) KStdAction::keyBindings(TQT_TQOBJECT(this), TQT_SLOT(configureKeys()), actionCollection(),"settings_keys" );
	(void) KStdAction::configureToolbars(TQT_TQOBJECT(this), TQT_SLOT(configureToolbars()), actionCollection(),"settings_toolbars" );
	new TDEAction(i18n("&System Check..."), 0, TQT_TQOBJECT(this), TQT_SLOT(slotPerformCheck()), actionCollection(), "settings_perform_check");

	m_menuUserTags = new TDEActionMenu(i18n("User Tags"), SmallIcon("label"), actionCollection(),"menuUserTags");
	m_menuUserTags->setDelayed(false);
	setupUserTagActions();

	actionCollection()->readShortcutSettings();

	m_pFullScreen = KStdAction::fullScreen(TQT_TQOBJECT(this), TQT_SLOT(slotToggleFullScreen()), actionCollection(), this);
}

void Kile::setupTools()
{
	KILE_DEBUG() << "==Kile::setupTools()===================" << endl;
	TQStringList tools = KileTool::toolList(m_config);
	TQString toolMenu;
	TQPtrList<TDEAction> *pl;

	unplugActionList("list_compilers");
	unplugActionList("list_converters");
	unplugActionList("list_quickies");
	unplugActionList("list_viewers");
	unplugActionList("list_other");

	for ( uint i = 0; i < tools.count(); ++i)
	{
		TQString grp = KileTool::groupFor(tools[i], m_config);
		KILE_DEBUG() << tools[i] << " is using group: " << grp << endl;
		m_config->setGroup(KileTool::groupFor(tools[i], m_config));
		toolMenu = KileTool::menuFor(tools[i], m_config);

		if ( toolMenu == "none" ) continue;

		if ( toolMenu == "Compile" )
			pl = &m_listCompilerActions;
		else if ( toolMenu == "View" )
			pl = &m_listViewerActions;
		else if ( toolMenu == "Convert" )
			pl = &m_listConverterActions;
		else if ( toolMenu == "Quick" )
			pl = &m_listQuickActions;
		else
			pl = &m_listOtherActions;

		KILE_DEBUG() << "\tadding " << tools[i] << " " << toolMenu << " #" << pl->count() << endl;

		if ( action(TQString("tool_"+tools[i]).ascii()) == 0L )
		{
			TDEAction *act = new TDEAction(tools[i], KileTool::iconFor(tools[i], m_config), TDEShortcut(), TQT_TQOBJECT(this), TQT_SLOT(runTool()), actionCollection(), TQString("tool_"+tools[i]).ascii());
			pl->append(act);
		}
	}

	cleanUpActionList(m_listCompilerActions, tools);
	cleanUpActionList(m_listViewerActions, tools);
	cleanUpActionList(m_listConverterActions, tools);
	cleanUpActionList(m_listQuickActions, tools);
	cleanUpActionList(m_listOtherActions, tools);

	plugActionList("list_compilers", m_listCompilerActions);
	plugActionList("list_viewers", m_listViewerActions);
	plugActionList("list_converters", m_listConverterActions);
	plugActionList("list_quickies", m_listQuickActions);
	plugActionList("list_other", m_listOtherActions);

	actionCollection()->readShortcutSettings("Shortcuts", m_config);
}

void Kile::cleanUpActionList(TQPtrList<TDEAction> &list, const TQStringList & tools)
{
	for ( TDEAction *act = list.first(); act; act = list.next() )
	{
		if ( action(act->name()) != 0L && !tools.contains(TQString(act->name()).mid(5)) )
		{
			list.remove(act);
			if ( act->isPlugged(toolBar("toolsToolBar")) ) act->unplug(toolBar("toolsToolBar"));
		}
	}
}

void Kile::setupUserTagActions()
{
	TDEShortcut tagaccels[10] = {CTRL+SHIFT+Key_1, CTRL+SHIFT+Key_2,CTRL+SHIFT+Key_3,CTRL+SHIFT+Key_4,CTRL+SHIFT+Key_5,CTRL+SHIFT+Key_6,CTRL+SHIFT+Key_7,
		CTRL+SHIFT+Key_8,CTRL+SHIFT+Key_9,CTRL+SHIFT+Key_0};

	m_actionEditTag = new TDEAction(i18n("Edit User Tags..."),0 , TQT_TQOBJECT(this), TQT_SLOT(editUserMenu()), m_menuUserTags,"EditUserMenu" );
	m_menuUserTags->insert(m_actionEditTag);
	if ( m_listUserTags.size() > 0 )  {
		m_actionEditSeparator = new TDEActionSeparator();
		m_menuUserTags->insert(m_actionEditSeparator);
	}
	for (uint i=0; i<m_listUserTags.size(); ++i)
	{
		TDEShortcut sc; if (i<10)  { sc = tagaccels[i]; } else { sc = 0; }
		TQString name = TQString::number(i+1)+": "+m_listUserTags[i].text;
		KileAction::Tag *menuItem = new KileAction::Tag(name, sc, TQT_TQOBJECT(this), TQT_SLOT(insertTag(const KileAction::TagData &)), actionCollection(), TQString("tag_user_" + m_listUserTags[i].text).ascii(), m_listUserTags[i]);
		m_listUserTagsActions.append(menuItem);
		m_menuUserTags->insert(menuItem);
	}

	actionCollection()->readShortcutSettings("Shortcuts", m_config);
}

void Kile::restoreFilesAndProjects(bool allowRestore)
{
	if (! (allowRestore && KileConfig::restore()) )
	  return;

	TQFileInfo fi;

	KURL url;
	for (uint i=0; i < m_listProjectsOpenOnStart.count(); ++i)
	{
		fi.setFile(m_listProjectsOpenOnStart[i]);
		// don't open project files as they will be opened later in this method 
		if (fi.isReadable()) docManager()->projectOpen(KURL::fromPathOrURL(m_listProjectsOpenOnStart[i]), i, m_listProjectsOpenOnStart.count(), false);
	}

	for (uint i=0; i < m_listDocsOpenOnStart.count(); ++i)
	{
		fi.setFile(m_listDocsOpenOnStart[i]);
		if (fi.isReadable())
			docManager()->fileOpen(KURL::fromPathOrURL(m_listDocsOpenOnStart[i]));
	}

	if (ModeAction) ModeAction->setChecked(!m_singlemode);
	updateModeStatus();

	m_listProjectsOpenOnStart.clear();
	m_listDocsOpenOnStart.clear();

    KILE_DEBUG() << "lastDocument=" << KileConfig::lastDocument() << endl;
	Kate::Document *doc = docManager()->docFor(KURL::fromPathOrURL(KileConfig::lastDocument()));
	if (doc) viewManager()->switchToTextView(doc->url(), true); // request the focus on the view
}

void Kile::setActive()
{
	KILE_DEBUG() << "ACTIVATING" << endl;
	kapp->mainWidget()->raise();
	kapp->mainWidget()->setActiveWindow();
}

void Kile::showTip()
{
    KTipDialog::showTip(this, "kile/tips", true);
}

void Kile::setLine( const TQString &line )
{
	bool ok;
	uint l=line.toUInt(&ok,10);
	Kate::View *view = viewManager()->currentTextView();
	if (view && ok)
  	{
		this->show();
		this->raise();
		view->setFocus();
		view->gotoLineNumber(l-1);

		showEditorWidget();
		newStatus();
  	}
}

void Kile::setCursor(const KURL &url, int parag, int index)
{
	Kate::Document *doc = docManager()->docFor(url);
	if (doc)
	{
		Kate::View *view = (Kate::View*)doc->views().first();
		if (view)
		{
			view->setCursorPositionReal(parag, index);
			view->setFocus();
		}
	}
}

void Kile::runArchiveTool()
{
	this->run("Archive");
}

void Kile::runArchiveTool(const KURL &url)
{
	KileTool::Archive *tool = new KileTool::Archive("Archive", m_manager, false);
	tool->setSource(url.path());
	tool->prepareToRun();
	m_manager->run(tool);
}


int Kile::run(const TQString & tool)
{
	return m_manager->runBlocking(tool);
}

int Kile::runWith(const TQString &tool, const TQString &config)
{
	return m_manager->runBlocking(tool, config);
}

//TODO: move to KileView::Manager
void Kile::activateView(TQWidget* w, bool updateStruct /* = true */ )  //Needs to be TQWidget because of TQTabWidget::currentChanged
{
	//KILE_DEBUG() << "==Kile::activateView==========================" << endl;
	if (!w->inherits("Kate::View"))
		return;

	//disable gui updates to avoid flickering of toolbars
	setUpdatesEnabled(false);
	Kate::View* view = (Kate::View*)w;
	if (view->isActive()) return;

	for (uint i=0; i< viewManager()->textViews().count(); ++i)
	{
		guiFactory()->removeClient(viewManager()->textView(i));
		viewManager()->textView(i)->setActive(false);
	}

	guiFactory()->addClient(view);
	view->setActive( true );

	// remove menu entry to config Kate
	checkKateSettings();

	setUpdatesEnabled(true);

	if (updateStruct) viewManager()->updateStructure();
}

void Kile::updateModeStatus()
{
	KILE_DEBUG() << "==Kile::updateModeStatus()==========" << endl;
	KileProject *project = docManager()->activeProject();
	TQString shortName = m_masterName;
	int pos = shortName.findRev('/');
	shortName.remove(0,pos+1);

	if (project)
	{
		if (m_singlemode)
			statusBar()->changeItem(i18n("Project: %1").arg(project->name()), ID_HINTTEXT);
		else
			statusBar()->changeItem(i18n("Project: %1 (Master document: %2)").arg(project->name()).arg(shortName), ID_HINTTEXT);
	}
	else
	{
		if (m_singlemode)
			statusBar()->changeItem(i18n("Normal mode"), ID_HINTTEXT);
		else
			statusBar()->changeItem(i18n("Master document: %1").arg(shortName), ID_HINTTEXT);
	}

	if (m_singlemode)
	{
		ModeAction->setText(i18n("Define Current Document as 'Master Document'"));
		ModeAction->setChecked(false);
	}
	else
	{
		ModeAction->setText(i18n("Normal mode (current master document: %1)").arg(shortName));
		ModeAction->setChecked(true);
	}

	// enable or disable entries in Kile'S menu
	updateMenu();
}

void Kile::openDocument(const TQString & url)
{
	KILE_DEBUG() << "==Kile::openDocument(" << url << ")==========" << endl;
	docManager()->fileSelected(KURL::fromPathOrURL(url));
}

void Kile::closeDocument()
{
	docManager()->fileClose();
}

void Kile::autoSaveAll()
{
	docManager()->fileSaveAll(true);
}

void Kile::enableAutosave(bool as)
{
	if (as)
	{
		//paranoia pays, we're really screwed if somehow autosaveinterval equals zero
		int interval = KileConfig::autosaveInterval();
		if ( interval < 1 || interval > 99 ) interval = 10;
		m_AutosaveTimer->start(interval * 60000);
	}
	else m_AutosaveTimer->stop();
}

void Kile::openProject(const TQString& proj)
{
	docManager()->projectOpen(KURL::fromPathOrURL(proj));
}

void Kile::focusPreview()
{
	m_bottomBar->showPage(m_previewView);
}

void Kile::focusLog()
{
	m_bottomBar->showPage(m_logWidget);
}

void Kile::focusOutput()
{
	m_bottomBar->showPage(m_outputWidget);
}

void Kile::focusKonsole()
{
	m_bottomBar->showPage(m_texKonsole);
}

void Kile::focusEditor()
{
	Kate::View *view = viewManager()->currentTextView();
	if (view) view->setFocus();
}

void Kile::sideOrBottomBarChanged(bool visible)
{
    if ( ! visible )
    {
        focusEditor();
    }
}

bool Kile::queryExit()
{
	saveSettings();
	return true;
}

bool Kile::queryClose()
{
    Kate::View *view = viewManager()->currentTextView();
    if (view) KileConfig::setLastDocument(view->getDoc()->url().path());
    else KileConfig::setLastDocument("");

	//don't close Kile if embedded viewers are present
	KILE_DEBUG() << "==bool Kile::queryClose(" << m_currentState << ")==========" << endl;
	if ( m_currentState != "Editor" )
	{
		resetPart();
		return false;
	}

	m_listProjectsOpenOnStart.clear();
	m_listDocsOpenOnStart.clear();

	for (uint i=0; i < viewManager()->textViews().count(); ++i)
	{
		m_listDocsOpenOnStart.append(viewManager()->textView(i)->getDoc()->url().path());
	}

	KILE_DEBUG() << "#projects = " << docManager()->projects()->count() << endl;
	for (uint i=0; i < docManager()->projects()->count(); ++i)
	{
		m_listProjectsOpenOnStart.append(docManager()->projects()->at(i)->url().path());
	}

	bool stage1 = docManager()->projectCloseAll();
	bool stage2 = true;

	if (stage1)
	{
		stage2 = docManager()->fileCloseAll();
	}

	return stage1 && stage2;
}

void Kile::showDocInfo(Kate::Document *doc)
{
	if (doc == 0L)
	{
		Kate::View *view = viewManager()->currentTextView();

		if (view)
			doc = view->getDoc();
		else
			return;
	}

	KileDocument::TextInfo *docinfo = docManager()->textInfoFor(doc);
	KileProject *project = KileInfo::docManager()->activeProject();
	if (docinfo) // we have to ensure that we always get a _valid_ docinfo object
	{
		KileStatsDlg *dlg = new KileStatsDlg( project,docinfo, this, 0, "");
		dlg->exec();
		delete dlg;
	}
	else
		kdWarning() << "There is no KileDocument::Info object belonging to this document!" << endl;
}

void Kile::convertToASCII(Kate::Document *doc)
{
	if (doc == 0)
	{
		Kate::View *view = viewManager()->currentTextView();

		if (view) doc = view->getDoc();
		else return;
	}

	ConvertIO io(doc);
	ConvertEncToASCII conv = ConvertEncToASCII(doc->encoding(), &io);
	doc->setEncoding("ISO 8859-1");
	conv.convert();
}

void Kile::convertToEnc(Kate::Document *doc)
{
	if (doc == 0)
	{
		Kate::View *view = viewManager()->currentTextView();

		if (view) doc = view->getDoc();
		else return;
	}

	if (sender())
	{
		ConvertIO io(doc);
		TQString name = TQString(TQT_TQOBJECT(const_cast<TQT_BASE_OBJECT_NAME*>(sender()))->name()).section('_', -1);
		ConvertASCIIToEnc conv = ConvertASCIIToEnc(name, &io);
		conv.convert();
		doc->setEncoding(ConvertMap::encodingNameFor(name));
	}
}

////////////////// GENERAL SLOTS //////////////
void Kile::newStatus(const TQString & msg)
{
	statusBar()->changeItem(msg,ID_LINE_COLUMN);
}

int Kile::lineNumber()
{
	Kate::View *view = viewManager()->currentTextView();

	int para = 0;

	if (view)
	{
		para = view->cursorLine();
	}

	return para;
}

void Kile::newCaption()
{
	Kate::View *view = viewManager()->currentTextView();
	if (view)
	{
		setCaption( getShortName( view->getDoc() ) );
		if (m_bottomBar->currentPage()->inherits("KileWidget::Konsole"))
			m_texKonsole->sync();
	}
	else
		setCaption("");
}

void Kile::grepItemSelected(const TQString &abs_filename, int line)
{
	KILE_DEBUG() << "Open file: "
		<< abs_filename << " (" << line << ")" << endl;
	docManager()->fileOpen(KURL::fromPathOrURL(abs_filename));
	setLine(TQString::number(line));
}

void Kile::findInFiles()
{
	static TQGuardedPtr<KileGrepDialog> dlg = 0;

	if ( ! dlg )
	{
		KILE_DEBUG() << "grep guard: create findInFiles dlg" << endl;
		dlg = new KileGrepDialog(0L,this,KileGrep::Directory);
		dlg->show();
		connect(dlg, TQT_SIGNAL(itemSelected(const TQString &, int)),
		        TQT_TQOBJECT(this), TQT_SLOT(grepItemSelected(const TQString &, int)));
	}
	else
	{
		KILE_DEBUG() << "grep guard: show findInFiles dlg" << endl;
		dlg->setActiveWindow();
		dlg->raise();
	}
}

void Kile::findInProjects()
{
	static TQGuardedPtr<KileGrepDialog> project_dlg = 0;

	if ( ! project_dlg )
	{
		KILE_DEBUG() << "grep guard: create findInProjects dlg" << endl;
		project_dlg = new KileGrepDialog(0L,this,KileGrep::Project);
		project_dlg->show();
		connect(project_dlg, TQT_SIGNAL(itemSelected(const TQString &, int)),
		        TQT_TQOBJECT(this), TQT_SLOT(grepItemSelected(const TQString &, int)));
	}
	else
	{
		KILE_DEBUG() << "grep guard: show findInProjects dlg" << endl;
		project_dlg->setActiveWindow();
		project_dlg->raise();
	}
}

/////////////////// PART & EDITOR WIDGET //////////
void Kile::showEditorWidget()
{
	if(!resetPart())
		return;
	setCentralWidget(m_topWidgetStack);
	m_topWidgetStack->show();
	m_horizontalSplitter->show();
	m_verticalSplitter->show();

	Kate::View *view = viewManager()->currentTextView();
	if (view) view->setFocus();

    setupStatusBar();
	updateModeStatus();
	newCaption();
}


bool Kile::resetPart()
{
	KILE_DEBUG() << "==Kile::resetPart()=============================" << endl;
	KILE_DEBUG() << "\tcurrent state " << m_currentState << endl;
	KILE_DEBUG() << "\twant state " << m_wantState << endl;

	KParts::ReadOnlyPart *part = (KParts::ReadOnlyPart*)m_partManager->activePart();

	if (part && m_currentState != "Editor")
	{
		if(part->closeURL())
		{
			m_partManager->removePart(part);
			m_topWidgetStack->removeWidget(part->widget());
			delete part;
		}
		else
			return false;
	}

    setupStatusBar();
    updateModeStatus();
    newCaption();

	m_currentState = "Editor";
	m_wantState = "Editor";
	m_partManager->setActivePart( 0L);
	return true;
}

void Kile::activePartGUI(KParts::Part * part)
{
	KILE_DEBUG() << "==Kile::activePartGUI()=============================" << endl;
	KILE_DEBUG() << "\tcurrent state " << m_currentState << endl;
	KILE_DEBUG() << "\twant state " << m_wantState << endl;

	createGUI(part);
	unplugActionList("list_quickies"); plugActionList("list_quickies", m_listQuickActions);
	unplugActionList("list_compilers"); plugActionList("list_compilers", m_listCompilerActions);
	unplugActionList("list_converters"); plugActionList("list_converters", m_listConverterActions);
	unplugActionList("list_viewers"); plugActionList("list_viewers", m_listViewerActions);
	unplugActionList("list_other"); plugActionList("list_other", m_listOtherActions);

	showToolBars(m_wantState);

	//manually plug the print action into the toolbar for
	//kghostview (which has the print action defined in
	//a KParts::BrowserExtension)
	KParts::BrowserExtension *ext = KParts::BrowserExtension::childObject(part);
	if (ext && ext->metaObject()->slotNames().contains( "print()" ) ) //part is a BrowserExtension, connect printAction()
	{
		connect(m_paPrint, TQT_SIGNAL(activated()), ext, TQT_SLOT(print()));
		m_paPrint->plug(toolBar("mainToolBar"),3); //plug this action into its default location
		m_paPrint->setEnabled(true);
	}
	else
	{
		if (m_paPrint->isPlugged(toolBar("mainToolBar")))
			m_paPrint->unplug(toolBar("mainToolBar"));

		m_paPrint->setEnabled(false);
	}

	//set the current state
	m_currentState = m_wantState;
	m_wantState = "Editor";
}

void Kile::showToolBars(const TQString & wantState)
{
	// save state of all toolbars
	static bool mainToolBar = true;
	static bool buildToolBar = true;
	static bool errorToolBar = true;
	static bool toolsToolBar = true;
	static bool editToolBar = true;
	static bool mathToolBar = true;

	if ( m_currentState == "Editor" )
	{
		mainToolBar  = toolBar("mainToolBar")->isShown();
		buildToolBar = toolBar("buildToolBar")->isShown();
		errorToolBar = toolBar("errorToolBar")->isShown();
		toolsToolBar = toolBar("toolsToolBar")->isShown();
		editToolBar  = toolBar("editToolBar")->isShown();
		mathToolBar  = toolBar("mathToolBar")->isShown();
	}

	if ( wantState == "HTMLpreview" )
	{
		stateChanged( "HTMLpreview");
		setViewerToolBars();
		enableKileGUI(false);
	}
	else if ( wantState == "Viewer" )
	{
		stateChanged( "Viewer" );
		setViewerToolBars();
		enableKileGUI(false);
	}
	else
	{
		stateChanged( "Editor" );
		m_wantState="Editor";
		m_topWidgetStack->raiseWidget(0);
		if ( ! mainToolBar  ) toolBar("mainToolBar")->hide();
		if ( buildToolBar ) toolBar("buildToolBar")->show();
		if ( errorToolBar ) toolBar("errorToolBar")->show();
		if ( toolsToolBar ) toolBar("toolsToolBar")->show();
		if ( editToolBar  ) toolBar("editToolBar")->show();
		if ( mathToolBar  ) toolBar("mathToolBar")->show();
		toolBar("extraToolBar")->hide();
		enableKileGUI(true);
	}
}

void Kile::setViewerToolBars()
{
	toolBar("mainToolBar")->show();
	toolBar("buildToolBar")->hide();
	toolBar("errorToolBar")->hide();
	toolBar("toolsToolBar")->hide();
	toolBar("editToolBar")->hide();
	toolBar("mathToolBar")->hide();
	toolBar("extraToolBar")->show();
}

void Kile::enableKileGUI(bool enable)
{
	int id;
	TQString text;

	TQMenuBar *menubar = menuBar();
	for (uint i=0; i<menubar->count(); ++i) {
		id = menubar->idAt(i);
		TQPopupMenu *popup = menubar->findItem(id)->popup();
		if ( popup ) {
			text = popup->name();
			if ( text == "menu_build"   ||
				  text == "menu_project" ||
				  text == "menu_latex"   ||
				  text == "wizard"       ||
				  text == "tools"
			   )
			   menubar->setItemEnabled(id, enable);
		}
	}

	// enable or disable userhelp entries 
	m_help->enableUserhelpEntries(enable);
}

// adds action names to their lists

void Kile::initMenu()
{
	TQStringList projectlist,filelist,actionlist;

	projectlist
	   << "project_add" << "project_remove"
	   << "project_showfiles"
	   << "project_buildtree" << "project_options" << "project_findfiles"
	   << "project_archive" << "project_close" << "project_openallfiles"
	   ;

	filelist
	   // file
	   << "convert"
	   // edit
	   << "goto" << "complete" << "bullet" << "select"
	   << "delete" << "environment" << "texgroup"
	   // build
	   << "quickpreview" << "menu_compile" << "menu_convert"
	   << "menu_viewers" << "menu_other"
	   // latex
	   << "menu_preamble" << "menu_lists" << "menu_sectioning" << "references"
	   << "menu_environment" << "menu_listenv" << "menu_tabularenv" << "menu_floatenv"
	   << "menu_code" << "menu_math" << "menu_mathenv" << "menu_mathamsenv"
	   << "menu_bibliography" << "menu_fontstyles" << "menu_spacing"
	   ;

	actionlist
	   // file
	   << "file_save_copy_as" << "file_save_all" << "template_create" << "Statistics"
	   << "file_close" << "file_close_all" << "file_close_all_others"
	   // edit
	   << "RefreshStructure"
	    // view
	   << "gotoPrevDocument" << "gotoNextDocument"
	   // build
	   << "quickpreview_selection" << "quickpreview_environment" 
	   << "quickpreview_subdocument" << "quickpreview_math"
	   << "WatchFile" << "ViewLog" << "PreviousError" << "NextError" << "PreviousWarning"
	   << "NextWarning" << "PreviousBadBox" << "NextBadBox" << "CleanAll"
	   // latex
	   << "tag_documentclass" << "tag_usepackage" << "tag_amspackages" << "tag_env_document"
	   << "tag_author" << "tag_title" << "tag_maketitle" << "tag_titlepage" << "tag_env_abstract"
	   << "tag_tableofcontents" << "tag_listoffigures" << "tag_listoftables"
	   << "tag_makeindex" << "tag_printindex" << "tag_makeglossary" << "tag_env_thebibliography"
	   << "tag_part" << "tag_chapter" << "tag_section" << "tag_subsection" << "tag_subsubsection"
	   << "tag_paragraph" << "tag_subparagraph" << "tag_label"
	   << "tag_ref" << "tag_pageref" << "tag_index" << "tag_footnote" << "tag_cite" << "citeViewBib"
	   << "tag_center" << "tag_flushleft" << "tag_flushright"
	   << "tag_env_minipage" << "tag_quote" << "tag_quotation" << "tag_verse"
	   << "tag_env_itemize" << "tag_env_enumerate" << "tag_env_description" << "tag_item"
	   << "tag_env_tabular" << "tag_env_tabular*" << "tag_env_tabbing"
	   << "tag_multicolumn" << "tag_hline" << "tag_vline" << "tag_cline"
	   << "tag_figure" << "tag_table"
	   << "tag_verbatim" << "tag_env_verbatim*" << "tag_verb" << "tag_verb*"
	   << "tag_mathmode" << "tag_equation" << "tag_subscript" << "tag_superscript"
	   << "tag_sqrt" << "tag_nroot" << "tag_left" << "tag_right" << "tag_leftright"
	   << "tag_bigl" << "tag_bigr" << "tag_Bigl" << "tag_Bigr"
	   << "tag_biggl" << "tag_biggr" << "tag_Biggl" << "tag_Biggr"
	   << "tag_text" << "tag_intertext" << "tag_boxed"
	   << "tag_frac" << "tag_dfrac" << "tag_tfrac"
	   << "tag_binom" << "tag_dbinom" << "tag_tbinom"
	   << "tag_xleftarrow" << "tag_xrightarrow"
	   << "tag_mathrm" << "tag_mathit" << "tag_mathbf" << "tag_mathsf"
	   << "tag_mathtt" << "tag_mathcal" << "tag_mathbb" << "tag_mathfrak"
	   << "tag_acute" << "tag_grave" << "tag_tilde" << "tag_bar" << "tag_vec"
	   << "tag_hat" << "tag_check" << "tag_breve" << "tag_dot" << "tag_ddot"
	   << "tag_space_small" << "tag_space_medium" << "tag_space_large"
	   << "tag_quad" << "tag_qquad" << "tag_enskip"
	   << "tag_env_displaymath" << "tag_env_equation" << "tag_env_equation*"
	   << "tag_env_array"
	   << "tag_env_multline" << "tag_env_multline*" << "tag_env_split"
	   << "tag_env_gather" << "tag_env_gather*" << "tag_env_align" << "tag_env_align*"
	   << "tag_env_flalign" << "tag_env_flalign*" << "tag_env_alignat" << "tag_env_alignat*"
	   << "tag_env_aligned" << "tag_env_gathered" << "tag_env_alignedat" << "tag_env_cases"
	   << "tag_bibliographystyle" << "tag_bibliography" << "tag_bib_article" << "tag_bib_inproc"
	   << "tag_bib_incol" << "tag_bib_inbook" << "tag_bib_proceedings" << "tag_bib_book"
	   << "tag_bib_booklet" << "tag_bib_phdthesis" << "tag_bib_masterthesis" << "tag_bib_techreport"
	   << "tag_bib_manual" << "tag_bib_unpublished" << "tag_bib_misc" << "CleanBib"
	   << "tag_textit" << "tag_textsl" << "tag_textbf" << "tag_underline"
	   << "tag_texttt" << "tag_textsc" << "tag_emph" << "tag_strong"
	   << "tag_rmfamily" << "tag_sffamily" << "tag_ttfamily"
	   << "tag_mdseries" << "tag_bfseries" << "tag_upshape"
	   << "tag_itshape" << "tag_slshape" << "tag_scshape"
	   << "tag_newline" << "tag_newpage" << "tag_linebreak" << "tag_pagebreak"
	   << "tag_bigskip" << "tag_medskip" << "tag_smallskip"
	   << "tag_hspace" << "tag_hspace*" << "tag_vspace" << "tag_vspace*"
	   << "tag_hfill" << "tag_hrulefill" << "tag_dotfill" << "tag_vfill"
	   << "tag_includegraphics" << "tag_include" << "tag_input"
	   << "menuUserTags"
	   // wizard
	   << "wizard_tabular" << "wizard_array" << "wizard_tabbing"
	   << "wizard_float" << "wizard_mathenv"
	   // settings
	   << "Mode" << "settings_keys"
	   // help
	   << "help_context"
	   // action lists
	   << "structure_list" << "size_list" << "other_list"
	   << "left_list" << "right_list"
	   ;

	setMenuItems(projectlist,m_dictMenuProject);
	setMenuItems(filelist,m_dictMenuFile);
	setMenuItems(actionlist,m_dictMenuAction);
}

void Kile::setMenuItems(TQStringList &list, TQMap<TQString,bool> &dict)
{
	for ( TQStringList::Iterator it=list.begin(); it!=list.end(); ++it ) {
		dict[(*it)] = true;
	}
}

void Kile::updateMenu()
{
	KILE_DEBUG() << "==Kile::updateKileMenu()====================" << endl;
	TDEAction *a;
	TQMap<TQString,bool>::Iterator it;

	// update project menus
	m_actRecentProjects->setEnabled( m_actRecentProjects->items().count() > 0 );
	bool project_open = ( docManager()->isProjectOpen() ) ;

	for ( it=m_dictMenuProject.begin(); it!=m_dictMenuProject.end(); ++it ) {
		a = actionCollection()->action(it.key().ascii());
		if ( a )
			a->setEnabled(project_open);
	}

	// project_show is only enabled, when more than 1 project is opened
	a = actionCollection()->action("project_show");
	if ( a )
		a->setEnabled( project_open && docManager()->projects()->count()>1 );

	// update file menus
	m_actRecentFiles->setEnabled( m_actRecentFiles->items().count() > 0 );
	bool file_open = ( viewManager()->currentTextView() );
	KILE_DEBUG() << "\tprojectopen=" << project_open << " fileopen=" << file_open << endl;

	TQMenuBar *menubar = menuBar();
	for ( uint i=0; i<menubar->count(); ++i ) {
		int menu_id = menubar->idAt(i);
		TQPopupMenu *menu = menubar->findItem(menu_id)->popup();
		if ( menu ) {
			TQString menu_name = menu->name();
			for ( uint j=0; j<menu->count(); ++j ) {
				int sub_id = menu->idAt(j);
				TQPopupMenu *submenu = menu->findItem(sub_id)->popup();
				if ( submenu ) {
					TQString submenu_name = submenu->name();
					if ( m_dictMenuFile.contains(submenu_name) ) {
//					if ( m_menuFileList.findIndex( submenu_name ) >= 0 ) {
						menu->setItemEnabled(sub_id, file_open);
					}
				}
			}
		}
	}

	// update action lists
	TDEActionPtrList actions = actionCollection()->actions();
	TDEActionPtrList::Iterator itact;
	for ( itact=actions.begin(); itact!=actions.end(); ++itact )
	{
		if ( m_dictMenuAction.contains( (*itact)->name() ) )
			(*itact)->setEnabled(file_open);
	}

	updateActionList(&m_listQuickActions,file_open);
	updateActionList(&m_listCompilerActions,file_open);
	updateActionList(&m_listConverterActions,file_open);
	updateActionList(&m_listViewerActions,file_open);
	updateActionList(&m_listOtherActions,file_open);

}

void Kile::updateActionList(TQPtrList<TDEAction> *list, bool state)
{
	for ( TDEAction *a=list->first(); a; a=list->next() ) {
		a->setEnabled(state);
	}
}

//TODO: move to KileView::Manager
void Kile::prepareForPart(const TQString & state)
{
	KILE_DEBUG() << "==Kile::prepareForPart====================" << endl;

	if ( m_currentState == "Editor" && state == "Editor" ) return;

	resetPart();
	m_wantState = state;

	//deactivate kateparts
	for (uint i=0; i<viewManager()->textViews().count(); ++i)
	{
		guiFactory()->removeClient(viewManager()->textView(i));
		viewManager()->textView(i)->setActive(false);
	}
}

void Kile::runTool()
{
	focusLog();
	TQString name = TQT_TQOBJECT(const_cast<TQT_BASE_OBJECT_NAME*>(sender()))->name();
	name.replace(TQRegExp("^.*tool_"), "");
	m_manager->run(name);
}

void Kile::cleanAll(KileDocument::TextInfo *docinfo)
{
	static TQString noactivedoc = i18n("There is no active document or it is not saved.");
	if (docinfo == 0)
	{
		Kate::Document *doc = activeTextDocument();
		if (doc)
			docinfo = docManager()->textInfoFor(doc);
		else
		{
			m_logWidget->printMsg(KileTool::Error, noactivedoc, i18n("Clean"));
			return;
		}
	}

	if (docinfo)
		docManager()->cleanUpTempFiles(docinfo->url(), false);
}

void Kile::refreshStructure()
{
	viewManager()->updateStructure(true);
}

void Kile::insertTag(const KileAction::TagData& data)
{
	logWidget()->clear();

	if ( data.description.length() > 0 )
	{
		outputView()->showPage(logWidget());
		setLogPresent(false);
		logWidget()->append(data.description);
	}

	Kate::View *view = viewManager()->currentTextView();

	if ( !view ) return;

	view->setFocus();

	editorExtension()->insertTag(data, view);
}

void Kile::insertTag(const TQString& tagB, const TQString& tagE, int dx, int dy)
{
	insertTag(KileAction::TagData(TQString(),tagB,tagE,dx,dy));
}

void Kile::insertAmsTag(const KileAction::TagData& data)
{
	insertTag(data, TQStringList("amsmath"));
}

void Kile::insertTag(const KileAction::TagData& data,const TQStringList &pkgs)
{
	KILE_DEBUG() << "void Kile::insertTag(const KileAction::TagData& data,const TQStringList " << pkgs.join(",") << ")" << endl;
	insertTag(data);

	KileDocument::Info *docinfo = docManager()->textInfoFor(getCompileName());
	if ( docinfo )
	{
		const TQStringList *packagelist = allPackages(docinfo);
		TQStringList::const_iterator it;
		TQStringList warnPkgs;
		
		for ( it = pkgs.begin() ; it != pkgs.end() ; it++ )
			if( !(*packagelist).contains(*it) )
				warnPkgs.append(*it);

		if( warnPkgs.count() > 0 )
		{
			if( warnPkgs.count() == 1 )
				 m_logWidget->printMsg(KileTool::Error, i18n("You have to include the package %1.").arg(warnPkgs.join(",")),
					       i18n("Insert text"));
			else
				m_logWidget->printMsg(KileTool::Error, i18n("You have to include the packages %1.").arg(warnPkgs.join(",")),
					i18n("Insert text"));
		}
	}
}

void Kile::insertText(const TQString &text)
{
	insertTag( KileAction::TagData(TQString(),text,"%C",0,0) );
}

void Kile::insertText(const TQString &text, const TQStringList &pkgs)
{
	insertTag( KileAction::TagData(TQString(),text,"%C",0,0),pkgs );
}

void Kile::quickDocument()
{
	KileDialog::QuickDocument *dlg = new KileDialog::QuickDocument(m_config, this,"Quick Start",i18n("Quick Start"));

	if ( dlg->exec() )
	{
		if (!viewManager()->currentTextView())
		{
			docManager()->createNewLaTeXDocument();
		}
		insertTag( dlg->tagData() );
		viewManager()->updateStructure(true);
	}
	delete dlg;
}

void Kile::quickArray()
{
	quickTabulardialog(false);
}

void Kile::quickTabular()
{
	quickTabulardialog(true);
}

void Kile::quickTabulardialog(bool tabularenv)
{
	if ( !viewManager()->currentTextView() ) return;

	KileDialog::TabularDialog *dlg = new KileDialog::TabularDialog(this,m_config,m_latexCommands,tabularenv);
	if ( dlg->exec() ) {
		insertTag(dlg->tagData());
	}
	delete dlg;
}

void Kile::quickTabbing()
{
	if ( !viewManager()->currentTextView() ) return;
	KileDialog::QuickTabbing *dlg = new KileDialog::QuickTabbing(m_config,this,this,"Tabbing", i18n("Tabbing"));
	if ( dlg->exec() )
	{
		insertTag(dlg->tagData());
	}
	delete dlg;
}

void Kile::quickFloat()
{
	if ( !viewManager()->currentTextView() ) return;

	KileDialog::FloatEnvironmentDialog *dlg = new KileDialog::FloatEnvironmentDialog(m_config,this,this);
	if ( dlg->exec() ) {
		insertTag(dlg->tagData());
	}
	delete dlg;
}

void Kile::quickMathenv()
{
	if ( !viewManager()->currentTextView() ) return;

	KileDialog::MathEnvironmentDialog *dlg = new KileDialog::MathEnvironmentDialog(this,m_config,this,m_latexCommands);
	if ( dlg->exec() ) {
		insertTag(dlg->tagData());
	}
	delete dlg;
}

void Kile::quickPostscript()
{
	TQString startdir = TQDir::homeDirPath();
	TQString texfilename = TQString();

	Kate::View *view = viewManager()->currentTextView();
	if ( view ) {
		startdir = TQFileInfo(view->getDoc()->url().path()).dirPath();
		texfilename = getCompileName();
	}

	KileDialog::PostscriptDialog *dlg = new KileDialog::PostscriptDialog(this,texfilename,startdir,m_extensions->latexDocuments(),m_logWidget,m_outputWidget);
	dlg->exec();
	delete dlg;
}

void Kile::helpLaTex()
{
	TQString loc = locate("html","en/kile/latexhelp.html");
	KileTool::ViewHTML *tool = new KileTool::ViewHTML("ViewHTML", m_manager, false);
	tool->setFlags(KileTool::NeedSourceExists | KileTool::NeedSourceRead);
	tool->setSource(loc);
	tool->setTargetPath(loc);
	tool->prepareToRun();
	m_manager->run(tool);
}

void Kile::editUserMenu()
{
	KileDialog::UserTags *dlg = new KileDialog::UserTags(m_listUserTags, this, "Edit User Tags", i18n("Edit User Tags"));

	if ( dlg->exec() )
	{
		//remove all actions
		uint len = m_listUserTagsActions.count();
		for (uint j=0; j< len; ++j)
		{
			TDEAction *menuItem = m_listUserTagsActions.getLast();
			m_menuUserTags->remove(menuItem);
			m_listUserTagsActions.removeLast();
			delete menuItem;
		}
		if ( len > 0 )
			m_menuUserTags->remove(m_actionEditSeparator);
		m_menuUserTags->remove(m_actionEditTag);

		m_listUserTags = dlg->result();
		setupUserTagActions();
	}

	delete dlg;
}

void Kile::readGUISettings()
{
	m_horSplitLeft = KileConfig::horizontalSplitterLeft();
	m_horSplitRight = KileConfig::horizontalSplitterRight();
	m_verSplitTop = KileConfig::verticalSplitterTop();
	m_verSplitBottom = KileConfig::verticalSplitterBottom();
}

void Kile::readUserSettings()
{
	//test for old kilerc
	int version = KileConfig::rCVersion();

	//if the kilerc file is old some of the configuration
	//data must be set by kile, even if the keys are present
	//in the kilerc file
	if ( version < 4 )
	{
		KileTool::Factory *factory = new KileTool::Factory(0, m_config);
		KILE_DEBUG() << "WRITING STD TOOL CONFIG" << endl;
		factory->writeStdConfig();
		delete factory;
	}

	//delete old editor key
	if (m_config->hasGroup("Editor") )
	{
		m_config->deleteGroup("Editor");
	}

	m_config->setGroup( "User" );
	int len = m_config->readNumEntry("nUserTags",0);
	for (int i = 0; i < len; ++i)
	{
		m_listUserTags.append(KileDialog::UserTags::splitTag(m_config->readEntry("userTagName"+TQString::number(i),i18n("no name")) , m_config->readEntry("userTag"+TQString::number(i),"") ));
	}

	//convert user tools to new KileTool classes
	userItem tempItem;
	len= m_config->readNumEntry("nUserTools",0);
	for (int i=0; i< len; ++i)
	{
		tempItem.name=m_config->readEntry("userToolName"+TQString::number(i),i18n("no name"));
		tempItem.tag =m_config->readEntry("userTool"+TQString::number(i),"");
		m_listUserTools.append(tempItem);
	}
	if ( len > 0 )
	{
 		//move the tools
		m_config->writeEntry("nUserTools", 0);
		for ( int i = 0; i < len; ++i)
		{
			tempItem = m_listUserTools[i];
			m_config->setGroup("Tools");
			m_config->writeEntry(tempItem.name, "Default");

			KileTool::setGUIOptions(tempItem.name, "Other", "gear", m_config);

			m_config->setGroup(KileTool::groupFor(tempItem.name, "Default"));
			TQString bin = KRun::binaryName(tempItem.tag, false);
			m_config->writeEntry("command", bin);
			m_config->writeEntry("options", tempItem.tag.mid(bin.length()));
			m_config->writeEntry("class", "Base");
			m_config->writeEntry("type", "Process");
			m_config->writeEntry("from", "");
			m_config->writeEntry("to", "");

			if ( i < 10 )
			{
				m_config->setGroup("Shortcuts");
				m_config->writeEntry("tool_" + tempItem.name, "Alt+Shift+" + TQString::number(i + 1) ); //should be alt+shift+
			}
		}
	}

	// check autocompletion modes: if KTextEditor-plugin for document word 
	// completion is active, both autocompletion modes of Kile must be disabled
	if ( kateCompletionPlugin() )
	{
		KileConfig::setCompleteAuto(false);
		KileConfig::setCompleteAutoText(false);
	}
}

void Kile::readRecentFileSettings()
{
	m_config->setGroup("FilesOpenOnStart");
	int n = m_config->readNumEntry("NoDOOS", 0);
	for (int i=0; i < n; ++i)
		m_listDocsOpenOnStart.append(m_config->readPathEntry("DocsOpenOnStart"+TQString::number(i), ""));

	n = m_config->readNumEntry("NoPOOS", 0);
	for (int i=0; i < n; ++i)
		m_listProjectsOpenOnStart.append(m_config->readPathEntry("ProjectsOpenOnStart"+TQString::number(i), ""));
}

void Kile::readConfig()
{
	enableAutosave(KileConfig::autosave());
	m_edit->complete()->readConfig(m_config);
	//m_edit->initDoubleQuotes();
	m_edit->readConfig();
	docManager()->updateInfos();
	m_jScriptManager->readConfig();
	m_sideBar->setPageVisible(m_scriptsManagementWidget, KileConfig::scriptingEnabled());
	m_sideBar->setPageVisible(m_kileAbbrevView, KileConfig::completeShowAbbrev());
	
	if( KileConfig::displayMFUS() )
		enableSymbolViewMFUS();
	else
		disableSymbolViewMFUS();
}

void Kile::saveSettings()
{
	showEditorWidget();

	m_fileSelector->writeConfig();
	m_symbolViewMFUS->writeConfig();

	KileConfig::setInputEncoding(m_fileSelector->comboEncoding()->lineEdit()->text());

	// Store recent files
	m_actRecentFiles->saveEntries(m_config, "Recent Files");
	m_actRecentProjects->saveEntries(m_config, "Projects");

	m_config->deleteGroup("FilesOpenOnStart");
	if (KileConfig::restore())
	{
		m_config->setGroup("FilesOpenOnStart");
		m_config->writeEntry("NoDOOS", m_listDocsOpenOnStart.count());
		for (uint i=0; i < m_listDocsOpenOnStart.count(); ++i)
			m_config->writePathEntry("DocsOpenOnStart"+TQString::number(i), m_listDocsOpenOnStart[i]);

		m_config->writeEntry("NoPOOS", m_listProjectsOpenOnStart.count());
		for (uint i=0; i < m_listProjectsOpenOnStart.count(); ++i)
			m_config->writePathEntry("ProjectsOpenOnStart"+TQString::number(i), m_listProjectsOpenOnStart[i]);

		if (!m_singlemode)
			KileConfig::setMaster(m_masterName);
		else
			KileConfig::setMaster("");
	}

	m_config->setGroup( "User" );

	m_config->writeEntry("nUserTags",static_cast<int>(m_listUserTags.size()));
	for (uint i=0; i < m_listUserTags.size(); ++i)
	{
		KileAction::TagData td( m_listUserTags[i]);
		m_config->writeEntry( "userTagName"+TQString::number(i),  td.text );
		m_config->writeEntry( "userTag"+TQString::number(i), KileDialog::UserTags::completeTag(td) );
	}

	actionCollection()->writeShortcutSettings();
	saveMainWindowSettings(m_config, "KileMainWindow" );

	scriptManager()->writeConfig();
	m_edit->complete()->saveLocalChanges();

	KileConfig::setRCVersion(KILERC_VERSION);
	KileConfig::setMainwindowWidth(width());
	KileConfig::setMainwindowHeight(height());

	TQValueList<int> sizes;
	TQValueList<int>::Iterator it;
	sizes=m_horizontalSplitter->sizes();
	it = sizes.begin();
	m_horSplitLeft=*it;
	++it;
	m_horSplitRight=*it;
	sizes.clear();
	sizes = m_verticalSplitter->sizes();
	it = sizes.begin();
	m_verSplitTop=*it;
	++it;
	m_verSplitBottom=*it;

	// sync vertical splitter and size of bottom bar
	int sizeBottomBar = m_bottomBar->size();
	if ( m_bottomBar->isVisible() )
		sizeBottomBar = m_verSplitBottom;
	else
		m_verSplitBottom = sizeBottomBar;

	KileConfig::setHorizontalSplitterLeft(m_horSplitLeft);
	KileConfig::setHorizontalSplitterRight(m_horSplitRight);
	KileConfig::setVerticalSplitterTop(m_verSplitTop);
	KileConfig::setVerticalSplitterBottom(m_verSplitBottom);

	KileConfig::setSideBar(m_sideBar->isVisible());
	KileConfig::setSideBarSize(m_sideBar->size());
	KileConfig::setBottomBar(m_bottomBar->isVisible());
	KileConfig::setBottomBarSize(sizeBottomBar);

	if(m_sideBar->isVisible())
		KileConfig::setSelectedLeftView(m_sideBar->currentTab());
	else
		KileConfig::setSelectedLeftView(-1);
	KileConfig::writeConfig();
	m_config->sync();
}

/////////////////  OPTIONS ////////////////////
void Kile::toggleMode()
{
	if (!m_singlemode)
	{
		ModeAction->setText(i18n("Define Current Document as 'Master Document'"));
		ModeAction->setChecked(false);
		m_logPresent=false;
		m_singlemode=true;
		m_masterName=TQString();
	}
	else if (m_singlemode && viewManager()->currentTextView())
	{
		m_masterName=getName();
		if ( KileUntitled::isUntitled(m_masterName) || m_masterName.isEmpty())
		{
			ModeAction->setChecked(false);
			KMessageBox::error(this, i18n("In order to define the current document as a master document, it has to be saved first."));
			m_masterName="";
			return;
		}

		TQString shortName = m_masterName;
		int pos;
		while ( (pos = (int)shortName.find('/')) != -1 )
			shortName.remove(0,pos+1);

		ModeAction->setText(i18n("Normal mode (current master document: %1)").arg(shortName));
		ModeAction->setChecked(true);
		m_singlemode=false;
	}
	else
		ModeAction->setChecked(false);

	updateModeStatus();
	KILE_DEBUG() << "SETTING master to " << m_masterName << " singlemode = " << m_singlemode << endl;
}

void Kile::toggleWatchFile()
{
	m_bWatchFile=!m_bWatchFile;

	if (m_bWatchFile)
		WatchFileAction->setChecked(true);
	else
		WatchFileAction->setChecked(false);
}

// execute configuration dialog

void Kile::generalOptions()
{
	m_edit->complete()->saveLocalChanges();
	
	KileDialog::Config *dlg = new KileDialog::Config(m_config,this,this);

	if (dlg->exec())
	{
		// check new Kate settings
		checkKateSettings();

		// update new settings
		readConfig();
		setupTools();
		m_help->update();

		emit configChanged();

		//stop/restart LyX server if necessary
		if (KileConfig::runLyxServer() && !m_lyxserver->isRunning())
			m_lyxserver->start();

		if (!KileConfig::runLyxServer() && m_lyxserver->isRunning())
			m_lyxserver->stop();
	}

	delete dlg;
}

// read kate plugin configuration
bool Kile::kateCompletionPlugin()
{
	m_config->setGroup("Kate Document Defaults");
	return m_config->readBoolEntry("KTextEditor Plugin tdetexteditor_docwordcompletion",false);
}

void Kile::checkKateSettings()
{
	// editor settings were only available with an opened document
	Kate::View *view = viewManager()->currentTextView();
	if ( view )
	{
		// remove menu entry to config Kate
		viewManager()->unplugKatePartMenu(view);
	}
}

void Kile::slotPerformCheck()
{
	if(!m_singlemode)
	{
		m_logWidget->printMsg(KileTool::Error, i18n("Please turn off the \'Master Document\' mode before performing the System Check."), i18n("System Check"));
		return;
	}
	KileDialog::ConfigChecker *dlg = new KileDialog::ConfigChecker(this);
	dlg->exec();
	delete dlg;
}

/////////////// KEYS - TOOLBARS CONFIGURATION ////////////////
void Kile::configureKeys()
{
	KKeyDialog dlg( false, this );
	TQPtrList<KXMLGUIClient> clients = guiFactory()->clients();
	for( TQPtrListIterator<KXMLGUIClient> it( clients );	it.current(); ++it )
	{
		dlg.insert( (*it)->actionCollection() );
	}
	dlg.configure();
	actionCollection()->writeShortcutSettings("Shortcuts", m_config);
}

void Kile::configureToolbars()
{
	saveMainWindowSettings(m_config, "KileMainWindow" );
	KEditToolbar dlg(factory());
	dlg.exec();

	applyMainWindowSettings(m_config, "KileMainWindow" );
 	showToolBars(m_currentState);
}

void Kile::changeInputEncoding()
{
	Kate::Document *doc = activeTextDocument();
	if ( doc )
	{
		KileDocument::TextInfo *textInfo = docManager()->textInfoFor(doc);
		bool modified = doc->isModified();
		
		if( !textInfo )
			return;

		TQString encoding = m_fileSelector->comboEncoding()->lineEdit()->text();

		if(!encoding.isNull())
			doc->setEncoding(encoding);
        	unsigned int mode = doc->hlMode(); //remember the highlighting mode

		//reload the document so that the new encoding takes effect
		doc->openURL(doc->url());
        	doc->setHlMode(mode);
		doc->setModified(modified);
		
		viewManager()->updateStructure(true,textInfo); //reparse doc to get a correct structure view
	}
}

//////////////////// CLEAN BIB /////////////////////
void Kile::cleanBib()
{
	Kate::View *view = viewManager()->currentTextView();
	if ( ! view )
		return;

	TQRegExp reOptional( "(ALT|OPT)(\\w+)\\s*=\\s*(\\S.*)" );
	TQRegExp reNonEmptyEntry( ".*\\w.*" );

	TQString s;
	uint i=0;
	while(i < view->getDoc()->numLines())
	{
		s = view->getDoc()->textLine(i);

		// do we have a line that starts with ALT or OPT?
		if ( reOptional.search( s ) >= 0 )
		{
				// yes! capture type and entry
				TQString type = reOptional.cap( 2 );
				TQString entry = reOptional.cap( 3 );
				view->getDoc()->removeLine( i );
				view->getDoc()->setModified(true);
				if ( reNonEmptyEntry.search( entry ) >= 0 )
				{
					type.append( " = " );
					type.append( entry );
					view->getDoc()->insertLine( i, type );
					++i;
				}
		}
		else
			++i;
	}
	uint j=0;
	for ( i=0; i < view->getDoc()->numLines() ; i++ )
	{
		j = i+1;
		if ( j < view->getDoc()->numLines()  && view->getDoc()->textLine(j).contains( TQRegExp("^\\s*\\}\\s*$") ) )
			{
				s =  view->getDoc()->textLine( i );
				view->getDoc()->removeLine( i );
				s.remove( TQRegExp(",\\s*$") );
				view->getDoc()->setModified( true );
				view->getDoc()->insertLine( i, s);
			}
	}
}

void Kile::includeGraphics()
{
	Kate::View *view = viewManager()->currentTextView();
	if ( !view ) return;

	TQFileInfo fi( view->getDoc()->url().path() );
	KileDialog::IncludeGraphics *dialog = new KileDialog::IncludeGraphics(this, fi.dirPath(), this);

	if ( dialog->exec() == TQDialog::Accepted )
	{
		insertTag(dialog->getTemplate(), "%C", 0,0);
		docManager()->projectAddFile( dialog->getFilename(),true );
	}

	delete dialog;
}

void Kile::slotToggleFullScreen()
{
	//FIXME for TQt 3.3.x we can do: setWindowState(windowState() ^ WindowFullScreen);
	if (!m_pFullScreen->isChecked())
		showNormal();
	else
		showFullScreen();
}

/////////////// QuickPreview (dani) ////////////////

// all calls of QuickPreview will get here, so we can decide what to do
// rewritten Sep 05 2006 to work together with preview in the bottom bar

void Kile::slotQuickPreview(int type)
{
	KILE_DEBUG() << "==Kile::slotQuickPreview()=========================="  << endl;

	Kate::View *view = viewManager()->currentTextView();
	if ( ! view) return;

	Kate::Document *doc = view->getDoc();
	if ( ! doc )
		return;
 
	switch ( type )
	{
		case KileTool::qpSelection:   m_quickPreview->previewSelection(doc);   break;
		case KileTool::qpEnvironment: m_quickPreview->previewEnvironment(doc); break;
		case KileTool::qpSubdocument: m_quickPreview->previewSubdocument(doc); break;
		case KileTool::qpMathgroup:   m_quickPreview->previewMathgroup(doc);   break;
	}
}	

void Kile::citeViewBib()
{
	KILE_DEBUG()  << "===void Kile::citeViewBib()===" << endl;

	DCOPClient *client = kapp->dcopClient();
	TQByteArray params, replyData;
	TQCString replyType;

	TQDataStream stream(params, IO_WriteOnly);
	QCStringList functions,remoteApps,remoteObjs;

 	const TQCString viewBibApp = "kbib"; // currently these things are hardcoded because only kbib supports it
 	const TQCString viewBibObj = "kbibapp";
	const TQCString viewBibFncDef = "TQString cite()";
	const TQCString viewBibFnc = "cite()";

	remoteApps = client->registeredApplications();
	if( !remoteApps.contains(viewBibApp) )
	{
		m_logWidget->printMsg(KileTool::Warning,
		i18n("No ViewBib tool running, trying to start it now"),
		i18n("ViewBib Citation"));
		uint ret = runWith("ViewBib","KBib");
		if( ret == 0 )
			m_logWidget->printMsg(KileTool::Info,
				i18n("Please select the desired bibliographies and re-execute this command"),
				i18n("ViewBib Citation"));
		return;	
	}

	remoteObjs = client->remoteObjects(viewBibApp);
	if( !remoteObjs.contains(viewBibObj) )
	{
		m_logWidget->printMsg(KileTool::Warning,
				      i18n("The ViewBib tool does not have the correct interface"),
				      i18n("ViewBib Citation"));
		return;
	}

	functions = client->remoteFunctions(viewBibApp,viewBibObj);
	if( !functions.contains(viewBibFncDef) )
	{
		m_logWidget->printMsg(KileTool::Warning,
					i18n("The ViewBib tool does not have the correct definition of the cite function"),
					i18n("ViewBib Citation"));
		return;
	}

	if ( !client->call(viewBibApp, viewBibObj, viewBibFnc, params, replyType, replyData) )
	{
		// we should never get here
		kdWarning() << "internal error in viewbib citation" << endl;
		return;
	}
	else{
		TQDataStream reply(replyData, IO_ReadOnly);
		if (replyType == TQSTRING_OBJECT_NAME_STRING)
		{
			TQString result;
			reply >> result;

			if (result.isEmpty())
			{
				m_logWidget->printMsg(KileTool::Warning,
						i18n("No reference selected.\nPlease select a reference first!"),
						i18n("ViewBib Citation"));
			}
			else
			{
				insertTag(KileAction::TagData(i18n("ViewBib Citation"), result, TQString(), result.length()));

			}
		}
	}
}

#include "kile.moc"
