/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2004 by the KFTPGrabber developers
 * Copyright (C) 2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#include "kftpimportkftpplugin.h"

#include <ntqdir.h>
#include <ntqfile.h>

#include <kgenericfactory.h>
#include <tdelocale.h>
#include <tdeconfig.h>
#include <kmdcodec.h>

K_EXPORT_COMPONENT_FACTORY(kftpimportplugin_kftp,
                           KGenericFactory<KFTPImportKftpPlugin>("kftpimportplugin_kftp"))

KFTPImportKftpPlugin::KFTPImportKftpPlugin(TQObject *parent, const char *name, const TQStringList&)
 : KFTPBookmarkImportPlugin(parent, name)
{
  TDEGlobal::locale()->insertCatalogue("kftpgrabber");
}

TQDomDocument KFTPImportKftpPlugin::getImportedXml()
{
  return m_domDocument;
}

void KFTPImportKftpPlugin::import(const TQString &fileName)
{
  m_domDocument.setContent(TQString("<category name=\"%1\"/>").arg(i18n("KFTPGrabber import")));
  
  // There is actually nothing to import, we just have to read the existing XML and
  // remove site ids.
  TQFile file(fileName);
  if (!file.open(IO_ReadOnly)) {
    emit progress(100);
    return;
  }
  
  m_workDocument.setContent(&file);
  file.close();
  
  // Strip all ids
  stripIds();
  
  // Now append the bookmarks
  TQDomNode n = m_workDocument.documentElement().firstChild();
  
  while (!n.isNull()) {
    TQDomNode import = m_domDocument.importNode(n, true);
    m_domDocument.documentElement().appendChild(import);
    
    n = n.nextSibling();
  }
  
  emit progress(100);
}

void KFTPImportKftpPlugin::stripIds(TQDomNode node)
{
  if (node.isNull())
    node = m_workDocument.documentElement();
    
  TQDomNode n = node.firstChild();

  while (!n.isNull()) {
    if (n.toElement().tagName() == "category") {
      if (!n.toElement().hasAttribute("id"))
        n.toElement().removeAttribute("id");
      
      stripIds(n);
    } else if (n.toElement().tagName() == "server") {
      if (n.toElement().hasAttribute("id"))
        n.toElement().removeAttribute("id");
    }
    
    n = n.nextSibling();
  }
}

TQString KFTPImportKftpPlugin::getDefaultPath()
{
  return TQString("");
}

#include "kftpimportkftpplugin.moc"
